/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.move;

import catcat20.jewel.iolite.move.MeleeSurfing;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import catcat20.jewel.iolite.utils.Wave;
import dsekercioglu.roboneural.format.FeatureSplitter;
import dsekercioglu.roboneural.net.ActivationFunction;
import dsekercioglu.roboneural.net.MultiLayerPerceptron;
import dsekercioglu.roboneural.net.Sigmoid;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.util.Utils;

public class HitLearnModel {
    int BINS = MeleeSurfing.BINS;
    public MultiLayerPerceptron mlp = new MultiLayerPerceptron(new int[]{18, 10, this.BINS}, new ActivationFunction[]{new Sigmoid(), new Sigmoid()}, 0.2, 1);
    final ArrayList<double[]> INPUTS = new ArrayList();
    final ArrayList<double[]> OUTPUTS = new ArrayList();
    final int PAST = 15;
    int[] RESOLUTIONS = new int[]{9, 9, 9, 9, 9, 9, 9};
    double[] PROBABILITIES = new double[]{0.5, 0.4, 0.4, 0.3, 0.3, 0.2, 0.1};
    double[] predictData = new double[this.BINS];

    public HitLearnModel(int[] RESOLUTIONS, double[] PROBABILITIES) {
        this.RESOLUTIONS = RESOLUTIONS;
        this.PROBABILITIES = PROBABILITIES;
    }

    public double[] dataPoint(Wave w) {
        BotState en = w.enemyData;
        BotState my = w.myData;
        double bft = w.enemyData.distance / w.bulletVelocity();
        return new double[]{(my.latVel + 8.0) / 16.0, (my.advVel + 8.0) / 16.0, bft / 130.0, IUtils.accel(my.oldVelocity, my.oldVelocity), IUtils.accel(my.oldLatVel, my.latVel), 1.0 / (1.0 + my.timeSinceDecel), 1.0 / (1.0 + my.dirChangeTime), 1.0 / (1.0 + my.vChangeTimer)};
    }

    public double[] predict(Wave w) {
        double[] processedData = FeatureSplitter.split(this.dataPoint(w), this.RESOLUTIONS);
        int n = 0;
        for (int j = 0; j < this.RESOLUTIONS.length; ++j) {
            if (Math.random() > this.PROBABILITIES[j]) {
                for (int i = n; i < n + this.RESOLUTIONS[j]; ++i) {
                    processedData[i] = 0.0;
                }
            }
            n += this.RESOLUTIONS[j];
        }
        this.predictData = this.mlp.getOutput(FeatureSplitter.split(this.dataPoint(w), this.RESOLUTIONS));
        return this.predictData;
    }

    public double[] getPredictData() {
        return this.predictData;
    }

    public void learn(Wave w, Point2D.Double myPos) {
        double[] input = FeatureSplitter.split(this.dataPoint(w), this.RESOLUTIONS);
        double[] output = new double[this.BINS];
        double offsetAngle = IUtils.absoluteBearing(w, myPos) - w.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / IUtils.maxEscapeAngle(w.bulletVelocity()) * w.direction;
        int bin = (int)IUtils.limit(0.0, factor * (double)((this.BINS - 1) / 2) + (double)((this.BINS - 1) / 2), this.BINS - 1);
        for (int x = 0; x < this.BINS; ++x) {
            int n = x;
            output[n] = output[n] + 1.0 / (Math.pow(bin - x, 2.0) + 1.0);
        }
        this.INPUTS.add(0, input);
        this.OUTPUTS.add(0, output);
        if (this.INPUTS.size() == 15) {
            this.INPUTS.remove(14);
            this.OUTPUTS.remove(14);
        }
        this.mlp.backPropogate(input, output);
    }

    public void update() {
    }
}

