/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.utils;

import catcat20.jewel.iolite.gun.Gun;
import catcat20.jewel.iolite.gun.IoliteGun;
import catcat20.jewel.iolite.gun.fpGun.FPData;
import catcat20.jewel.iolite.gun.fpGun.ForwardPatternMatcher;
import catcat20.jewel.iolite.gun.gf.GunModels;
import catcat20.jewel.iolite.gun.pif.PIFData;
import catcat20.jewel.iolite.knnUtils.DangerModel;
import catcat20.jewel.iolite.knnUtils.Data;
import catcat20.jewel.iolite.knnUtils.FPWeightLearn;
import catcat20.jewel.iolite.knnUtils.KNNModel;
import catcat20.jewel.iolite.knnUtils.WeightedData;
import catcat20.jewel.iolite.move.HitLearnModel;
import catcat20.jewel.iolite.move.MainLearnModel;
import catcat20.jewel.iolite.move.SurfModels;
import catcat20.jewel.iolite.radar.IoliteRadar;
import catcat20.jewel.iolite.utils.IUtils;
import catcat20.jewel.iolite.utils.MovementPredictor;
import catcat20.jewel.iolite.utils.Wave;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.MaxHeap;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.secondGenKD.KdTree;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.ManhattanDistanceFunction;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.SquareEuclideanDistanceFunction;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.util.Utils;

public class BotState
extends Point2D.Double {
    public HashMap<Gun, GunCount> gunHitRate = new HashMap();
    public double heading;
    public double oldHeading;
    public double velocity;
    public double oldVelocity;
    public double energy = 100.0;
    public double oldEnergy = 100.0;
    public double energyChange;
    public double gunHeat = Rules.getGunHeat((double)3.0);
    public double distance;
    public double bearing;
    public double absBearing;
    public long lastScanTime = 0L;
    public long lastLastScanTime = 0L;
    public boolean alive = true;
    public double dirChangeTime;
    public double timeSinceDecel;
    public double vChangeTimer;
    public double latVel;
    public double oldLatVel;
    public double advVel;
    public double oldAdvVel;
    public double shotsFired;
    public long lastFireTime;
    public double virtuality;
    public double[] meas;
    public double currentGF;
    public String name;
    public BotState myState;
    public ArrayList<Double> absBearings;
    public ArrayList<Double> distances;
    public ArrayList<Double> latVels;
    public ArrayList<Double> advVels;
    public ArrayList<Integer> directions;
    public ArrayList<Point2D.Double> oldPositions;
    public ArrayList<BotState> thisOldStates;
    public ArrayList<KNNModel<Data>> surfTickFlattenerModels;
    public ArrayList<DangerModel<Data>> surfQuickModels;
    public ArrayList<KNNModel<Data>> surfFlattenerModels;
    public ArrayList<KNNModel<Data>> surfKNNModels;
    public ArrayList<KNNModel<Data>> surfMeleeKNNModels;
    public ArrayList<KNNModel<Data>> surfAntiRamModels;
    public int pifID = 0;
    public KdTree<Double> bulletPowerPredictor;
    public KdTree.WeightedManhattan<FPData> fpTree;
    public ForwardPatternMatcher.FPWave lastWave;
    public double[] fpWeights;
    public FPWeightLearn[] fpLearnWeights;
    public double[] fpBaseWeights;
    public static int fpWeightLength = 0;
    public KdTree.WeightedSqrEuclid<PIFData> meleePifTree;
    public KdTree.WeightedSqrEuclid<PIFData> pifTree;
    public PIFData lastPIFData;
    public KdTree.SqrEuclid<Double> gfTree;
    public double[] gfWeights;
    public ArrayList<KNNModel<Data>> gfKNNModels;
    public ArrayList<KNNModel<Data>> gfSecondKNNModels;
    public ArrayList<KNNModel<Data>> gfASKNNModels;
    public ArrayList<KNNModel<Data>> gfSimpleKNNModels;
    public MainLearnModel moveModel;
    public HitLearnModel moveHitModel;
    public MainLearnModel moveMeleeModel;
    public HitLearnModel moveMeleeHitModel;
    public Rectangle2D.Double rect;
    static ManhattanDistanceFunction manhattanDistanceFunction = new ManhattanDistanceFunction();

    public BotState(boolean isMyState) {
        this.absBearings = new ArrayList();
        this.distances = new ArrayList();
        this.latVels = new ArrayList();
        this.advVels = new ArrayList();
        this.directions = new ArrayList();
        this.oldPositions = new ArrayList();
        this.thisOldStates = new ArrayList();
    }

    public BotState(Rectangle2D.Double rect) {
        this.rect = rect;
        this.myState = new BotState(true);
        this.absBearings = new ArrayList();
        this.distances = new ArrayList();
        this.latVels = new ArrayList();
        this.advVels = new ArrayList();
        this.directions = new ArrayList();
        this.oldPositions = new ArrayList();
        this.thisOldStates = new ArrayList();
        this.moveModel = new MainLearnModel(new int[]{9, 9, 9, 9, 9, 9, 9, 9}, new double[]{0.5, 0.5, 0.3, 0.2, 0.3, 0.2, 0.3, 0.1});
        this.moveHitModel = new HitLearnModel(new int[]{9, 9, 9, 9, 9, 9, 9, 9}, new double[]{0.5, 0.5, 0.3, 0.2, 0.3, 0.2, 0.3, 0.1});
        this.moveMeleeModel = new MainLearnModel(new int[]{9, 9, 9, 9, 9, 9, 9, 9}, new double[]{0.5, 0.5, 0.3, 0.2, 0.3, 0.2, 0.3, 0.1});
        this.moveMeleeHitModel = new HitLearnModel(new int[]{9, 9, 9, 9, 9, 9, 9, 9}, new double[]{0.5, 0.5, 0.3, 0.2, 0.3, 0.2, 0.3, 0.1});
        this.surfKNNModels = new ArrayList();
        this.surfKNNModels.add(SurfModels.normalModel(10, 5, 40));
        this.surfKNNModels.add(SurfModels.normal2Model(10, 5, 40));
        this.surfKNNModels.add(SurfModels.normal11Model(10, 5, 40));
        this.surfKNNModels.add(SurfModels.normal12Model(10, 5, 40));
        this.surfKNNModels.add(SurfModels.toBeepBoopModel());
        this.surfKNNModels.add(SurfModels.toBeepBoopASModel());
        this.surfKNNModels.add(SurfModels.toDrussGTModel());
        this.surfKNNModels.add(SurfModels.toKomariousModel());
        String[] dataNames = new String[]{"distance", "bft", "myDistLast10", "myDistLast16", "myDistLast35", "myVirtuality", "myVel", "myAbsVel", "myAbsLatVel", "myAbsAdvVel", "myLatVel", "myAdvVel", "myAccel", "myForwardPreciseMEA", "myReversePreciseMEA", "myTimeSinceDecel", "myTimeSinceDecelPerTick", "myCurrentGF", "myDirChangeTime", "myTimeSinceDecelPerTick", "myVChangeTime", "meaWallAhead", "meaWallReverse", "orbitalWallAhead", "orbitalWallReverse", "myRelativeHeadingSin", "myRelativeHeadingCos"};
        double[] dataWeights = new double[]{3.0, 3.0, 2.0, 2.0, 2.0, 0.75, 1.0, 3.0, 5.0, 5.0, 4.0, 2.0, 1.0, 2.0, 2.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0};
        this.surfQuickModels = new ArrayList();
        this.surfQuickModels.add(SurfModels.hotModel());
        this.surfQuickModels.add(SurfModels.linearModel());
        this.surfFlattenerModels = new ArrayList();
        this.surfFlattenerModels.add(SurfModels.toDrussGTFlattenerModel());
        this.surfFlattenerModels.add(SurfModels.toBeepBoopASFlattenerModel());
        this.surfFlattenerModels.add(SurfModels.toBeepBoopFlattenerModel());
        this.surfFlattenerModels.add(SurfModels.flattenerModel(40, 5, 20));
        this.surfFlattenerModels.add(SurfModels.flattenerModel(25, 20, 50));
        this.surfFlattenerModels.add(SurfModels.flattenerModel(1, 15, 100));
        this.surfTickFlattenerModels = new ArrayList();
        this.surfTickFlattenerModels.add(SurfModels.flattenerModel(10, 30, 125));
        this.surfAntiRamModels = new ArrayList();
        this.surfAntiRamModels.add(SurfModels.antiRamModel());
        this.surfMeleeKNNModels = new ArrayList();
        this.surfMeleeKNNModels.add(SurfModels.toDrussGTModel());
        this.bulletPowerPredictor = new KdTree(4);
        double[] fpWeights = new double[]{3.0, 4.75, 4.75, 5.25, 3.5, 5.5, 3.25, 2.0, 2.0, 0.75, 0.75, 0.75, 1.0, 1.0, 1.25, 0.01, 1.25, 1.25, 1.5, 2.125};
        this.fpTree = new KdTree.WeightedManhattan(fpWeights.length, 30000);
        this.setFPWeights(fpWeights);
        this.fpTree.setWeights(fpWeights);
        this.fpWeights = (double[])fpWeights.clone();
        fpWeightLength = fpWeights.length;
        this.fpBaseWeights = new double[]{3.0, 4.75, 4.75, 5.25, 3.5, 5.5, 3.25, 2.0, 2.0, 0.75, 0.75, 0.75, 1.0, 1.0, 1.25, 0.01, 1.25, 1.25, 1.5, 2.125};
        double[] pifWeights = new double[]{0.39492366247561916, 4.49271605943244, 7.225312279812151, 3.6028266499519948, 4.573681694972639, 9.523391712448051, 3.0298160150128184, 1.6789323090477826, 2.3909333955922794, 8.665019203984063};
        this.pifTree = new KdTree.WeightedSqrEuclid(pifWeights.length, 50000);
        this.pifTree.setWeights(pifWeights);
        this.meleePifTree = new KdTree.WeightedSqrEuclid(pifWeights.length, 50000);
        this.meleePifTree.setWeights(pifWeights);
        this.gfKNNModels = new ArrayList();
        this.gfKNNModels.add(GunModels.mainGunModel());
        this.gfASKNNModels = new ArrayList();
        this.gfASKNNModels.add(GunModels.antiSurferModel());
        this.gfSecondKNNModels = new ArrayList();
        this.gfSecondKNNModels.add(GunModels.pifGunModel());
        this.gfSimpleKNNModels = new ArrayList();
        this.gfSimpleKNNModels.add(GunModels.simpleGunModel());
        this.gfTree = new KdTree.SqrEuclid(14, 30000);
        for (Gun gun : IoliteGun.guns) {
            this.gunHitRate.put(gun, new GunCount());
        }
        this.gunHitRate.get((Object)IoliteGun.pifGun).shotCount += 1.0;
    }

    public String getNearestBot(Point2D.Double pos, String myName) {
        String nearestBotName = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (BotState en : IoliteRadar.enemies.values()) {
            if (Objects.equals(en.name, this.name) || !(this.distanceSq(en) < nearestDistance)) continue;
            nearestDistance = this.distanceSq(en);
            nearestBotName = en.name;
        }
        if (this.distanceSq(pos) < nearestDistance) {
            nearestBotName = myName;
        }
        return nearestBotName;
    }

    public void setFPWeights(double ... weights) {
        this.fpLearnWeights = new FPWeightLearn[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            double weight = weights[i];
            this.fpLearnWeights[i] = new FPWeightLearn(weight, i);
        }
    }

    public void init() {
    }

    public double predictPower(AdvancedRobot robot) {
        MaxHeap<Double> heap = null;
        if (this.bulletPowerPredictor.size() > 0) {
            heap = this.bulletPowerPredictor.findNearestNeighbors(new double[]{this.distance / 1300.0 * 3.0, this.energy / 120.0 * 5.0, robot.getEnergy() / 120.0 * 1.0, robot.getOthers()}, 1, new SquareEuclideanDistanceFunction());
        }
        if (heap != null) {
            return (Double)heap.getMax();
        }
        return 1.95;
    }

    public void update(AdvancedRobot robot) {
        this.absBearings.add(0, this.absBearing + Math.PI);
        this.distances.add(0, this.distance);
        this.latVels.add(0, this.latVel);
        this.advVels.add(0, this.advVel);
        this.directions.add(0, IUtils.sign(this.latVel));
        this.oldPositions.add(0, (Point2D.Double)this.clone());
        if (this.energyChange > 0.0 && this.energyChange < 3.01) {
            this.bulletPowerPredictor.addPoint(new double[]{this.distance / 1300.0 * 3.0, this.energy / 120.0 * 5.0, robot.getEnergy() / 120.0 * 1.0, robot.getOthers()}, (Object)this.energyChange);
        }
        this.vChangeTimer += 1.0;
        if (this.oldVelocity != this.velocity) {
            this.vChangeTimer = 0.0;
        }
        this.dirChangeTime += 1.0;
        if (IUtils.sign(this.oldLatVel) != IUtils.sign(this.latVel)) {
            this.dirChangeTime = 0.0;
        }
        long time = robot.getTime();
        this.meas = this.getMea(this, this.myState, time);
        this.myState.x = robot.getX();
        this.myState.y = robot.getY();
        this.myState.oldVelocity = this.myState.velocity;
        this.myState.velocity = robot.getVelocity();
        double latVel = this.myState.velocity * Math.sin(this.bearing);
        double advVel = this.myState.velocity * -Math.cos(this.bearing);
        this.myState.absBearing = this.absBearing + 0.0;
        this.myState.distance = this.distance;
        this.myState.oldLatVel = this.myState.latVel;
        this.myState.latVel = latVel;
        this.myState.oldAdvVel = this.myState.advVel;
        this.myState.advVel = advVel;
        this.myState.gunHeat = robot.getGunHeat();
        this.myState.heading = robot.getHeadingRadians();
        this.myState.oldEnergy = this.myState.energy;
        this.myState.energy = robot.getEnergy();
        this.myState.dirChangeTime += 1.0;
        if (IUtils.sign(this.myState.oldLatVel) != IUtils.sign(this.myState.latVel)) {
            this.myState.dirChangeTime = 0.0;
        }
        this.myState.timeSinceDecel += 1.0;
        if (this.myState.oldVelocity > this.myState.velocity) {
            this.myState.timeSinceDecel = 0.0;
        }
        this.myState.vChangeTimer += 1.0;
        if (this.myState.oldVelocity != this.myState.velocity) {
            this.myState.vChangeTimer = 0.0;
        }
        this.myState.absBearings.add(0, this.absBearing);
        this.latVels.add(0, latVel);
        this.advVels.add(0, advVel);
        this.myState.distances.add(0, this.distance);
        this.myState.directions.add(0, IUtils.sign(latVel));
        this.myState.oldPositions.add(0, (Point2D.Double)this.myState.clone());
        this.myState.meas = this.getMea(this.myState, this, time);
        this.thisOldStates.add(0, (BotState)this.clone());
        this.myState.thisOldStates.add(0, (BotState)this.myState.clone());
    }

    public double effectiveHeading() {
        return Utils.normalAbsoluteAngle((double)(this.heading + (IUtils.sign(this.velocity) == 1 ? 0.0 : Math.PI)));
    }

    public double[] getMea(BotState en, Point2D.Double myPos, long time) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.x, en.y, en.heading, en.velocity, time);
        double power = IoliteRadar.calculatePower();
        double bft = en.distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = myPos.distance(dir1);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = IUtils.absoluteBearing(dir1, myPos) + 1.5707963267948966;
            angle = this.wallSmoothing(dir1, angle, -1);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = myPos.distance(dir2);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = IUtils.absoluteBearing(dir2, myPos) - 1.5707963267948966;
            angle = this.wallSmoothing(dir2, angle, 1);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
        }
        double mea1 = Utils.normalRelativeAngle((double)(IUtils.absoluteBearing(myPos, dir1) - en.absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(IUtils.absoluteBearing(myPos, dir2) - en.absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!this.rect.contains(IUtils.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public ArrayList<WeightedData<Data>> getMainGunNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.gfKNNModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.list = model.getNearestNeighbor(w, new SquareEuclideanDistanceFunction());
            list.add(data);
        }
        return list;
    }

    public void putMainGunLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.gfKNNModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public ArrayList<WeightedData<Data>> getAntiSurferGunNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.gfASKNNModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.list = model.getNearestNeighbor(w, new SquareEuclideanDistanceFunction());
            list.add(data);
        }
        return list;
    }

    public void putAntiSurferGunLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.gfASKNNModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public ArrayList<WeightedData<Data>> getSimpleGunNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.gfSimpleKNNModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.list = model.getNearestNeighbor(w, new SquareEuclideanDistanceFunction());
            list.add(data);
        }
        return list;
    }

    public void putSimpleGunLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.gfSimpleKNNModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public ArrayList<WeightedData<Data>> getSecondGunNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.gfSecondKNNModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.list = model.getNearestNeighbor(w, new SquareEuclideanDistanceFunction());
            list.add(data);
        }
        return list;
    }

    public void putSecondGunLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.gfSecondKNNModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public ArrayList<WeightedData<Data>> getQuickTargetingNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (DangerModel<Data> model : this.surfQuickModels) {
            Data data = new Data();
            data.treeWeight = model.modelWeight;
            data.weight = 1.0;
            if (Objects.equals(model.name, "HOT")) {
                data.guessFactor = w.guessFactor(IUtils.project(w, w.directAngle, 1000.0));
            } else if (Objects.equals(model.name, "Linear")) {
                data.guessFactor = w.guessFactor(IUtils.project(w, w.directAngle + w.linear, 1000.0));
            }
            WeightedData weightedData = new WeightedData();
            weightedData.listData = new ArrayList();
            weightedData.listData.add(data);
            weightedData.treeWeight = model.modelWeight;
            weightedData.modelPointer = model;
            list.add(weightedData);
        }
        return list;
    }

    public ArrayList<WeightedData<Data>> getSurfNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.surfKNNModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.modelPointer = model;
            data.list = model.getNearestNeighbor(w, manhattanDistanceFunction);
            list.add(data);
        }
        return list;
    }

    public void putSurfLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.surfKNNModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public ArrayList<WeightedData<Data>> getSurfTickFlattenerNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.surfTickFlattenerModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.modelPointer = model;
            data.list = model.getNearestNeighbor(w, manhattanDistanceFunction);
            list.add(data);
        }
        return list;
    }

    public void putSurfTickFlattenerLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.surfTickFlattenerModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public ArrayList<WeightedData<Data>> getSurfFlattenerNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.surfFlattenerModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.modelPointer = model;
            data.list = model.getNearestNeighbor(w, manhattanDistanceFunction);
            list.add(data);
        }
        return list;
    }

    public void putSurfFlattenerLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.surfFlattenerModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public ArrayList<WeightedData<Data>> getSurfAntiRamNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.surfAntiRamModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.modelPointer = model;
            data.list = model.getNearestNeighbor(w, manhattanDistanceFunction);
            list.add(data);
        }
        return list;
    }

    public void putSurfAntiRamLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.surfAntiRamModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public ArrayList<WeightedData<Data>> getMeleeSurfNeighbors(Wave w) {
        ArrayList<WeightedData<Data>> list = new ArrayList<WeightedData<Data>>();
        for (KNNModel<Data> model : this.surfMeleeKNNModels) {
            WeightedData data = new WeightedData();
            data.treeWeight = model.modelWeight;
            data.modelPointer = model;
            data.list = model.getNearestNeighbor(w, manhattanDistanceFunction);
            list.add(data);
        }
        return list;
    }

    public void putSurfMeleeLog(Wave w, Data data) {
        for (KNNModel<Data> model : this.surfMeleeKNNModels) {
            model.tree.addPoint(model.dataPoint(w), data);
        }
    }

    public double orbitalWallDistance(Rectangle2D.Double rect, BotState myState, BotState enemyState, int orbitDirection, double maxEscapeAngle, boolean isForward) {
        Point2D.Double enemyProjectedLocation;
        double wallDistance;
        if (!isForward) {
            orbitDirection *= -1;
        }
        double absoluteBearing = IUtils.absoluteBearing(myState, enemyState);
        double distance = myState.distance(enemyState);
        for (wallDistance = 0.0; wallDistance < 1.5 * maxEscapeAngle + 0.01 && rect.contains(enemyProjectedLocation = IUtils.project(myState, absoluteBearing + (double)orbitDirection * wallDistance, distance)); wallDistance += 0.01) {
        }
        wallDistance /= maxEscapeAngle;
        wallDistance = Math.min(wallDistance, 1.5);
        return wallDistance;
    }

    public static class GunCount {
        public double hitCount;
        public double shotCount;
    }
}

