/*
 * Decompiled with CFR 0.152.
 */
package syl.fire;

import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.fire.FireStrategy;
import syl.fire.VirtualBullet;
import syl.util.Angle;
import syl.util.Coordinate;
import syl.util.Log;
import syl.util.RobotMath;

public class PredictiveFireStrategy
extends FireStrategy {
    public PredictiveFireStrategy(BaseRobot robot) {
        super(robot);
    }

    public boolean isEvasiveFireStrategy() {
        return false;
    }

    public void initialize() {
        this.getRobot().setAdjustGunForRobotTurn(true);
    }

    public void cleanUp() {
        Log.log(this, "Cleaning up.");
    }

    public Coordinate getFuturePosition(Enemy enemy, double firePower) {
        Coordinate targetCoordinate = new Coordinate(enemy.getCoordinate().getX(), enemy.getCoordinate().getY());
        int i = 0;
        while (i < 15) {
            double distance = targetCoordinate.getDistance(this.getRobot().getCoordinate());
            long time = this.getRobot().getTime() + (long)((int)Math.round(distance / RobotMath.getBulletVelocity(firePower)));
            int enemyReactionTime = (int)(time - enemy.getScanTime());
            double changeHeading = Angle.toRelativeAngle(enemy.getHeading() - enemy.getOldHeading()) / (double)(enemy.getScanTime() - enemy.getOldScanTime());
            double speed = enemy.getVelocity();
            double x = enemy.getCoordinate().getX();
            double y = enemy.getCoordinate().getY();
            double heading = enemy.getHeading();
            int j = 0;
            while (j < enemyReactionTime) {
                x += Math.sin(Math.toRadians(heading)) * speed;
                y += Math.cos(Math.toRadians(heading)) * speed;
                heading += changeHeading;
                ++j;
            }
            targetCoordinate.setX(x);
            targetCoordinate.setY(y);
            ++i;
        }
        return targetCoordinate;
    }

    public void bulletMissed(VirtualBullet trackingBullet) {
    }

    public void bulletHit(VirtualBullet trackingBullet) {
    }
}

