/*
 * Decompiled with CFR 0.152.
 */
package syl.movement.gravity;

import syl.util.Coordinate;

public class GravityPoint {
    private Coordinate coordinate;
    private double power;
    private double range;
    public static final double ATT_STRONG = 3000.0;
    public static final double ATT_MEDIUM = 2000.0;
    public static final double ATT_WEAK = 1000.0;
    public static final double REP_WALL = -4000.0;
    public static final double REP_STRONG = -3000.0;
    public static final double REP_MEDIUM = -2000.0;
    public static final double REP_WEAK = -1000.0;
    public static final double REP_FLY = -5.0;
    public static final double RANGE_FAR = 1.5;
    public static final double RANGE_MEDIUM = 2.0;
    public static final double RANGE_CLOSE = 3.0;
    public static final double RANGE_WALL = 2.5;

    public GravityPoint(Coordinate coordinate, double power, double range) {
        this.coordinate = coordinate;
        this.power = power;
        this.range = range;
    }

    public double getXForce(Coordinate targetCoordinate) {
        double force = this.power / Math.pow(this.coordinate.getDistance(targetCoordinate), this.range);
        double angle = targetCoordinate.getAngle(this.coordinate);
        return Math.sin(Math.toRadians(angle)) * force;
    }

    public double getYForce(Coordinate targetCoordinate) {
        double force = this.power / Math.pow(this.coordinate.getDistance(targetCoordinate), this.range);
        double angle = targetCoordinate.getAngle(this.coordinate);
        return Math.cos(Math.toRadians(angle)) * force;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    public void setX(double x) {
        this.coordinate.setX(x);
    }

    public void setY(double y) {
        this.coordinate.setY(y);
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double range) {
        this.range = range;
    }
}

