/*
 * Decompiled with CFR 0.152.
 */
package dk.move;

import dk.Base;
import dk.Point;
import dk.Util;
import dk.move.Magnetic;
import dk.move.MagneticSourceController;
import java.util.ArrayList;
import java.util.List;
import robocode.Robot;

public class MagneticRandomDestination
extends MagneticSourceController {
    protected Magnetic.Source destination;
    protected int countDown = 0;

    public Magnetic.Source createDestination(Point p, double strength) {
        return new Magnetic.StaticSource(p, strength);
    }

    public void setRandomDestination(Base robot) {
        this.countDown = (int)(Math.random() * robot.config.MAGNETIC_DEST_COUNTDOWN_JITTER + robot.config.MAGNETIC_DEST_COUNTDOWN_MIN);
        Point p = new Point(Math.random() * robot.getBattleFieldWidth(), Math.random() * robot.getBattleFieldHeight());
        p = Util.clamp(p);
        this.destination = this.createDestination(p, robot.config.MAGNETIC_DEST_STRENGTH);
        if (robot.debug) {
            ((Robot)robot).out.println("set new destination");
        }
    }

    public List getMagneticSources(Base robot) {
        double range = 0.0;
        if (this.destination != null) {
            range = Util.range(robot.getPosition(), this.destination.getPosition());
        }
        --this.countDown;
        if (this.countDown <= 0 || range < robot.config.MAGNETIC_DEST_EPSILON) {
            this.setRandomDestination(robot);
        }
        ArrayList<Magnetic.Source> l = new ArrayList<Magnetic.Source>(1);
        l.add(this.destination);
        return l;
    }
}

