/*
 * Decompiled with CFR 0.152.
 */
package eem.gun;

import eem.misc.graphics;
import eem.misc.logger;
import eem.misc.math;
import eem.misc.physics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class firingSolution {
    public double firingAngle;
    public long firedTime;
    public double bulletEnergy;
    public Point2D.Double firingPosition;
    public Point2D.Double targetPosition;

    public firingSolution() {
        this.firingAngle = Double.NaN;
        this.firingPosition = null;
        this.targetPosition = null;
    }

    public firingSolution(Point2D.Double double_, double d, long l, double d2) {
        this.firingAngle = d;
        this.firingPosition = (Point2D.Double)double_.clone();
        this.firedTime = l;
        this.targetPosition = null;
        this.bulletEnergy = d2;
    }

    public firingSolution(Point2D.Double double_, Point2D.Double double_2, long l, double d) {
        this.firingAngle = math.angle2pt(double_, double_2);
        this.firingPosition = (Point2D.Double)double_.clone();
        this.firedTime = l;
        this.targetPosition = (Point2D.Double)double_2.clone();
        this.bulletEnergy = d;
    }

    public double smallestDistanceToBulletPath(Point2D.Double double_) {
        double d = math.game_angles2cortesian(this.firingAngle);
        double d2 = Math.cos(Math.toRadians(d));
        double d3 = Math.sin(Math.toRadians(d));
        double d4 = double_.x - this.firingPosition.x;
        double d5 = double_.y - this.firingPosition.y;
        double d6 = Math.abs(d2 * d5 - d3 * d4);
        return d6;
    }

    public double getDanger(long l, Point2D.Double double_) {
        double d = 0.0;
        double d2 = physics.robotHalfSize;
        double d3 = 1.0;
        double d4 = this.smallestDistanceToBulletPath(double_);
        if (d4 <= Math.sqrt(2.0) * (double)physics.robotHalfSize) {
            d += d3;
        }
        return d += d3 * Math.exp(-d4 / d2);
    }

    public double getDistanceTraveledAtTime(long l) {
        double d = l - this.firedTime;
        double d2 = d * physics.bulletSpeed(this.bulletEnergy);
        return d2;
    }

    public String toString() {
        String string = "";
        string = string + "Firing solultion at time: " + this.firedTime + "\n";
        string = string + "firingPosition" + this.firingPosition + ":\n";
        string = string + "firingAngle" + this.firingAngle + ":\n";
        if (this.targetPosition != null) {
            string = string + "targerPosition" + this.firingPosition + ":\n";
        }
        return string;
    }

    public void onPaint(Graphics2D graphics2D, long l) {
        if (this.firingPosition == null) {
            logger.error("This should not happen: the firing solution does not have firingPosition");
        } else {
            graphics2D.setColor(new Color(255, 0, 0, 255));
            graphics.drawRect(graphics2D, this.firingPosition, 20.0, 20.0);
        }
        if (this.targetPosition != null) {
            graphics2D.setColor(new Color(255, 0, 0, 255));
            graphics.drawRect(graphics2D, this.targetPosition, 20.0, 20.0);
        }
        if (this.firingAngle == Double.NaN) {
            logger.error("This should not happen: the firing solution does not have firingAngle");
        } else {
            graphics2D.setColor(new Color(255, 0, 0, 255));
            double d = this.getDistanceTraveledAtTime(l) - 5.0;
            double d2 = math.game_angles2cortesian(this.firingAngle);
            double d3 = d * Math.cos(Math.toRadians(d2));
            double d4 = d * Math.sin(Math.toRadians(d2));
            Point2D.Double double_ = new Point2D.Double(this.firingPosition.x + d3, this.firingPosition.y + d4);
            graphics.drawLine(graphics2D, this.firingPosition, double_);
        }
    }

    public void onPaint(Graphics2D graphics2D) {
        if (this.firingPosition == null) {
            logger.error("This should not happen: the firing solution does not have firingPosition");
        } else {
            graphics2D.setColor(new Color(255, 0, 0, 255));
            graphics.drawRect(graphics2D, this.firingPosition, 20.0, 20.0);
        }
        if (this.targetPosition != null) {
            graphics2D.setColor(new Color(255, 0, 0, 255));
            graphics.drawRect(graphics2D, this.targetPosition, 20.0, 20.0);
        }
        if (this.firingAngle == Double.NaN) {
            logger.error("This should not happen: the firing solution does not have firingAngle");
        } else {
            graphics2D.setColor(new Color(255, 0, 0, 255));
            if (this.targetPosition != null) {
                graphics.drawLine(graphics2D, this.firingPosition, this.targetPosition);
            } else {
                double d = 30.0;
                double d2 = math.game_angles2cortesian(this.firingAngle);
                double d3 = Math.cos(Math.toRadians(d2));
                double d4 = Math.sin(Math.toDegrees(d2));
                Point2D.Double double_ = new Point2D.Double(this.firingPosition.x + d3, this.firingPosition.y + d4);
                graphics.drawLine(graphics2D, this.firingPosition, double_);
            }
        }
    }
}

