/*
 * Decompiled with CFR 0.152.
 */
package nic;

import nic.Nicator;

public class HelperFunctions {
    Nicator rob;
    final double PI = Math.PI;

    public HelperFunctions(Nicator pRob) {
        this.rob = pRob;
    }

    public double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double normaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }
}

