/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.BasicWave;
import Krabb.sliNk.Data;
import Krabb.sliNk.DataHandling;
import Krabb.sliNk.DrawingBot;
import Krabb.sliNk.Garm;
import Krabb.sliNk.GunStatistics;
import Krabb.sliNk.MyBullet;
import Krabb.sliNk.Stats;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MyWave
extends BasicWave
implements Cloneable,
Comparable<MyWave> {
    Color color = Color.blue;
    double[][][] gf_hit_simulated;
    boolean simulated_passed = false;
    ArrayList<Energy> energy_changes = new ArrayList();
    ArrayList<MyWave> waves_linked = null;
    double probability = 1.0;
    boolean last = true;
    HashMap<Bullet, BulletCollisionRegion> bullet_collisions = new HashMap();
    HashMap<Bullet, BulletCollisionRegion> bullet_collisions_new = new HashMap();
    public static int binsmoothing_nsigma = 35;
    public static int binsmoothing_range = 75;
    public static double[][] binsmoothing_lut = null;
    static final int XXXX = 0;

    MyWave() {
        if (binsmoothing_lut == null) {
            binsmoothing_lut = new double[binsmoothing_nsigma][binsmoothing_range + 1];
            int d = 0;
            while (d <= binsmoothing_range) {
                MyWave.binsmoothing_lut[0][d] = 0.0;
                ++d;
            }
            MyWave.binsmoothing_lut[0][0] = 1.0;
            int s = 1;
            while (s < binsmoothing_nsigma) {
                int d2 = 0;
                while (d2 <= binsmoothing_range) {
                    MyWave.binsmoothing_lut[s][d2] = MyWave.gau\u00dfCurve(d2, 0.0, (double)s / 2.0);
                    ++d2;
                }
                ++s;
            }
        }
        this.offset_botwidth = 22.0;
        this.virtual = false;
        this.victim_quantity = 1;
        this.victim_stats_segmentation = new Stats[this.victim_quantity];
        this.victim_stats_start = new Stats[this.victim_quantity];
        this.victim_stats_end = new Stats[this.victim_quantity];
        this.direction_start = new int[this.victim_quantity];
        this.hit = new boolean[this.victim_quantity];
        this.gf_null_angle = new double[this.victim_quantity];
        this.gf_hit_angles = new double[this.victim_quantity][1];
        this.gf_max_angles = new double[this.victim_quantity][5][2];
        this.gf_hit_simulated = new double[this.victim_quantity][][];
        this.BasicWaveConst();
    }

    @Override
    public int compareTo(MyWave wave) {
        double dist_me = Garm.stats_my.location.distance(this.source_stats_start.location);
        double time_impackt_me = (double)this.source_stats_start.time + dist_me / this.velocity;
        double dist_he = Garm.stats_my.location.distance(wave.source_stats_start.location);
        double time_impackt_he = (double)wave.source_stats_start.time + dist_he / wave.velocity;
        return (int)((time_impackt_me - time_impackt_he) * 1000.0);
    }

    public void setSegmentationStats(Stats stats_segmentation, Stats victim_stats_segmentation) {
        this.source_stats_segmentation = stats_segmentation;
        this.victim_stats_segmentation[0] = victim_stats_segmentation;
    }

    public void setStartStats(Stats stats_start, Stats victim_stats_start) {
        this.source_stats_start = stats_start;
        this.victim_stats_start[0] = victim_stats_start;
    }

    public void setEndStats(Stats stats_end, Stats victim_stats_end) {
        this.source_stats_end = stats_end;
        this.victim_stats_end[0] = victim_stats_end;
    }

    public void calculateSegmentation() {
        this.direction_start[0] = DataHandling.movedirection_angular(this.source_stats_segmentation, this.victim_stats_segmentation[0]);
        super.calculateSegmentation(0);
        this.bins = new double[this.victim_quantity][GunStatistics.statistics_n][];
        this.bins_factored = new double[this.victim_quantity][GunStatistics.statistics_n][];
        this.hits = new int[this.victim_quantity][GunStatistics.statistics_n][];
        this.hits_updated = new boolean[this.victim_quantity][GunStatistics.statistics_n][];
        this.gf_null_angle[0] = DataHandling.absoluteAngle(this.source_stats_start.location, this.victim_stats_start[0].location);
        this.calculateMaxEscapeAngles(0);
        int seg = 0;
        while (seg < GunStatistics.statistics_n) {
            this.hits[0][seg] = Data.getEnemy((String)this.source_stats_start.name).statistics_gun.get(seg).getHits(this);
            this.bins[0][seg] = Data.getEnemy((String)this.source_stats_start.name).statistics_gun.get(seg).getBins(this);
            ++seg;
        }
    }

    public static double linearSmooth(int bin, double mean, double range) {
        double curve_flat = 1.5 * (range - Math.max(Math.abs(mean - (double)bin), 0.0)) / (range * range);
        double curve_peak = 0.0;
        if (Math.abs(mean - (double)bin) < 3.0) {
            curve_peak = 0.3 * (2.0 - Math.abs(mean - (double)bin)) / 4.0;
        }
        return curve_flat + curve_peak;
    }

    public static double gau\u00dfCurve(int bin, double mean, double sigma) {
        return 1.0 / (sigma * Math.sqrt(Math.PI * 2)) * Math.pow(Math.E, -Math.pow((mean - (double)bin) / sigma, 2.0) / 2.0);
    }

    public static double gau\u00dfCurve1Sigma(int bin, double mean) {
        return 1.0 / Math.sqrt(Math.PI * 2) * Math.pow(Math.E, -Math.pow(mean - (double)bin, 2.0) / 2.0);
    }

    public void updateBulletCollisionArea(long time_current) {
        int c = 0;
        while (c < this.bullet_collisions_new.size()) {
            BulletCollisionRegion collision = (BulletCollisionRegion)this.bullet_collisions_new.values().toArray()[c];
            boolean ret = collision.calculateHitArea();
            if (ret) {
                this.bullet_collisions_new.remove(collision.bullet.bullet);
                if (collision.time_intersection > time_current) {
                    this.bullet_collisions.put(collision.bullet.bullet, collision);
                }
            }
            ++c;
        }
        c = 0;
        while (c < this.bullet_collisions.size()) {
            if (this.getCollArea((int)c).time_intersection < time_current) {
                this.bullet_collisions.remove(this.getCollArea((int)c).bullet.bullet);
                --c;
            }
            ++c;
        }
    }

    public void newHit(HitByBulletEvent event) {
        Bullet bullet = event.getBullet();
        double angle = Utils.normalAbsoluteAngle((double)bullet.getHeadingRadians());
        this.gf_hit_angles[0][0] = Utils.normalRelativeAngle((double)(angle - this.gf_null_angle[0]));
        if (this.waves_linked != null) {
            int i = 0;
            while (i < this.waves_linked.size()) {
                this.waves_linked.get((int)i).hit[0] = true;
                ++i;
            }
        } else {
            this.hit[0] = true;
        }
        boolean registered = true;
        int c = 0;
        while (c < this.bullet_collisions.size()) {
            BulletCollisionRegion collisionregion = this.getCollArea(c);
            if (angle >= collisionregion.angle_hit_min && angle <= collisionregion.angle_hit_max) {
                registered = false;
            }
            ++c;
        }
        if (!registered && Garm.debug_bulletcollisionarea) {
            System.out.println("Bullet hit event was in bullet hit bullet region!!!!!!!!!!");
        }
    }

    public void newBulletHitBullet(BulletHitBulletEvent event) {
        if (this.waves_linked != null) {
            int i = 0;
            while (i < this.waves_linked.size()) {
                this.waves_linked.get((int)i).hitbullet = true;
                ++i;
            }
        } else {
            this.hitbullet = true;
        }
        Bullet bullet = event.getHitBullet();
        double angle = bullet.getHeadingRadians();
        this.gf_hit_angles[0][0] = Utils.normalRelativeAngle((double)(angle - this.gf_null_angle[0]));
        boolean registered = false;
        int c = 0;
        while (c < this.bullet_collisions.size()) {
            BulletCollisionRegion collisionregion = this.getCollArea(c);
            if (angle >= collisionregion.angle_hit_min - 0.001 && angle <= collisionregion.angle_hit_max + 0.001) {
                registered = true;
            }
            ++c;
        }
        if (!registered) {
            if (Garm.debug_bulletcollisionarea) {
                System.out.println("Bullet hit Bullet event was not registered!!!!!!!!!!");
            } else if (Garm.debug_bulletcollisionarea) {
                System.out.println("registered");
            }
        }
    }

    public void calculatePower() {
        if (this.source_stats_start == null || this.source_stats_end == null) {
            this.power = -1.0;
            return;
        }
        Collections.sort(this.energy_changes);
        double energy_prdiction = this.source_stats_start.energy;
        int i = 0;
        while (i < this.energy_changes.size()) {
            Energy energy_current = this.energy_changes.get(i);
            if (energy_current.getClass() == EnergyChange.class) {
                EnergyChange energy_change = (EnergyChange)energy_current;
                energy_prdiction += energy_change.energy_change;
            } else {
                NewEnergy energy = (NewEnergy)energy_current;
                energy_prdiction -= energy.damage;
            }
            ++i;
        }
        this.power = energy_prdiction - this.source_stats_end.energy;
        this.vb = this.velocity = 20.0 - this.power * 3.0;
        this.vb2 = this.velocity * this.velocity;
    }

    public void newEnergyChange(double energy_change, long time) {
        if (time > this.source_stats_start.time && (this.source_stats_end == null || time <= this.source_stats_end.time)) {
            this.energy_changes.add(new EnergyChange(energy_change, time));
        }
    }

    public void newEnergy(double energy, double damage, long time) {
        if (time > this.source_stats_start.time && (this.source_stats_end == null || time <= this.source_stats_end.time)) {
            this.energy_changes.add(new NewEnergy(energy, damage, time));
        }
    }

    public void removeCollisionArea(Bullet b) {
        this.bullet_collisions.remove(b);
    }

    public void createNewCollisionArea(MyBullet b) {
        if (!b.hitbullet && Garm.getEnemy((String)this.source_stats_start.name).gf_checkbulletcollision) {
            BulletCollisionRegion collision = new BulletCollisionRegion(b);
            this.bullet_collisions_new.put(b.bullet, collision);
        }
    }

    public BulletCollisionRegion getCollArea(int c) {
        return (BulletCollisionRegion)this.bullet_collisions.values().toArray()[c];
    }

    public boolean testGF_CollisionAreaInclusion(double gf_min, double gf_max) {
        int c = 0;
        while (c < this.bullet_collisions.size()) {
            BulletCollisionRegion collisionregion = this.getCollArea(c);
            if (gf_min >= collisionregion.gf_hit_min && gf_max <= collisionregion.gf_hit_max) {
                return true;
            }
            ++c;
        }
        return false;
    }

    public double[] getHitGFs() {
        double[] gf = new double[5];
        int dir = MyWave.getDir(this.gf_hit_angles[0][0]);
        int gf_type = 0;
        while (gf_type < 5) {
            gf[gf_type] = this.gf_hit_angles[0][0] / this.gf_max_angles[0][gf_type][dir];
            int n = gf_type++;
            gf[n] = gf[n] * (double)this.direction_start[0];
        }
        return gf;
    }

    public double[][] calculatePosition2GFs(Point2D.Double location, long time, boolean debug) {
        long time_delta = time - this.source_stats_start.time;
        double wave_radius = this.velocity * (double)time_delta;
        double distance = this.source_stats_start.location.distance(location);
        if (wave_radius < distance - 25.5 || wave_radius - this.velocity > distance + 25.5) {
            return null;
        }
        double[] gf_hit_angles_new = new double[2];
        boolean hit = DataHandling.setHitEdgeBearing(wave_radius, location, this.source_stats_start, this.gf_null_angle[0], this.velocity, gf_hit_angles_new, false);
        hit = DataHandling.setHitCurveBearing(wave_radius, location, this.source_stats_start, this.gf_null_angle[0], gf_hit_angles_new, hit);
        if (!(hit = DataHandling.setHitCurveBearing(wave_radius - this.velocity, location, this.source_stats_start, this.gf_null_angle[0], gf_hit_angles_new, hit))) {
            return null;
        }
        if (debug) {
            DrawingBot.drawLine(new Point2D.Double(this.source_stats_start.location.getX() + Math.sin(gf_hit_angles_new[0] + this.gf_null_angle[0]) * (wave_radius - 10.0), this.source_stats_start.location.getY() + Math.cos(gf_hit_angles_new[0] + this.gf_null_angle[0]) * (wave_radius - 10.0)), new Point2D.Double(this.source_stats_start.location.getX() + Math.sin(gf_hit_angles_new[0] + this.gf_null_angle[0]) * wave_radius, this.source_stats_start.location.getY() + Math.cos(gf_hit_angles_new[0] + this.gf_null_angle[0]) * wave_radius), Color.CYAN);
            DrawingBot.drawLine(new Point2D.Double(this.source_stats_start.location.getX() + Math.sin(gf_hit_angles_new[1] + this.gf_null_angle[0]) * (wave_radius - 10.0), this.source_stats_start.location.getY() + Math.cos(gf_hit_angles_new[1] + this.gf_null_angle[0]) * (wave_radius - 10.0)), new Point2D.Double(this.source_stats_start.location.getX() + Math.sin(gf_hit_angles_new[1] + this.gf_null_angle[0]) * wave_radius, this.source_stats_start.location.getY() + Math.cos(gf_hit_angles_new[1] + this.gf_null_angle[0]) * wave_radius), Color.CYAN);
        }
        double[][] gf = new double[5][2];
        int gf_type = 0;
        while (gf_type < 5) {
            int dir = MyWave.getDir(gf_hit_angles_new[0]);
            gf[gf_type][0] = gf_hit_angles_new[0] / this.gf_max_angles[0][gf_type][dir];
            double[] dArray = gf[gf_type];
            dArray[0] = dArray[0] * (double)this.direction_start[0];
            dir = MyWave.getDir(gf_hit_angles_new[1]);
            gf[gf_type][1] = gf_hit_angles_new[1] / this.gf_max_angles[0][gf_type][dir];
            double[] dArray2 = gf[gf_type];
            dArray2[1] = dArray2[1] * (double)this.direction_start[0];
            ++gf_type;
        }
        return gf;
    }

    public MyWave cloneMe() {
        MyWave wave_clone = null;
        try {
            wave_clone = (MyWave)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("ERROR: " + e);
        }
        wave_clone.victim_stats_start[0] = this.victim_stats_start[0].cloneMe();
        wave_clone.victim_stats_end[0] = this.victim_stats_end[0].cloneMe();
        wave_clone.source_stats_start = this.source_stats_start.cloneMe();
        wave_clone.source_stats_end = this.source_stats_end.cloneMe();
        return wave_clone;
    }

    public void onPaint(Graphics2D g, long time) {
        double[] distance = new double[]{(double)(time - this.source_stats_start.time) * this.velocity, (double)(time - (this.source_stats_end.time - 1L)) * this.velocity - 1.0};
        g.setColor(Color.magenta);
        g.drawLine((int)(this.source_stats_start.getX() + Math.sin(this.gf_null_angle[0]) * (distance[0] - 40.0)), (int)(this.source_stats_start.getY() + Math.cos(this.gf_null_angle[0]) * (distance[0] - 40.0)), (int)(this.source_stats_start.getX() + Math.sin(this.gf_null_angle[0]) * (distance[0] + 10.0)), (int)(this.source_stats_start.getY() + Math.cos(this.gf_null_angle[0]) * (distance[0] + 10.0)));
        double wallangle1 = this.gf_null_angle[0] + this.gf_max_angles[0][3][1];
        double wallangle2 = this.gf_null_angle[0] - this.gf_max_angles[0][3][0];
        g.setColor(Color.WHITE);
        g.drawLine((int)(this.source_stats_start.getX() + Math.sin(wallangle1) * (distance[0] - 40.0)), (int)(this.source_stats_start.getY() + Math.cos(wallangle1) * (distance[0] - 40.0)), (int)(this.source_stats_start.getX() + Math.sin(wallangle1) * (distance[0] + 10.0)), (int)(this.source_stats_start.getY() + Math.cos(wallangle1) * (distance[0] + 10.0)));
        g.setColor(Color.ORANGE);
        g.drawLine((int)(this.source_stats_start.getX() + Math.sin(wallangle2) * (distance[0] - 40.0)), (int)(this.source_stats_start.getY() + Math.cos(wallangle2) * (distance[0] - 40.0)), (int)(this.source_stats_start.getX() + Math.sin(wallangle2) * (distance[0] + 10.0)), (int)(this.source_stats_start.getY() + Math.cos(wallangle2) * (distance[0] + 10.0)));
        g.setColor(Color.orange);
        if (this.hitbullet) {
            g.setColor(Color.red);
        } else {
            g.setColor(this.color);
        }
        g.drawOval((int)(this.source_stats_start.getX() - distance[0]), (int)(this.source_stats_start.getY() - distance[0]), (int)(2.0 * distance[0]), (int)(2.0 * distance[0]));
        g.drawOval((int)(this.source_stats_start.getX() - distance[0] + this.velocity), (int)(this.source_stats_start.getY() - distance[0] + this.velocity), (int)(2.0 * (distance[0] - this.velocity)), (int)(2.0 * (distance[0] - this.velocity)));
        g.setColor(Color.red);
        g.drawOval((int)(this.source_stats_start.getX() - distance[1]), (int)(this.source_stats_start.getY() - distance[1]), (int)(2.0 * distance[1]), (int)(2.0 * distance[1]));
    }

    public void drawHitArea(long time) {
    }

    class EnergyChange
    extends Energy {
        public double energy_change;

        EnergyChange(double energy_change, long time) {
            this.energy_change = energy_change;
            this.time = time;
        }
    }

    class NewEnergy
    extends Energy {
        public double energy;
        public double damage;

        NewEnergy(double energy, double damage, long time) {
            this.energy = energy;
            this.time = time;
            this.damage = damage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Energy
    implements Comparable<Energy> {
        public long time;

        Energy() {
        }

        @Override
        public int compareTo(Energy object) {
            if (this.time != object.time) {
                return (int)(this.time - object.time);
            }
            if (object.getClass() == this.getClass()) {
                return 0;
            }
            if (object.getClass() == NewEnergy.class) {
                return 1;
            }
            return -1;
        }
    }

    class BulletCollisionRegion {
        MyBullet bullet;
        double angle_hit_min;
        double angle_hit_max;
        double gf_hit_min;
        double gf_hit_max;
        long time_intersection;

        BulletCollisionRegion(MyBullet bullet) {
            this.bullet = bullet;
        }

        public boolean calculateHitArea() {
            Point2D.Double p_front_inter;
            double d_new;
            double t_new;
            Point2D.Double p_back_inter;
            double t;
            if (this.bullet.bullet == null) {
                return false;
            }
            if (MyWave.this.source_stats_start.location.distance(Data.stats_my.location) - 25.0 < MyWave.this.velocity * (double)(Data.stats_my.time - MyWave.this.source_stats_start.time)) {
                this.time_intersection = 0L;
                return true;
            }
            double vm = this.bullet.velocity;
            double vm2 = vm * vm;
            double ve = MyWave.this.velocity;
            double ve2 = ve * ve;
            double e0x = MyWave.this.source_stats_start.location.x;
            double e0y = MyWave.this.source_stats_start.location.y;
            double m0x = this.bullet.source_stats_start.location.x;
            double m0y = this.bullet.source_stats_start.location.y;
            double hm = this.bullet.bullet.getHeadingRadians();
            double t0m = this.bullet.source_stats_start.time;
            double t0e = MyWave.this.source_stats_start.time;
            if (ve == vm) {
                if (Garm.debug_bulletcollisionarea) {
                    MyWave.this.color = Color.white;
                }
                t = (2.0 * t0m * ve * (e0y - m0y) * Math.cos(hm) + 2.0 * t0m * ve * (e0x - m0x) * Math.sin(hm) + e0x * e0x - 2.0 * e0x * m0x + e0y * e0y - 2.0 * e0y * m0y + m0x * m0x + m0y * m0y - ve2 * (t0e * t0e - t0m * t0m)) / (2.0 * ve * ((e0y - m0y) * Math.cos(hm) + (e0x - m0x) * Math.sin(hm) - ve * (t0e - t0m)));
            } else {
                t = vm2 * Math.pow(e0y - m0y, 2.0) * Math.pow(Math.cos(hm), 2.0) + 2.0 * vm * (e0y - m0y) * Math.cos(hm) * (vm * (e0x - m0x) * Math.sin(hm) - ve2 * (t0e - t0m)) + vm2 * Math.pow(e0x - m0x, 2.0) * Math.pow(Math.sin(hm), 2.0) + 2.0 * ve2 * vm * (e0x - m0x) * (t0m - t0e) * Math.sin(hm) + e0x * e0x * (ve2 - vm2) + 2.0 * e0x * m0x * (vm2 - ve2) + e0y * e0y * (ve2 - vm2) + 2.0 * e0y * m0y * (vm2 - ve2) + m0x * m0x * (ve2 - vm2) + m0y * m0y * (ve2 - vm2) + ve2 * vm2 * (t0e * t0e - 2.0 * t0e * t0m + t0m * t0m);
                if (t <= 0.0) {
                    this.time_intersection = 0L;
                    return true;
                }
                t = Math.sqrt(t);
                t = (t + vm * (m0y - e0y) * Math.cos(hm) + vm * (m0x - e0x) * Math.sin(hm) + t0e * ve2 - t0m * vm2) / (ve2 - vm2);
            }
            this.time_intersection = (long)t + 1L;
            double d_max = ((double)this.time_intersection - t0e) * ve;
            Point2D.Double p_front = DataHandling.project(this.bullet.source_stats_start.location, hm, vm * ((double)this.time_intersection - t0m));
            Point2D.Double p_back = DataHandling.project(this.bullet.source_stats_start.location, hm, vm * ((double)this.time_intersection - t0m) - vm);
            if (p_back.distance(MyWave.this.source_stats_start.location) <= d_max) {
                p_back_inter = p_back;
            } else {
                t_new = 1.0 - Math.sqrt(Math.pow(e0y - m0y, 2.0) * Math.pow(Math.cos(hm), 2.0) + 2.0 * (e0x - m0x) * (e0y - m0y) * Math.sin(hm) * Math.cos(hm) + Math.pow(e0x - m0x, 2.0) * Math.pow(Math.sin(hm), 2.0) + d_max * d_max - e0x * e0x + 2.0 * e0x * m0x - e0y * e0y + 2.0 * e0y * m0y - m0x * m0x - m0y * m0y) / vm + (e0y - m0y) * Math.cos(hm) / vm + (e0x - m0x) * Math.sin(hm) / vm;
                if (t_new <= 0.0) {
                    if (Garm.debug_bulletcollisionarea) {
                        System.out.println("t_new2 = " + t_new);
                        MyWave.this.color = Color.green;
                    }
                    this.time_intersection = 0L;
                    return true;
                }
                d_new = t_new * vm;
                p_back_inter = DataHandling.project(this.bullet.source_stats_start.location, hm, d_new - vm);
            }
            if (p_front.distance(MyWave.this.source_stats_start.location) >= d_max - ve) {
                p_front_inter = p_front;
            } else {
                d_max -= ve;
                t_new = -Math.sqrt(Math.pow(e0y - m0y, 2.0) * Math.pow(Math.cos(hm), 2.0) + 2.0 * (e0x - m0x) * (e0y - m0y) * Math.sin(hm) * Math.cos(hm) + Math.pow(e0x - m0x, 2.0) * Math.pow(Math.sin(hm), 2.0) + d_max * d_max - e0x * e0x + 2.0 * e0x * m0x - e0y * e0y + 2.0 * e0y * m0y - m0x * m0x - m0y * m0y) / vm + (e0y - m0y) * Math.cos(hm) / vm + (e0x - m0x) * Math.sin(hm) / vm;
                if (t_new <= 0.0) {
                    if (Garm.debug_bulletcollisionarea) {
                        System.out.println("t_new1 = " + t_new);
                        MyWave.this.color = Color.green;
                    }
                    this.time_intersection = 0L;
                    return true;
                }
                d_new = t_new * vm;
                p_front_inter = DataHandling.project(this.bullet.source_stats_start.location, hm, d_new);
            }
            double angle0 = Utils.normalAbsoluteAngle((double)DataHandling.absoluteAngle(MyWave.this.source_stats_start.location, p_front_inter));
            double angle1 = Utils.normalAbsoluteAngle((double)DataHandling.absoluteAngle(MyWave.this.source_stats_start.location, p_back_inter));
            this.angle_hit_min = Math.min(angle0, angle1);
            this.angle_hit_max = Math.max(angle0, angle1);
            double gf_hit_min_new = this.angle_hit_min;
            double gf_hit_max_new = this.angle_hit_max;
            gf_hit_min_new *= (double)MyWave.this.direction_start[0];
            gf_hit_max_new *= (double)MyWave.this.direction_start[0];
            this.gf_hit_min = Math.min(gf_hit_min_new /= this.gf_hit_min >= 0.0 ? MyWave.this.gf_max_angles[0][1][1] : -MyWave.this.gf_max_angles[0][1][0], gf_hit_max_new /= this.gf_hit_max >= 0.0 ? MyWave.this.gf_max_angles[0][1][1] : -MyWave.this.gf_max_angles[0][1][0]);
            this.gf_hit_max = Math.max(gf_hit_min_new, gf_hit_max_new);
            return true;
        }
    }
}

