/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.Movement;
import Krabb.sliNk.Smoother;
import java.awt.geom.Rectangle2D;

class VoidiousWallSmoother
extends Smoother {
    double stick_length = 140.0;
    double fieldHeight;
    double fieldWidth;
    private Rectangle2D.Double _fieldRect;

    public VoidiousWallSmoother(Movement robot) {
        this.fieldHeight = robot.getBattleFieldHeight();
        this.fieldWidth = robot.getBattleFieldWidth();
        this._fieldRect = new Rectangle2D.Double(18.0, 18.0, this.fieldWidth - 36.0, this.fieldHeight - 36.0);
    }

    double smooth(double startAngle, boolean clockwise, double velocity, double x, double y, double ex, double ey) {
        double angle = startAngle + (velocity < 0.0 ? Math.PI : 0.0);
        int orientation = 1 * (clockwise ? 1 : -1);
        double testX = x + Math.sin(angle += Math.PI * 4) * this.stick_length;
        double testY = y + Math.cos(angle) * this.stick_length;
        double wallDistanceX = Math.min(x - 18.0, this.fieldWidth - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, this.fieldHeight - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, this.fieldWidth - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, this.fieldHeight - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        double minimum_enemydistance = 170.0;
        boolean smooth_horizontal = true;
        boolean smooth_vertical = true;
        while (!this._fieldRect.contains(testX, testY) && g++ < 25) {
            if (y > this.fieldHeight / 2.0 && ey > this.fieldHeight - minimum_enemydistance && (Math.abs(x - ex) > 100.0 || x < ex) || y < this.fieldHeight / 2.0 && ey < minimum_enemydistance && (Math.abs(x - ex) > 100.0 || x > ex)) {
                smooth_horizontal = false;
            }
            if (x > this.fieldWidth / 2.0 && ex > this.fieldWidth - minimum_enemydistance && (Math.abs(y - ey) > 100.0 || y < ey) || x < this.fieldWidth / 2.0 && ex < minimum_enemydistance && (Math.abs(y - ey) > 100.0 || y > ey)) {
                smooth_vertical = false;
            }
            if (!smooth_vertical && !smooth_horizontal) {
                smooth_horizontal = true;
            }
            if (smooth_horizontal && testDistanceY < 0.0 && (testDistanceY < testDistanceX || !smooth_vertical)) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else {
                if (!smooth_vertical || !(testDistanceX < 0.0) || !(testDistanceX <= testDistanceY) && smooth_horizontal) break;
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)orientation * (Math.abs(Math.acos(adjacent / this.stick_length)) + 0.005)) * this.stick_length;
            testY = y + Math.cos(angle) * this.stick_length;
            testDistanceX = Math.min(testX - 18.0, this.fieldWidth - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, this.fieldHeight - testY - 18.0);
        }
        return angle -= velocity < 0.0 ? Math.PI : 0.0;
    }
}

