/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.AgentSmith.Setup;
import rdt.Debug.DebugGraph;
import rdt.RobotData.RobotData;
import rdt.Targeting.Targeting;
import rdt.Utils.RollingAverage;

public class EnergyManagement {
    private double _bulletFirepower = 0.0;
    private ArrayList<EnergyValue> _energyHistory = new ArrayList();
    private ArrayList<DebugGraph> _graphs = null;
    private RollingAverage _ourRateOfChangeRollingAverage = new RollingAverage(50, 1.0);
    private RollingAverage _theirRateOfChangeRollingAverage = new RollingAverage(50, 1.0);

    public EnergyManagement() {
        if (Setup.Instance.EnableEnergyDebug) {
            this._graphs = new ArrayList();
            this._graphs.add(new DebugGraph(100, 0.0, 100.0, new Point2D.Double(-180.0, 550.0), new Point2D.Double(-20.0, 600.0)));
            this._graphs.add(new DebugGraph(100, 0.0, 100.0, new Point2D.Double(-180.0, 500.0), new Point2D.Double(-20.0, 550.0)));
            this._graphs.add(new DebugGraph(100, -1.0, 1.0, new Point2D.Double(-180.0, 450.0), new Point2D.Double(-20.0, 500.0)));
            this._graphs.add(new DebugGraph(100, -1.0, 1.0, new Point2D.Double(-180.0, 400.0), new Point2D.Double(-20.0, 450.0)));
            this._graphs.add(new DebugGraph(100, -1.0, 1.0, new Point2D.Double(-180.0, 350.0), new Point2D.Double(-20.0, 400.0)));
        }
    }

    public void Update() {
        this.SetBulletFirepower();
    }

    private void SetBulletFirepower() {
        if (Setup.Instance.EnableGunChallengeMode) {
            this._bulletFirepower = 3.0;
            return;
        }
        RobotData currentTarget = Targeting.GetCurrentTarget();
        if (currentTarget == null || !currentTarget.Valid) {
            this._bulletFirepower = 0.0;
            return;
        }
        double ourEnergy = AgentSmith.Instance().getEnergy();
        double targetEnergy = currentTarget.Snapshots.get((int)0).Energy;
        if (ourEnergy <= 0.1) {
            this._bulletFirepower = 0.0;
            return;
        }
        if (targetEnergy < 12.0) {
            this.SetFirepower(targetEnergy / 4.0);
            return;
        }
        this.SetFirepower(Setup.Instance.StandardFirepower);
    }

    private void SetFirepower(double firepower) {
        this._bulletFirepower = firepower;
        this._bulletFirepower = Math.min(3.0, this._bulletFirepower);
        this._bulletFirepower = Math.min(Setup.Instance.StandardFirepower, this._bulletFirepower);
        this._bulletFirepower = Math.max(0.1, this._bulletFirepower);
        this._bulletFirepower = Math.min(AgentSmith.Instance().getEnergy() - 0.2, this._bulletFirepower);
    }

    public double GetFirepower() {
        return this._bulletFirepower;
    }

    public void StartOfRound() {
        this._energyHistory.clear();
        this._ourRateOfChangeRollingAverage.Reset();
        this._theirRateOfChangeRollingAverage.Reset();
        this.SetBulletFirepower();
    }

    private void UpdateGraphing() {
        if (this._graphs != null) {
            EnergyValue latest = this._energyHistory.get(0);
            this._graphs.get(0).AddPoint(latest.Ours);
            this._graphs.get(1).AddPoint(latest.Theirs);
            this._graphs.get(2).AddPoint(latest.OurRateOfChange);
            this._graphs.get(3).AddPoint(latest.TheirRateOfChange);
            this._graphs.get(4).AddPoint(latest.DeltaRateOfChange);
        }
    }

    public void DebugDraw(Graphics2D gfx) {
        if (this._graphs == null) {
            return;
        }
        if (!Setup.Instance.EnableEnergyDebug) {
            return;
        }
        int index = 0;
        while (index < this._graphs.size()) {
            this._graphs.get(index).Draw(gfx);
            ++index;
        }
    }

    private class EnergyValue {
        public double Ours;
        public double Theirs;
        public double OurRateOfChange;
        public double TheirRateOfChange;
        public double DeltaRateOfChange;

        private EnergyValue() {
        }
    }
}

