/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun.virtual;

import florent.XSeries.Configuration;
import florent.XSeries.gun.PatternMatchingGun;
import florent.XSeries.gun.patternrecognition.Scan;
import florent.XSeries.gun.patternrecognition.ScanStats;
import florent.XSeries.radar.Enemy;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.RobocodeTools;
import florent.XSeries.utils.VisitRecorder;
import florent.XSeries.utils.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.util.Utils;

public class GunWave
extends Wave {
    public static PatternMatchingGun pmGun;
    private static long time;
    private static final int ANGLES = 2;
    public double[] angles = new double[2];
    private boolean[] hit = new boolean[2];
    private Enemy enemy;
    private ScanStats stats;
    private Scan scan;
    private boolean recorded;

    public GunWave(Enemy enemy, double angle1, double angle2, double diff1, double diff2, ScanStats stats, Scan scan) {
        this.hit[1] = true;
        this.hit[0] = true;
        this.angles[0] = angle1;
        this.angles[1] = angle2;
        if (diff1 < 1000.0) {
            enemy.data.VGdiffs[0] = 0.9 * enemy.data.VGdiffs[0] + 0.1 * diff1;
            this.hit[0] = false;
        }
        if (diff2 < 1000.0) {
            enemy.data.VGdiffs[1] = 0.9 * enemy.data.VGdiffs[1] + 0.1 * diff2;
            this.hit[1] = false;
        }
        this.enemy = enemy;
        this.stats = stats;
        this.scan = scan;
        this.recorded = false;
    }

    public void init(Point2D.Double gun, Point2D.Double target, int bearingDirection, double power, double fireTime) {
        super.init(gun, target, bearingDirection, power, fireTime);
        Configuration.me.addCustomEvent(this);
    }

    protected Point2D.Double getTargetLocation() {
        return this.enemy.location;
    }

    protected VisitRecorder getRecorder() {
        return null;
    }

    public boolean test() {
        this.synch();
        if (this.passed(this.velocity * 1.5, time, this.enemy.location) && !this.recorded) {
            this.stats.recordRollingHit(this.visitingGf(), this.scan);
            this.recorded = true;
        }
        Rectangle2D.Double enemyBox = new Rectangle2D.Double(this.enemy.location.x - 18.0, this.enemy.location.y - 18.0, 36.0, 36.0);
        int i = 0;
        while (i < 2) {
            double distanceBullet = this.velocity * ((double)time - this.fireTime);
            double angle = RobocodeTools.absoluteBearing(this.gunLocation, this.startLocation) + this.angles[i];
            Force force = new Force(new Point2D.Double(this.gunLocation.x, this.gunLocation.y), new Point2D.Double(this.gunLocation.x + distanceBullet * Math.sin(angle), this.gunLocation.y + distanceBullet * Math.cos(angle)));
            Line2D.Double line = new Line2D.Double(force.end, new Point2D.Double(force.end.x + this.velocity * Math.sin(angle), force.end.y + this.velocity * Math.cos(angle)));
            if (enemyBox.intersectsLine(line) && !this.hit[i]) {
                int n = i;
                this.enemy.data.VGhits[n] = this.enemy.data.VGhits[n] + 1.0;
                this.enemy.data.VGrating[i] = RobocodeTools.rollingAverage(Math.min(500, this.enemy.data.myBulletsFired), this.enemy.data.VGrating[i], 100.0);
                this.hit[i] = true;
            }
            ++i;
        }
        if (this.passed(-40.0, time, this.enemy.location)) {
            Configuration.me.removeCustomEvent(this);
            GunWave.pmGun.waves.remove((Object)this);
            i = 0;
            while (i < 2) {
                if (!this.hit[i]) {
                    this.enemy.data.VGrating[i] = RobocodeTools.rollingAverage(Math.min(500, this.enemy.data.myBulletsFired), this.enemy.data.VGrating[i], 0.0);
                }
                ++i;
            }
        }
        return false;
    }

    private void synch() {
        time = Configuration.me.getTime();
    }

    private boolean hit(double goodAngle, double angle) {
        return Math.abs(Utils.normalRelativeAngle((double)(goodAngle - angle))) < Math.asin(20.0 / this.gunLocation.distance(this.enemy.location));
    }

    public void onPaint(Graphics2D g) {
        this.synch();
        int radius = (int)(this.velocity * ((double)time - this.fireTime));
        g.setColor(Color.green);
        g.drawOval((int)(this.gunLocation.x - (double)radius), (int)(Configuration.battleFieldHeigth - this.gunLocation.y - (double)radius), 2 * radius, 2 * radius);
        Force force = new Force(new Point2D.Double(this.gunLocation.x, this.gunLocation.y), new Point2D.Double(this.enemy.location.x, this.enemy.location.y));
        double tolerance = Math.asin(20.0 / this.gunLocation.distance(this.enemy.location));
        force.rotate(tolerance);
        g.drawLine((int)force.origin.x, (int)(Configuration.battleFieldHeigth - force.origin.y), (int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y));
        force.rotate(-2.0 * tolerance);
        g.drawLine((int)force.origin.x, (int)(Configuration.battleFieldHeigth - force.origin.y), (int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y));
        double distanceBullet = radius;
        double angle = RobocodeTools.absoluteBearing(this.gunLocation, this.startLocation) + this.angles[0];
        force = new Force(new Point2D.Double(this.gunLocation.x, this.gunLocation.y), new Point2D.Double(this.gunLocation.x + distanceBullet * Math.sin(angle), this.gunLocation.y + distanceBullet * Math.cos(angle)));
        g.setColor(Color.blue);
        g.drawLine((int)force.origin.x, (int)(Configuration.battleFieldHeigth - force.origin.y), (int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y));
        g.setColor(Color.orange);
        g.drawLine((int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y), (int)(force.end.x + this.velocity * Math.sin(angle)), (int)(Configuration.battleFieldHeigth - (force.end.y + this.velocity * Math.cos(angle))));
        angle = RobocodeTools.absoluteBearing(this.gunLocation, this.startLocation) + this.angles[1];
        force = new Force(new Point2D.Double(this.gunLocation.x, this.gunLocation.y), new Point2D.Double(this.gunLocation.x + distanceBullet * Math.sin(angle), this.gunLocation.y + distanceBullet * Math.cos(angle)));
        g.setColor(Color.white);
        g.drawLine((int)force.origin.x, (int)(Configuration.battleFieldHeigth - force.origin.y), (int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y));
        g.setColor(Color.orange);
        g.drawLine((int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y), (int)(force.end.x + this.velocity * Math.sin(angle)), (int)(Configuration.battleFieldHeigth - (force.end.y + this.velocity * Math.cos(angle))));
        Rectangle2D.Double enemyBox = new Rectangle2D.Double(this.enemy.location.x - 18.0, Configuration.battleFieldHeigth - this.enemy.location.y - 18.0, 36.0, 36.0);
        g.setColor(Color.magenta);
        g.draw(enemyBox);
    }
}

