/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement.antigravity;

import florent.XSeries.movement.antigravity.GravPoint;
import florent.XSeries.movement.wavesurfing.EnemyWave;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.RobocodeTools;
import java.awt.geom.Point2D;

public class BulletPoint
extends GravPoint {
    public boolean closestIsMe = false;
    private EnemyWave wave;

    public BulletPoint(EnemyWave wave) {
        this.wave = wave;
        this.closestIsMe = wave.enemy.closestIsMe;
    }

    public String getKey() {
        return "Bullet:" + super.getKey();
    }

    protected double getMagnitude(Point2D.Double location) {
        this.strength = this.wave.danger(location) * 15.0;
        this.strength = this.strength == Double.POSITIVE_INFINITY ? 1.0 : this.strength;
        this.strength *= (double)(this.closestIsMe ? 1 : 0);
        return super.getMagnitude(location);
    }

    public Force getForce(Point2D.Double location) {
        double angle = RobocodeTools.absoluteBearing(location, this.wave.gunLocation) + 1.5707963267948966 * (double)RobocodeTools.sign(RobocodeTools.angleBetween(this.wave.gunLocation, location, this.point));
        double magnitude = this.getMagnitude(location);
        Point2D.Double end = new Point2D.Double(location.x + magnitude * Math.sin(angle), location.y + magnitude * Math.cos(angle));
        return new Force(location, end);
    }
}

