/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement.wavesurfing;

import florent.XSeries.Configuration;
import florent.XSeries.utils.RobocodeTools;

public class GFLog {
    public static final int GF0 = 15;
    public static final int GF1 = 30;
    public static double[] WEIGHTS = new double[]{5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0, 9.0, 8.0, 10.0, 9.0, 0.0, 0.0, 0.0};
    public static final double SUMWEIGHT = GFLog.sumWeight();
    public static final double[] BULLET_FLIGHT_TIME_SLICES = new double[]{10.0, 20.0, 30.0, 40.0, 50.0, 60.0};
    public static final double[] DISTANCE_SLICES = new double[]{150.0, 300.0, 450.0, 600.0};
    public static final double[] VELOCITY_SLICES = new double[]{1.0, 3.0, 5.0, 7.0};
    public static final double[] WALL_SLICES = new double[]{0.15, 0.35, 0.55, 0.75};
    public static final double[] TIME_SLICES = new double[]{0.1, 0.3, 0.7, 1.2};
    public static final double[] ACCEL_SLICES = new double[]{-0.5, 0.5};
    public static final double[] POWER_SLICES = new double[]{0.65, 1.3, 1.95, 2.6};
    public static final int BUFFERS = 15;
    private String key;
    public int hit;
    public int goodHit;
    public int headOnHit;
    private double[] rawVisits = new double[31];
    private double[][][] visitsVelocity = new double[POWER_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private double[][][] visitsTimer = new double[POWER_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private double[][][] visitsWall = new double[POWER_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[][][][] visitsDistanceVelocity = new double[POWER_SLICES.length + 1][DISTANCE_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private double[][][][] visitsWallTimer = new double[POWER_SLICES.length + 1][WALL_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private double[][][][][] visitsDistanceVelocityWall = new double[POWER_SLICES.length + 1][DISTANCE_SLICES.length + 1][VELOCITY_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[][][] visitsVelocity2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private double[][][] visitsTimer2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private double[][][] visitsWall2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[][][][] visitsWallTimer2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][WALL_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private double[][][][] visitsVelocityWall = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][VELOCITY_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[][][] visitsAccel = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][31];
    private double[][][][] visitsAccelVelocity = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private double[][][][] visitsAccelWall = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][WALL_SLICES.length + 1][31];
    public double[] rawHits = new double[31];
    private double[][][] hitsVelocity = new double[POWER_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private double[][][] hitsTimer = new double[POWER_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private double[][][] hitsWall = new double[POWER_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[][][][] hitsDistanceVelocity = new double[POWER_SLICES.length + 1][DISTANCE_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private double[][][][] hitsWallTimer = new double[POWER_SLICES.length + 1][WALL_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private double[][][][][] hitsDistanceVelocityWall = new double[POWER_SLICES.length + 1][DISTANCE_SLICES.length + 1][VELOCITY_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[][][] hitsVelocity2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private double[][][] hitsTimer2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private double[][][] hitsWall2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[][][][] hitsWallTimer2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][WALL_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private double[][][][] hitsVelocityWall = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][VELOCITY_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[][][] hitsAccel = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][31];
    private double[][][][] hitsAccelVelocity = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private double[][][][] hitsAccelWall = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private double[] dynamicFactors;
    private double[] ranks;
    private int updates;

    public GFLog(String key) {
        this.key = key;
        this.rawHits[15] = 0.05;
        this.dynamicFactors = new double[15];
        this.ranks = new double[15];
    }

    public double[][] hitBuffers(int powerIndex, int velocityIndex, int timeIndex, int distanceIndex, int wallIndex, int bftIndex, int accelIndex) {
        double[][] buffers = new double[][]{this.rawHits, this.hitsVelocity[powerIndex][velocityIndex], this.hitsTimer[powerIndex][timeIndex], this.hitsWall[powerIndex][wallIndex], this.hitsDistanceVelocity[powerIndex][distanceIndex][velocityIndex], this.hitsWallTimer[powerIndex][wallIndex][timeIndex], this.hitsDistanceVelocityWall[powerIndex][distanceIndex][velocityIndex][wallIndex], this.hitsVelocity2[bftIndex][velocityIndex], this.hitsTimer2[bftIndex][timeIndex], this.hitsWall2[bftIndex][wallIndex], this.hitsWallTimer2[bftIndex][wallIndex][timeIndex], this.hitsVelocityWall[bftIndex][velocityIndex][wallIndex], this.hitsAccel[bftIndex][accelIndex], this.hitsAccelVelocity[bftIndex][accelIndex][velocityIndex], this.hitsAccelWall[bftIndex][accelIndex][wallIndex]};
        return buffers;
    }

    public double[][] visitBuffers(int powerIndex, int velocityIndex, int timeIndex, int distanceIndex, int wallIndex, int bftIndex, int accelIndex) {
        double[][] buffers = new double[][]{this.rawVisits, this.visitsVelocity[powerIndex][velocityIndex], this.visitsTimer[powerIndex][timeIndex], this.visitsWall[powerIndex][wallIndex], this.visitsDistanceVelocity[powerIndex][distanceIndex][velocityIndex], this.visitsWallTimer[powerIndex][wallIndex][timeIndex], this.visitsDistanceVelocityWall[powerIndex][distanceIndex][velocityIndex][wallIndex], this.visitsVelocity2[bftIndex][velocityIndex], this.visitsTimer2[bftIndex][timeIndex], this.visitsWall2[bftIndex][wallIndex], this.visitsWallTimer2[bftIndex][wallIndex][timeIndex], this.visitsVelocityWall[bftIndex][velocityIndex][wallIndex], this.visitsAccel[bftIndex][accelIndex], this.visitsAccelVelocity[bftIndex][accelIndex][velocityIndex], this.visitsAccelWall[bftIndex][accelIndex][wallIndex]};
        return buffers;
    }

    public String getKey() {
        return this.key;
    }

    private static final double sumWeight() {
        int val = 0;
        int i = 0;
        while (i < WEIGHTS.length) {
            val = (int)((double)val + WEIGHTS[i]);
            ++i;
        }
        return val;
    }

    public void updateFactors(int index, double distance, int powerIndex, int velocityIndex, int timeIndex, int distanceIndex, int wallIndex, int bftIndex, int accelIndex) {
        if (Configuration.melee) {
            return;
        }
        double[][] buffers = this.hitBuffers(powerIndex, velocityIndex, timeIndex, distanceIndex, wallIndex, bftIndex, accelIndex);
        int i = 0;
        while (i < 15) {
            int bestGf = this.mostVisitedIndex(distance, powerIndex, velocityIndex, timeIndex, distanceIndex, wallIndex, bftIndex, accelIndex, buffers[i]);
            this.dynamicFactors[i] = ((double)this.updates * this.dynamicFactors[i] + 10.0 / (1.0 + this.sqr(Math.abs(bestGf - index)))) / (double)(this.updates + 1);
            ++i;
        }
        i = 0;
        while (i < 15) {
            int rank = 0;
            int j = 0;
            while (j < 15) {
                if (i != j && this.dynamicFactors[j] <= this.dynamicFactors[i]) {
                    ++rank;
                }
                ++j;
            }
            this.ranks[i] = Math.min(1, Math.max(rank + 1, 0));
            GFLog.WEIGHTS[i] = this.ranks[i] * this.pow4(1.0 + this.dynamicFactors[i]);
            ++i;
        }
        ++this.updates;
    }

    private int mostVisitedIndex(double distance, int powerIndex, int velocityIndex, int timeIndex, int distanceIndex, int wallIndex, int bftIndex, int accelIndex, double[] buffer) {
        int bestGF = 15;
        int GF_ONE = 30;
        double bestVal = 0.0;
        int halfWidth = (int)Math.floor(Math.atan(18.0 / distance) * (double)GF_ONE);
        int gf = GF_ONE;
        while (gf > 0) {
            double tmp = 0.0;
            int i = Math.max(1, gf - halfWidth);
            while (i <= Math.min(gf + halfWidth, GF_ONE)) {
                if ((tmp += buffer[i]) > bestVal) {
                    bestGF = gf;
                    bestVal = tmp;
                }
                ++i;
            }
            --gf;
        }
        return bestGF;
    }

    private double sqr(double val) {
        return val * val;
    }

    private double pow3(double val) {
        return val * val * val;
    }

    private double pow4(double val) {
        return val * val * val * val;
    }

    public void dumpWeights() {
        String str = "DynamicFactors ";
        int i = 0;
        while (i < this.dynamicFactors.length) {
            str = String.valueOf(str) + this.dynamicFactors[i] + "/";
            ++i;
        }
        RobocodeTools.log(str);
        str = "Rank ";
        i = 0;
        while (i < this.dynamicFactors.length) {
            str = String.valueOf(str) + this.ranks[i] + "/";
            ++i;
        }
        RobocodeTools.log(str);
        str = "Weights ";
        i = 0;
        while (i < this.dynamicFactors.length) {
            str = String.valueOf(str) + WEIGHTS[i] + "/";
            ++i;
        }
        RobocodeTools.log(str);
    }
}

