/*
 * Decompiled with CFR 0.152.
 */
package rtk;

import java.awt.geom.Point2D;
import java.util.List;
import robocode.Rules;
import rtk.ArrayListCapped;
import rtk.Enemy;
import rtk.PredictPosData;

public class Aiming {
    public static final int[] PREDICT_POS_DATA_TIME_DISTANCES = new int[]{20, 35, 50};
    private static final int LIST_CAP = 50;
    private static final double LIST_CAP_ROOT_VALUE = 0.1;
    private static final double LIST_CAP_ROOT = Math.pow(50.0, 0.1);
    private Enemy enemy;
    private List<PredictPosData>[][] predictPosDataCheckList = new ArrayListCapped[AimType.Size()][PREDICT_POS_DATA_TIME_DISTANCES.length];
    private List<PredictPosData>[][] predictPosDataList = new ArrayListCapped[AimType.Size()][PREDICT_POS_DATA_TIME_DISTANCES.length];
    private double[][] hitRate = new double[AimType.Size()][PREDICT_POS_DATA_TIME_DISTANCES.length];
    private double[][] hitRateTime = new double[AimType.Size()][PREDICT_POS_DATA_TIME_DISTANCES.length];
    private int roundNum = 0;

    public static int getClosestDistance(double dis) {
        double smallest = Double.MAX_VALUE;
        int distance = PREDICT_POS_DATA_TIME_DISTANCES.length - 1;
        int i = 0;
        while (i < PREDICT_POS_DATA_TIME_DISTANCES.length) {
            double d = Math.abs((double)PREDICT_POS_DATA_TIME_DISTANCES[i] - dis);
            if (d < smallest) {
                smallest = d;
                distance = i;
            }
            ++i;
        }
        return distance;
    }

    public Aiming(Enemy enemy) {
        this.enemy = enemy;
        int i = 0;
        while (i < AimType.Size()) {
            int j = 0;
            while (j < PREDICT_POS_DATA_TIME_DISTANCES.length) {
                this.predictPosDataCheckList[i][j] = new ArrayListCapped<PredictPosData>(50);
                this.predictPosDataList[i][j] = new ArrayListCapped<PredictPosData>(50);
                this.hitRate[i][j] = 0.0;
                this.hitRateTime[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void tick(long robotTime, int roundNum) {
        this.roundNum = roundNum;
        int a = 0;
        while (a < AimType.Size()) {
            int b = 0;
            while (b < PREDICT_POS_DATA_TIME_DISTANCES.length) {
                int i = this.predictPosDataCheckList[a][b].size() - 1;
                while (i >= 0) {
                    PredictPosData d = this.predictPosDataCheckList[a][b].get(i);
                    d.tick(this.enemy.getData(0).getPosition(), robotTime);
                    if (!d.getChecking()) {
                        double[] dArray = this.hitRate[a];
                        int n = b;
                        dArray[n] = dArray[n] * (double)this.predictPosDataList[a][b].size();
                        double[] dArray2 = this.hitRate[a];
                        int n2 = b;
                        dArray2[n2] = dArray2[n2] + d.getHitRate();
                        double[] dArray3 = this.hitRate[a];
                        int n3 = b;
                        dArray3[n3] = dArray3[n3] / (double)(this.predictPosDataList[a][b].size() + 1);
                        this.predictPosDataList[a][b].add(d);
                        this.predictPosDataCheckList[a][b].remove(i);
                    }
                    --i;
                }
                if (this.predictPosDataList[a][b].size() > 0) {
                    int count = 0;
                    this.hitRateTime[a][b] = 0.0;
                    int i2 = 0;
                    while (i2 < this.predictPosDataList[a][b].size()) {
                        PredictPosData d = this.predictPosDataList[a][b].get(i2);
                        if (d.getRoundNum() == roundNum) {
                            ++count;
                            double timeDif = Math.max(robotTime - (d.getStartTime() + (long)PREDICT_POS_DATA_TIME_DISTANCES[d.getTimeLength()]), 0L);
                            double[] dArray = this.hitRateTime[a];
                            int n = b;
                            dArray[n] = dArray[n] + d.getHitRate() * (Math.max(LIST_CAP_ROOT - Math.pow(timeDif, 0.1), 0.0) / LIST_CAP_ROOT);
                        }
                        ++i2;
                    }
                    if (count > 0) {
                        double[] dArray = this.hitRateTime[a];
                        int n = b;
                        dArray[n] = dArray[n] / (double)count;
                    }
                }
                ++b;
            }
            ++a;
        }
        int i = 0;
        while (i < PREDICT_POS_DATA_TIME_DISTANCES.length) {
            this.createPredictPosData(i, robotTime, roundNum);
            ++i;
        }
    }

    private void createPredictPosData(int distance, long robotTime, int roundNum) {
        AimType aim = AimType.LastSeenPlace;
        Point2D p = this.enemy.getData(0).getPosition();
        PredictPosData d = new PredictPosData(aim, distance, p, robotTime, roundNum);
        this.predictPosDataCheckList[aim.ordinal()][distance].add(d);
        aim = AimType.LookAhead;
        p = this.enemy.getData(-PREDICT_POS_DATA_TIME_DISTANCES[distance]).getPosition();
        d = new PredictPosData(aim, distance, p, robotTime, roundNum);
        this.predictPosDataCheckList[aim.ordinal()][distance].add(d);
        aim = AimType.PatternPredict;
        p = this.enemy.getDataFromPattern(PREDICT_POS_DATA_TIME_DISTANCES[distance]).getPosition();
        d = new PredictPosData(aim, distance, p, robotTime, roundNum);
        this.predictPosDataCheckList[aim.ordinal()][distance].add(d);
        aim = AimType.Random;
        p = this.enemy.getRandomPos((double)PREDICT_POS_DATA_TIME_DISTANCES[distance] / Rules.getBulletSpeed((double)2.0), false).getPosition();
        d = new PredictPosData(aim, distance, p, robotTime, roundNum);
        this.predictPosDataCheckList[aim.ordinal()][distance].add(d);
    }

    public double getHitRate(AimType aimType, int dis) {
        return this.hitRate[aimType.ordinal()][dis];
    }

    public int getHitRateSize(AimType aimType, int dis) {
        return this.predictPosDataList[aimType.ordinal()][dis].size();
    }

    public double getHitRateTime(AimType aimType, int dis) {
        return this.hitRateTime[aimType.ordinal()][dis];
    }

    public int getHitRateTimeSize(AimType aimType, int dis) {
        int count = 0;
        int i = 0;
        while (i < this.predictPosDataList[aimType.ordinal()][dis].size()) {
            PredictPosData d = this.predictPosDataList[aimType.ordinal()][dis].get(i);
            if (d.getRoundNum() == this.roundNum) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static enum AimType {
        LastSeenPlace,
        LookAhead,
        PatternPredict,
        Random;

        private static int size;

        static {
            size = AimType.values().length;
        }

        public static int Size() {
            return size;
        }
    }

    public static enum AimTypeEnemy {
        LastSeenPlace,
        LookAheadBasic,
        LookAhead;

    }
}

