/*
 * Decompiled with CFR 0.152.
 */
package omens;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class CannonfodderNano
extends AdvancedRobot {
    private boolean moveNow = true;
    private double bulletPower;

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(1.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.bulletPower = Math.min(400.0 / e.getDistance(), 3.0);
        this.linearTargeting(e);
        if (this.getTime() % 20L == 0L || this.moveNow) {
            this.goTo(Math.random() * this.getBattleFieldWidth(), Math.random() * this.getBattleFieldHeight());
            if (this.moveNow) {
                this.moveNow = false;
            }
        }
    }

    public void linearTargeting(ScannedRobotEvent e) {
        double hob = this.getHeadingRadians() + e.getBearingRadians();
        double lb = hob + Math.asin(e.getVelocity() / Rules.getBulletSpeed((double)this.bulletPower) * Math.sin(e.getHeadingRadians() - hob));
        this.turnGunRightRadians(Utils.normalRelativeAngle((double)(lb - this.getGunHeadingRadians())));
        this.setFire(this.bulletPower);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.moveNow = true;
    }

    private void goTo(double x, double y) {
        double a = Utils.normalRelativeAngle((double)(Math.atan2(x -= this.getX(), y -= this.getY()) - this.getHeadingRadians()));
        double ta = Math.atan(Math.tan(a));
        this.setTurnRightRadians(ta);
        this.setAhead(Math.hypot(x, y) * (double)(a == ta ? 1 : -1));
    }
}

