/*
 * Decompiled with CFR 0.152.
 */
package jaybot.adv.bots;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import jaybot.adv.intel.Bot;
import robocode.AdvancedRobot;

public class BotHelper {
    private static AdvancedRobot _$561 = null;
    private static Map _$562 = new HashMap();
    private static Map _$563 = new HashMap();
    private static Random _$564 = new Random();
    public static final double SYSTEM_MAX_TURNRATE = 10.0;
    public static final double SYSTEM_MAX_GUNTURNRATE = 20.0;
    public static final double SYSTEM_MAX_VELOCITY = 8.0;
    public static final double SYSTEM_MIN_BULLET_POWER = 0.1;
    public static final double SYSTEM_MAX_BULLET_POWER = 3.0;
    public static final double SYSTEM_MAX_SCAN_RANGE = 1200.0;
    public static final double SYSTEM_DAMAGE_FROM_COLLISION = 0.6;

    public static void setupRobot(AdvancedRobot bot) {
        _$561 = bot;
    }

    public static void reset() {
        _$562 = new HashMap();
    }

    public static AdvancedRobot getRobot() {
        return _$561;
    }

    public static int nextRndInt(int max) {
        return _$564.nextInt(max);
    }

    public static double nextRndDbl(double max) {
        return _$564.nextDouble() * max;
    }

    public static boolean nextRndBool() {
        return _$564.nextBoolean();
    }

    public static int nextRndInt(int min, int max) {
        return _$564.nextInt(max - min) + min;
    }

    public static double turnCircleRadius(double velocity) {
        return Math.abs(velocity) * 360.0 / (10.0 - 0.75 * Math.abs(velocity)) / (Math.PI * 2);
    }

    public static double normalizeAbsoluteAngleDegrees(double angleDegrees) {
        return angleDegrees += (double)((angleDegrees %= 360.0) < 0.0 ? 360 : 0);
    }

    public static double normalizeRelativeAngleDegrees(double angleDegrees) {
        if (angleDegrees > 180.0) {
            angleDegrees = angleDegrees % 360.0 - 360.0;
        }
        if (angleDegrees < -180.0) {
            angleDegrees = angleDegrees % 360.0 + 360.0;
        }
        return angleDegrees;
    }

    public static double getAngleBetweenPointsInDegrees(Point2D ptFrom, Point2D ptTo) {
        return BotHelper.normalizeAbsoluteAngleDegrees(Math.toDegrees(Math.atan2(ptTo.getX() - ptFrom.getX(), ptTo.getY() - ptFrom.getY())));
    }

    public static double bearingToHeadingDegrees(double bearingDegrees) {
        double heading = _$561.getHeading() + bearingDegrees;
        return BotHelper.normalizeAbsoluteAngleDegrees(heading);
    }

    public static double headingToBearingDegrees(double headingDegrees) {
        headingDegrees = BotHelper.normalizeAbsoluteAngleDegrees(headingDegrees);
        double bearing = headingDegrees - _$561.getHeading();
        bearing = BotHelper.normalizeRelativeAngleDegrees(bearing);
        return bearing;
    }

    public static Point2D projectPointInTime(Point2D startPos, double headingInDegrees, double velocity, double time) {
        return BotHelper.projectPointInSpace(startPos, headingInDegrees, velocity * time);
    }

    public static Point2D projectPointInSpace(Point2D startPos, double headingInDegrees, double distance) {
        headingInDegrees = BotHelper.normalizeAbsoluteAngleDegrees(headingInDegrees);
        return BotHelper.pointFromCoords(startPos.getX() + Math.sin(Math.toRadians(headingInDegrees)) * distance, startPos.getY() + Math.cos(Math.toRadians(headingInDegrees)) * distance);
    }

    public static Point2D pointFromCoords(double x, double y) {
        return new Point2D.Double(x, y);
    }

    public static boolean nearWall(Point2D pt, double distance) {
        return BotHelper.nearWall(pt.getX(), pt.getY(), distance);
    }

    public static boolean nearWall(double xPos, double yPos, double distance) {
        return xPos <= distance || xPos >= BotHelper.getFieldWidth() - distance || yPos <= distance || yPos >= BotHelper.getFieldHeight() - distance;
    }

    public static boolean inCorner(Point2D pt, double distance) {
        return BotHelper.inCorner(pt.getX(), pt.getY(), distance);
    }

    public static boolean inCorner(double xPos, double yPos, double distance) {
        double c1 = Math.sqrt(xPos * xPos + yPos * yPos);
        double c2 = Math.sqrt((xPos - BotHelper.getFieldWidth()) * (xPos - BotHelper.getFieldWidth()) + yPos * yPos);
        double c3 = Math.sqrt((xPos - BotHelper.getFieldWidth()) * (xPos - BotHelper.getFieldWidth()) + (yPos - BotHelper.getFieldHeight()) * (yPos - BotHelper.getFieldHeight()));
        double c4 = Math.sqrt(xPos * xPos + (yPos - BotHelper.getFieldHeight()) * (yPos - BotHelper.getFieldHeight()));
        return c1 <= distance || c2 <= distance || c3 <= distance || c4 <= distance;
    }

    public static double getTime() {
        return _$561.getTime();
    }

    public static double getX() {
        return _$561.getX();
    }

    public static double getY() {
        return _$561.getY();
    }

    public static Point2D getPosition() {
        return new Point2D.Double(BotHelper.getX(), BotHelper.getY());
    }

    public static void killEnemy(Bot e) {
        _$562.remove(e.getName());
    }

    public static void alert(String msg) {
        System.out.println("-- " + msg);
    }

    public static Bot getEnemy(String name) {
        Bot e = (Bot)_$562.get(name);
        if (e == null) {
            e = (Bot)_$563.get(name);
            if (e == null) {
                BotHelper.alert("New enemy: " + name);
                e = new Bot(name);
                _$563.put(name, e);
            } else {
                BotHelper.alert("Cached enemy: " + name);
                e.reset();
            }
            _$562.put(name, e);
        }
        return e;
    }

    public static Collection getEnemies() {
        return _$562.values();
    }

    public static Bot getClosestEnemy() {
        Bot nearest = null;
        double dist = 9.9999999E7;
        Point2D myPos = BotHelper.getPosition();
        Iterator i = _$562.values().iterator();
        while (i.hasNext()) {
            Bot e = (Bot)i.next();
            if (!e.hasPosition() || !(e.distanceTo(myPos) < dist)) continue;
            dist = e.distanceTo(myPos);
            nearest = e;
        }
        return nearest;
    }

    public static Point2D getEnemyMass() {
        double dx = 0.0;
        double dy = 0.0;
        int cnt = 0;
        Iterator i = _$562.values().iterator();
        while (i.hasNext()) {
            Bot e = (Bot)i.next();
            if (!e.hasPosition()) continue;
            dx += e.getX();
            dy += e.getY();
            ++cnt;
        }
        if (cnt > 0) {
            return new Point2D.Double(dx / (double)cnt, dy / (double)cnt);
        }
        return BotHelper.getFieldCenter();
    }

    public static void printEnemyGuessFactors() {
        String s = "Guess Factors:\n\n";
        Iterator i = _$563.values().iterator();
        while (i.hasNext()) {
            Bot e = (Bot)i.next();
            int[] gf = e.getAimFactors();
            s = s + "  " + e.getName() + ": ";
            for (int x = 0; x < gf.length; ++x) {
                s = s + gf[x] + ", ";
            }
            s = s + "\n";
        }
        System.out.println(s);
    }

    public static double getBulletDamageFromPower(double shotPower) {
        double damage = 4.0 * shotPower + (shotPower > 1.0 ? 2.0 * (shotPower - 1.0) : 0.0);
        return damage;
    }

    public static double getGunHeatGeneratedByPower(double shotPower) {
        return 1.0 + shotPower / 5.0;
    }

    public static double getBulletVelocityFromPower(double shotPower) {
        return 20.0 - 3.0 * shotPower;
    }

    public static double calcTurnCircleRadius(double velocity) {
        return Math.abs(velocity) * 360.0 / (10.0 - 0.75 * Math.abs(velocity)) / (Math.PI * 2);
    }

    public static void moveTank(Point2D point) {
        double distance = BotHelper.getPosition().distance(point);
        double heading = BotHelper.getAngleBetweenPointsInDegrees(BotHelper.getPosition(), point);
        double bearing = BotHelper.headingToBearingDegrees(heading);
        BotHelper.moveTank(bearing, distance);
    }

    public static void moveTank(double bearingInDegrees, double distance) {
        if (Math.abs(bearingInDegrees = BotHelper.normalizeRelativeAngleDegrees(bearingInDegrees)) > 90.0) {
            distance *= -1.0;
            bearingInDegrees = bearingInDegrees > 0.0 ? (bearingInDegrees -= 180.0) : (bearingInDegrees += 180.0);
        }
        if (bearingInDegrees != 0.0) {
            _$561.setTurnRight(bearingInDegrees);
        }
        if (distance != 0.0) {
            _$561.setAhead(distance);
        }
    }

    public static void turnGunToBearingDegrees(double bearingDegrees) {
        double gunBearing = BotHelper.headingToBearingDegrees(_$561.getGunHeading());
        double delta = gunBearing - bearingDegrees;
        if (delta > 180.0) {
            _$561.setTurnGunRight(360.0 - delta);
        } else if (delta < -180.0) {
            _$561.setTurnGunLeft(360.0 - Math.abs(delta));
        } else {
            _$561.setTurnGunLeft(delta);
        }
    }

    public static void turnTankToBearingDegrees(double bearingInDegrees) {
        double tankBearing = BotHelper.headingToBearingDegrees(_$561.getHeading());
        double delta = tankBearing - bearingInDegrees;
        if (delta > 180.0) {
            _$561.setTurnRight(360.0 - delta);
        } else if (delta < -180.0) {
            _$561.setTurnLeft(360.0 - Math.abs(delta));
        } else {
            _$561.setTurnLeft(delta);
        }
    }

    public static boolean isTankMoveDone(int threshold) {
        return Math.abs(_$561.getDistanceRemaining()) <= (double)threshold;
    }

    public static boolean isRadarMoveDone(int threshold) {
        return Math.abs(_$561.getRadarTurnRemaining()) <= (double)threshold;
    }

    public static boolean isGunMoveDone(int threshold) {
        return Math.abs(_$561.getGunTurnRemaining()) <= (double)threshold;
    }

    public static int getSign(double ofNumber) {
        return ofNumber < 0.0 ? -1 : 1;
    }

    public static Point2D getFieldCenter() {
        Point2D.Double center = new Point2D.Double(_$561.getBattleFieldWidth() / 2.0, _$561.getBattleFieldHeight() / 2.0);
        return center;
    }

    public static double getFieldWidth() {
        return _$561.getBattleFieldWidth();
    }

    public static double getFieldHeight() {
        return _$561.getBattleFieldHeight();
    }
}

