/*
 * Decompiled with CFR 0.152.
 */
package jaybot.adv.bots;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import jaybot.adv.bots.BaseAdvBot;
import jaybot.adv.bots.BotHelper;
import jaybot.adv.events.BaseCondition;
import jaybot.adv.events.TimerEvent;
import jaybot.adv.intel.Bot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class JayBot
extends BaseAdvBot {
    protected static final int MODE_MASS_MELEE = 4;
    protected static final int MODE_MELEE = 3;
    protected static final int MODE_THREESOME = 2;
    protected static final int MODE_ONE_ON_ONE = 1;
    protected int mode = 1;
    private static final int _$307 = 20;
    private int _$308 = 1;
    private int _$309 = 0;
    private boolean _$310 = false;
    private int _$311 = 50;
    private Bot _$312 = null;
    private Object _$313 = new Object();
    private double _$314 = 0.0;
    private double _$315 = 1.0;
    private int _$316 = 0;
    protected static double MIN_DISTANCE_TO_MOSH;
    protected static double MAX_DISTANCE_TO_CENTER;
    protected static final double MAX_TURN = 45.0;
    protected static final double MIN_MOVE = 55.0;
    protected static final double MIN_TURN_GAP = 15.0;
    protected boolean initMosh = false;
    protected static final double MIN_DIST_REMAINING_TO_CHANGE_MOVE = 10.0;
    protected static final double MIN_TURN_REMAINING_TO_CHANGE_MOVE = 45.0;
    protected static final double MIN_DIST_OF_NEARBY_ENEMY_TO_CHANGE_MODE = 215.0;
    protected static final double MIN_DISTANCE_TARGET_MOVE_MODE = 300.0;
    static final double FIREPOWER = 3.0;
    static final double FIRESPEED;
    private static final String _$330 = "WIGTIM";
    private static final String _$331 = "RISKMAPUDT";
    private static final int _$332 = 5;
    double circWallRadius;
    double circWallCircum;
    int circWallSegments;
    Point2D[] circWallSpots;
    int circWallCurrent = 0;
    int circDirection = 1;
    int safeSpot;
    private static final String _$340 = "CMC";
    private static final int _$341 = 30;
    private static double _$342;
    private static final double _$343;
    boolean initialized = false;
    boolean targetMoveMode = true;
    double timeSinceLastDirectionCheck = 0.0;

    protected void doOneTimeSetup() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.addCustomEvent(new TimerEvent(_$330, 79, 20.0, true));
        if (!this.initialized) {
            _$342 = BotHelper.calcTurnCircleRadius(8.0) * 1.1 + 10.0;
            this.circWallRadius = Math.min(BotHelper.getFieldCenter().getX(), BotHelper.getFieldCenter().getY()) - 30.0;
            this.circWallCircum = Math.PI * 2 * this.circWallRadius;
            this.circWallSegments = (int)Math.ceil(this.circWallCircum / _$342);
            this.circWallSpots = new Point2D[this.circWallSegments];
            double startAngle = 0.0;
            double angleDelta = 360 / this.circWallSegments;
            for (int i = 0; i < this.circWallSegments; ++i) {
                this.circWallSpots[i] = BotHelper.projectPointInSpace(BotHelper.getFieldCenter(), startAngle, this.circWallRadius);
                startAngle += angleDelta;
            }
            this.initialized = true;
        }
        Point2D myPos = BotHelper.getPosition();
        for (int i = 0; i < this.circWallSegments; ++i) {
            if (!(myPos.distance(this.circWallSpots[i]) < myPos.distance(this.circWallSpots[this.circWallCurrent]))) continue;
            this.circWallCurrent = i;
        }
        this.addCustomEvent(new TimerEvent(_$331, 79, 5.0, true));
        this.addCustomEvent(new BaseCondition(_$340, 80){

            public boolean test() {
                Point2D myPos = BotHelper.getPosition();
                return myPos.distance(JayBot.this.circWallSpots[JayBot.this.circWallCurrent]) < _$343;
            }
        });
    }

    protected void doRunStep() {
        int o = this.getOthers();
        int oldMode = this.mode;
        if (o > 8) {
            this.mode = 4;
            if (this.mode != oldMode) {
                this.setupModeMassMelee();
            }
        } else if (o > 2) {
            this.mode = 3;
            if (this.mode != oldMode) {
                this.setupModeMelee();
            }
        } else if (o > 1) {
            this.mode = 2;
            if (this.mode != oldMode) {
                this.setupModeThreesome();
            }
        } else {
            this.mode = 1;
            if (this.mode != oldMode) {
                this.setupModeOneOnOne();
            }
        }
        this.stepRadar();
        this.stepTargetSelection();
        Bot close = BotHelper.getClosestEnemy();
        Point2D myPos = BotHelper.getPosition();
        if (close != null && close.distanceTo(myPos) < 215.0 || this.mode == 1) {
            this.stepMovement();
        } else {
            this.stepMovementCircle();
        }
        this.stepGun2();
        this.execute();
    }

    protected void stepRadar() {
        boolean modeOne = false;
        if (this.hasTarget() && this.mode == 1) {
            modeOne = true;
        }
        if (!(modeOne = true)) {
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        } else {
            if (this._$310) {
                if (BotHelper.isRadarMoveDone(1)) {
                    this._$310 = false;
                } else {
                    return;
                }
            }
            if (!this.hasTarget()) {
                this.setTurnRadarRight(360.0);
            } else {
                ++this._$309;
                if (this._$309 > this._$311) {
                    this._$309 = 0;
                    this._$310 = true;
                    this.setTurnRadarRight(360.0);
                    return;
                }
                double turn = this.getHeading() - this.getRadarHeading() + this._$312.getBearing();
                this.setTurnRadarRight(turn += (double)(20 * this._$308));
                this._$308 *= -1;
            }
        }
    }

    protected void stepTargetSelection() {
    }

    protected void stepMovementCircle() {
        Point2D dest = this.circWallSpots[this.circWallCurrent];
        double angleToCircSpot = BotHelper.getAngleBetweenPointsInDegrees(BotHelper.getPosition(), dest);
        double bearingToCircSpot = BotHelper.headingToBearingDegrees(angleToCircSpot);
        double dist = BotHelper.getPosition().distance(dest);
        BotHelper.moveTank(dest);
    }

    protected void stepMovement() {
        double direction;
        Point2D moshPit;
        if (!this.initMosh) {
            MAX_DISTANCE_TO_CENTER = (BotHelper.getFieldWidth() + BotHelper.getFieldHeight()) / 2.0 * 0.9;
            MIN_DISTANCE_TO_MOSH = MAX_DISTANCE_TO_CENTER * 0.75;
            this.initMosh = true;
        }
        Point2D myPos = BotHelper.getPosition();
        boolean oldMoveMode = this.targetMoveMode;
        Bot closest = BotHelper.getClosestEnemy();
        if (closest == null) {
            if (closest != null && closest.distanceTo(myPos) < 125.0) {
                moshPit = closest.getPosition();
                this.targetMoveMode = true;
            } else {
                moshPit = BotHelper.getEnemyMass();
                this.targetMoveMode = false;
            }
        } else {
            moshPit = closest.getPosition();
            this.targetMoveMode = true;
        }
        MIN_DISTANCE_TO_MOSH = this.targetMoveMode ? 300.0 : MAX_DISTANCE_TO_CENTER * 0.5;
        if (this.targetMoveMode != oldMoveMode) {
            System.out.println("Changing targetMoveMode to " + this.targetMoveMode);
        }
        double headingToMosh = BotHelper.getAngleBetweenPointsInDegrees(myPos, moshPit);
        double bearingToMosh = BotHelper.headingToBearingDegrees(headingToMosh);
        double sign = BotHelper.getSign(bearingToMosh);
        double turnAmount = this._$314;
        double distanceToMosh = myPos.distance(moshPit);
        double distanceToCenter = myPos.distance(BotHelper.getFieldCenter());
        if (distanceToMosh < MIN_DISTANCE_TO_MOSH && distanceToCenter < MAX_DISTANCE_TO_CENTER) {
            turnAmount -= 10.0;
        } else if (distanceToCenter < MAX_DISTANCE_TO_CENTER) {
            turnAmount += 10.0;
        }
        double turnBearing = BotHelper.normalizeRelativeAngleDegrees(bearingToMosh - sign * (90.0 - turnAmount * this._$315));
        turnBearing = Math.min(Math.max(turnBearing, -45.0), 45.0);
        if (this.getTurnRemaining() < 45.0) {
            BotHelper.turnTankToBearingDegrees(turnBearing);
        }
        double timeElapsed = (double)this.getTime() - this.timeSinceLastDirectionCheck;
        int maxTime = 8;
        if (this.mode == 4) {
            maxTime = 2;
        } else if (this.mode == 3) {
            maxTime = 4;
        }
        if (timeElapsed > (double)maxTime) {
            this.timeSinceLastDirectionCheck = this.getTime();
            if (BotHelper.nextRndInt(10) <= 1) {
                this.reverseDirection();
            }
        }
        ++this._$316;
        double offset = this._$316 % 3 + 1;
        double moveTotal = 55.0 + (double)BotHelper.nextRndInt((int)(100.0 * offset));
        if (this.movePutsMeNearWall(moveTotal, direction = this._$315)) {
            if (!this.movePutsMeNearWall(moveTotal, -direction)) {
                direction *= -1.0;
            } else {
                double angleToCenter = BotHelper.getAngleBetweenPointsInDegrees(BotHelper.getPosition(), BotHelper.getFieldCenter());
                Point2D towardsCenter = BotHelper.projectPointInSpace(BotHelper.getPosition(), angleToCenter + (double)BotHelper.nextRndInt(40) - 20.0, moveTotal);
                BotHelper.moveTank(towardsCenter);
                return;
            }
        }
        double moveAmount = moveTotal * direction;
        this._$315 = direction;
        if (this.getDistanceRemaining() <= 10.0) {
            this.setAhead(moveAmount);
        }
    }

    protected void reverseDirection() {
        this._$315 *= -1.0;
    }

    protected boolean movePutsMeNearWall(double moveAmount, double direction) {
        double tankHeading = this.getHeading();
        Point2D futurePos = BotHelper.projectPointInSpace(BotHelper.getPosition(), tankHeading, moveAmount * direction);
        return BotHelper.nearWall(futurePos, 80.0);
    }

    protected void stepGun() {
        if (!this.hasTarget()) {
            return;
        }
        Point2D myPos = BotHelper.getPosition();
        int mostVisited = 12;
        for (int i = 0; i < 25; ++i) {
            if (this._$312.getAimFactors()[i] <= this._$312.getAimFactors()[mostVisited]) continue;
            mostVisited = i;
        }
        double enemyAbsoluteBearing = this.getHeadingRadians() + Math.toRadians(this._$312.getBearing());
        double directionToEnemy = (double)(this._$312.getVelocity() * Math.sin(Math.toRadians(this._$312.getHeading()) - enemyAbsoluteBearing) < 0.0 ? -1 : 1) * 0.8 / 12.0;
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + directionToEnemy * (double)(mostVisited - 12))));
        if (BotHelper.isGunMoveDone(1) && this.getGunHeat() < 0.1) {
            double fp = 3.0;
            if (this._$312.distanceTo(myPos) > 300.0) {
                fp = 3.0;
            }
            this.setFire(fp);
        }
    }

    protected void stepGun2() {
        Point2D badGuyLocation;
        if (!this.hasTarget()) {
            return;
        }
        Point2D myLocation = BotHelper.getPosition();
        double latAngle = this._$312.calcTargetLateralMovementAngle(myLocation);
        Point2D badGuyNextLocation = badGuyLocation = this._$312.getPosition();
        double badGuyDistance = myLocation.distance(badGuyLocation);
        double shotPower = 3.0;
        if (badGuyDistance > 250.0 && this.mode == 1 && this.getEnergy() < 20.0) {
            shotPower = badGuyDistance > 600.0 ? 0.1 : (badGuyDistance > 400.0 ? 1.0 : 1.72);
        }
        shotPower = Math.max(0.1, Math.min(3.0, shotPower + 0.5 - BotHelper.nextRndDbl(1.0)));
        double newDistance = badGuyDistance;
        double badGuyHeading = 0.0;
        if (this._$312.getVelocity() != 0.0) {
            badGuyHeading = Math.toRadians(this._$312.getHeading());
        }
        double badGuyVelocity = this._$312.getVelocity();
        double bulletVelocity = BotHelper.getBulletVelocityFromPower(shotPower);
        int iterationCount = 0;
        boolean hitWall = false;
        double oldTime = 0.0;
        double newTime = badGuyDistance / bulletVelocity;
        double targetBearing = BotHelper.headingToBearingDegrees(BotHelper.getAngleBetweenPointsInDegrees(myLocation, badGuyNextLocation));
        Rectangle2D.Double fieldRect = new Rectangle2D.Double(0.0, 0.0, BotHelper.getFieldWidth(), BotHelper.getFieldHeight());
        while (!hitWall && iterationCount < 20 && Math.abs(oldTime - newTime) > 1.0E-4) {
            ++iterationCount;
            oldTime = newTime;
            badGuyNextLocation = BotHelper.pointFromCoords(badGuyLocation.getX() + Math.sin(badGuyHeading) * badGuyVelocity * oldTime, badGuyLocation.getY() + Math.cos(badGuyHeading) * badGuyVelocity * oldTime);
            if (!fieldRect.contains(badGuyNextLocation)) {
                hitWall = true;
                if (badGuyNextLocation.getY() < fieldRect.getMinX()) {
                    badGuyNextLocation.setLocation(badGuyNextLocation.getX(), fieldRect.getMinX());
                }
                if (badGuyNextLocation.getX() < fieldRect.getMinY()) {
                    badGuyNextLocation.setLocation(fieldRect.getMinY(), badGuyNextLocation.getY());
                }
                if (badGuyNextLocation.getX() > BotHelper.getFieldWidth()) {
                    badGuyNextLocation.setLocation(BotHelper.getFieldWidth(), badGuyNextLocation.getY());
                }
                if (badGuyNextLocation.getY() > BotHelper.getFieldHeight()) {
                    badGuyNextLocation.setLocation(badGuyNextLocation.getX(), BotHelper.getFieldHeight());
                }
            }
            targetBearing = BotHelper.headingToBearingDegrees(BotHelper.getAngleBetweenPointsInDegrees(myLocation, badGuyNextLocation));
            newDistance = myLocation.distance(badGuyNextLocation);
            newTime = newDistance / bulletVelocity;
        }
        BotHelper.turnGunToBearingDegrees(targetBearing);
        if (BotHelper.isGunMoveDone(BotHelper.nextRndInt(2) + 1) && this.getGunHeat() < 0.1) {
            this.setFire(shotPower);
        }
    }

    protected void doOneTimeEnding() {
        System.out.println();
        BotHelper.printEnemyGuessFactors();
    }

    protected void doScanRobot(ScannedRobotEvent event, Bot badGuy) {
        if (!this.hasTarget()) {
            this.setTarget(badGuy);
        }
        Point2D myPos = BotHelper.getPosition();
        if (!this.isTarget(badGuy) && badGuy.distanceTo(myPos) < this._$312.distanceTo(myPos) - 35.0) {
            this.setTarget(badGuy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRobotDied(RobotDeathEvent event, Bot badGuy) {
        Object object = this._$313;
        synchronized (object) {
            if (this.isTarget(badGuy)) {
                this.clearTarget();
                this._$312 = BotHelper.getClosestEnemy();
            }
        }
    }

    protected void doCustomEvent(CustomEvent event) {
        String eventName = event.getCondition().getName();
        if (eventName.equals(_$330)) {
            this._$314 = BotHelper.nextRndInt(-10, 10);
        } else if (eventName.equals(_$331)) {
            this.updateRiskMap();
        } else if (eventName.equals(_$340)) {
            this.incWallCurrent();
        } else {
            BotHelper.alert("Unknown custom event: " + event.getCondition().getName());
        }
    }

    protected void incWallCurrent() {
        this.circWallCurrent += this.circDirection;
        if (this.circWallCurrent >= this.circWallSpots.length) {
            this.circWallCurrent = 0;
        } else if (this.circWallCurrent < 0) {
            this.circWallCurrent = this.circWallSpots.length - 1;
        }
    }

    public void updateRiskMap() {
        double[] spotScore = new double[this.circWallSpots.length];
        Collection enemyList = BotHelper.getEnemies();
        double dx = 0.0;
        double dy = 0.0;
        int cnt = 0;
        Iterator i = enemyList.iterator();
        while (i.hasNext()) {
            Bot e = (Bot)i.next();
            if (!e.hasPosition()) continue;
            dx += e.getX();
            dy += e.getY();
            ++cnt;
        }
        if (cnt != 0) {
            Point2D.Double mosh = new Point2D.Double(dx /= (double)cnt, dy /= (double)cnt);
            double furthest = 0.0;
            int furthestSpot = 0;
            for (int i2 = 0; i2 < this.circWallSpots.length; ++i2) {
                double dist = mosh.distance(this.circWallSpots[i2]);
                if (!(dist > furthest)) continue;
                furthest = dist;
                furthestSpot = i2;
            }
            this.safeSpot = furthestSpot;
            int oldDirection = this.circDirection;
            this.circDirection = this.directionBetweenSpots(this.circWallCurrent, this.safeSpot);
            if (this.circDirection == oldDirection && BotHelper.nextRndInt(10) <= 1) {
                this.circDirection *= -1;
            }
        }
    }

    protected int directionBetweenSpots(int fromSpot, int toSpot) {
        int distance = (fromSpot = this.normalizeSpot(fromSpot)) - (toSpot = this.normalizeSpot(toSpot));
        if (distance < -1) {
            return 1;
        }
        if (distance > 1) {
            return -1;
        }
        if (BotHelper.nextRndBool()) {
            return 1;
        }
        return -1;
    }

    protected int normalizeSpot(int spot) {
        int halfway = this.circWallSpots.length / 2;
        if (spot < halfway) {
            return spot;
        }
        return -1 * (this.circWallSpots.length - halfway);
    }

    protected void doDeath(DeathEvent event) {
    }

    protected void doBulletHit(BulletHitEvent event, Bot badGuy) {
    }

    protected void doBulletHitBullet(BulletHitBulletEvent event, Bot badGuy) {
    }

    protected void doBulletMissed(BulletMissedEvent event) {
    }

    protected void doHitByBullet(HitByBulletEvent event, Bot badGuy) {
    }

    protected void doCollision(HitRobotEvent event, Bot badGuy, boolean movingForward) {
        this.setTarget(badGuy);
        if (movingForward) {
            this.reverseDirection();
        }
        if (movingForward) {
            this.circDirection *= -1;
            this.incWallCurrent();
            this.incWallCurrent();
        }
    }

    protected void doHitWall(HitWallEvent event) {
        this.reverseDirection();
    }

    protected void doWin(WinEvent event) {
    }

    protected void setupModeOneOnOne() {
        this.stop(true);
        this._$310 = false;
        this._$311 = 20;
        BotHelper.alert("MODE: OneOnOne w/radar 360 at " + this._$311);
    }

    protected void setupModeThreesome() {
        this.stop(true);
        this._$311 = 10;
        BotHelper.alert("MODE: Threesome w/radar 360 at " + this._$311);
    }

    protected void setupModeMelee() {
        this.stop(true);
        this._$311 = 3;
        BotHelper.alert("MODE: Melee w/radar 360 at " + this._$311);
    }

    protected void setupModeMassMelee() {
        this.stop(true);
        this._$311 = 0;
        this._$310 = true;
        this.setTurnRadarRight(3600.0);
        this.execute();
        BotHelper.alert("MODE: MassMelee w/radar 360 at " + this._$311);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTarget(Bot badGuy) {
        Object object = this._$313;
        synchronized (object) {
            if (!this.isTarget(badGuy)) {
                BotHelper.alert("Targetting: " + badGuy);
            }
            this._$312 = badGuy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTarget() {
        Object object = this._$313;
        synchronized (object) {
            this._$312 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasTarget() {
        Object object = this._$313;
        synchronized (object) {
            return this._$312 != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTarget(Bot testBadGuy) {
        Object object = this._$313;
        synchronized (object) {
            return this._$312 == testBadGuy;
        }
    }

    static {
        FIRESPEED = BotHelper.getBulletVelocityFromPower(3.0);
        _$342 = 100.0;
        _$343 = _$342 * 0.8;
    }
}

