/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.Random;
import jwirde.CoordUtils;
import jwirde.Environment;
import jwirde.Ghost;
import jwirde.MovementStrategy;
import jwirde.VectPol;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class GravityMovement
implements MovementStrategy {
    private static final double PUSH_POWER = 1.0E7;
    private static final double WALL_POWER = 5.0E8;
    private static final double POWER_CUTOFF = 20.0;
    private final double maxX;
    private final double maxY;
    private Random myRandom = new Random(new Date().getTime());
    private final AdvancedRobot myRobot;
    private final Environment env;
    private final Point2D center;

    public GravityMovement(AdvancedRobot myRobot, Environment env) {
        this.myRobot = myRobot;
        this.env = env;
        this.maxX = myRobot.getBattleFieldWidth();
        this.maxY = myRobot.getBattleFieldHeight();
        this.center = new Point2D.Double(this.maxX / 2.0, this.maxY / 2.0);
    }

    @Override
    public void moveRobot() {
        Point2D.Double myPos = new Point2D.Double(this.myRobot.getX(), this.myRobot.getY());
        VectPol sumForces = new VectPol(0.0, 0.0);
        for (Ghost ghost : this.env.getFoes()) {
            sumForces = sumForces.add(this.calcForce(myPos, ghost.coord, 1.0E7));
        }
        sumForces.add(this.calcForce(myPos, this.center, 2.0E7));
        sumForces = sumForces.add(this.calcWallForces(myPos));
        if (sumForces.magnitude > 20.0) {
            this.myRobot.setTurnRightRadians(Utils.normalRelativeAngle((double)(sumForces.angle - this.myRobot.getHeadingRadians())));
            this.myRobot.setAhead(100.0);
        } else if (Utils.isNear((double)this.myRobot.getVelocity(), (double)0.0)) {
            this.myRobot.setTurnRightRadians(Utils.normalRelativeAngle((double)(this.myRandom.nextDouble() * 2.0 * Math.PI)));
            this.myRobot.setAhead(50.0);
        }
    }

    private VectPol calcWallForces(Point2D coord) {
        double currentWallPower = 5.0E8 * (double)this.myRobot.getOthers();
        VectPol leftWallForce = new VectPol(1.5707963267948966, currentWallPower / Math.pow(coord.getX(), 3.0));
        VectPol rightWallForce = new VectPol(-1.5707963267948966, currentWallPower / Math.pow(this.maxX - coord.getX(), 3.0));
        VectPol bottomWallForce = new VectPol(0.0, currentWallPower / Math.pow(coord.getY(), 3.0));
        VectPol topWallForce = new VectPol(Math.PI, currentWallPower / Math.pow(this.maxY - coord.getY(), 3.0));
        return leftWallForce.add(rightWallForce).add(bottomWallForce).add(topWallForce);
    }

    private VectPol calcForce(Point2D coord, Point2D coord2, double power) {
        double dist = coord.distance(coord2);
        double angle = CoordUtils.getRelativeAngle(coord, coord2, 0.0) - Math.PI;
        return new VectPol(angle, power / (dist * dist));
    }

    @Override
    public void onPaint(Graphics2D g) {
        Point2D.Double myPos = new Point2D.Double(this.myRobot.getX(), this.myRobot.getY());
        VectPol sumForces = new VectPol(0.0, 0.0);
        for (Ghost ghost : this.env.getFoes()) {
            VectPol ghostForce = this.calcForce(myPos, ghost.coord, 1.0E7);
            CoordUtils.drawVect(g, Color.GREEN, myPos, ghostForce);
            sumForces = sumForces.add(ghostForce);
        }
        CoordUtils.drawVect(g, Color.BLUE, myPos, sumForces);
        CoordUtils.drawVect(g, Color.CYAN, myPos, this.calcWallForces(myPos));
        CoordUtils.drawVect(g, Color.RED, myPos, this.calcForce(myPos, this.center, 2.0E7));
    }

    @Override
    public void onHitByBullet(Ghost shooter) {
    }
}

