/*
 * Decompiled with CFR 0.152.
 */
package brainfade.melee.utils;

import brainfade.melee.utils.Enemy;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class MeleePM {
    public static final double samplePeriod = 8.0;
    public static final int window = 16;
    public static final int historySize = 5000;
    public String name;
    public double X;
    public double Y;
    public double bearing;
    public double distance;
    public double next_sample_time;
    public double energy;
    public double previousHeading;
    public double previousX;
    public double previousY;
    public int PC = 0;
    public float[] dX = new float[5000];
    public float[] dY = new float[5000];
    boolean set = true;

    public void init() {
        this.next_sample_time = 0.0;
        this.set = false;
    }

    public void addMove(double eX, double eY) {
        double sampledHeading = Math.atan2(eX - this.previousX, eY - this.previousY);
        double dist = Point2D.distance(eX, eY, this.previousX, this.previousY);
        if (dist == 0.0) {
            sampledHeading = this.previousHeading;
        }
        double ang = Utils.normalRelativeAngle((double)(sampledHeading - this.previousHeading));
        int pcounter = this.PC % 5000;
        if (this.next_sample_time > 16.0) {
            this.dX[pcounter] = (float)(dist * Math.sin(ang));
            this.dY[pcounter] = (float)(dist * Math.cos(ang));
            ++this.PC;
            if (this.PC > 10000) {
                this.PC -= 5000;
            }
        }
        if (dist != 0.0) {
            this.previousHeading = sampledHeading;
        }
        this.previousX = eX;
        this.previousY = eY;
    }

    public int findPattern(int windowSize, int start) {
        int index = this.PC;
        double error = Double.POSITIVE_INFINITY;
        for (int i = start; i < Math.min(this.PC, 5000) - windowSize; ++i) {
            int ind;
            double thiserror = 0.0;
            for (int j = 1; j <= windowSize && thiserror < error; thiserror += (double)(windowSize + 3 - j) * Point2D.distanceSq(this.dX[ind % 5000], this.dY[ind % 5000], this.dX[(ind - i) % 5000], this.dY[(ind - i) % 5000]), ++j) {
                ind = this.PC - j;
            }
            if (!(thiserror < error)) continue;
            error = thiserror;
            index = i;
        }
        return this.PC - index - 1;
    }

    public Point2D predictAngle(double myX, double myY, double bp, double time) {
        double displ;
        double bv = 20.0 - 3.0 * bp;
        int ip = this.findPattern(16, (int)(this.distance / (8.0 * bv)));
        double db = (-8.0 + this.next_sample_time - time) * bv;
        double nX = this.previousX;
        double nY = this.previousY;
        double nHeading = this.previousHeading;
        double dE = Point2D.distance(myX, myY, nX, nY);
        while ((db += 8.0 * bv) < (dE = Point2D.distance(myX, myY, nX += (displ = Point2D.distance(0.0, 0.0, this.dX[ip = (ip + 1) % 5000], this.dY[ip])) * Math.sin(nHeading += Math.atan2(this.dX[ip], this.dY[ip])), nY += displ * Math.cos(nHeading)))) {
        }
        displ /= 8.0;
        while ((db -= bv) > (dE = Point2D.distance(myX, myY, nX -= displ * Math.sin(nHeading), nY -= displ * Math.cos(nHeading)))) {
        }
        return new Point2D.Double(nX, nY);
    }

    public void updateInfo(double t, double ex, double ey, double ebearing, double edist, double eEnergy) {
        this.X = ex;
        this.Y = ey;
        this.bearing = ebearing;
        this.distance = edist;
        this.energy = eEnergy;
        if (t >= this.next_sample_time) {
            this.next_sample_time += 8.0;
            this.addMove(ex, ey);
        }
    }

    public void updateInfo(Enemy target) {
        this.name = target.name;
        this.X = target.position.getX();
        this.Y = target.position.getY();
        this.bearing = Utils.normalRelativeAngle((double)target.bearing);
        this.distance = target.distance;
        this.energy = target.energy;
        if ((double)target.time >= this.next_sample_time) {
            this.next_sample_time += 8.0;
            this.addMove(this.X, this.Y);
        }
    }
}

