/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.EscapeEnvelope;

import java.awt.Color;
import rdt.Wraith.Configuration;
import rdt.Wraith.EscapeEnvelope.EscapeEnvelopeData;
import rdt.Wraith.EscapeEnvelope.EscapeEnvelopePayload;
import rdt.Wraith.EscapeEnvelope.IEscapeEnvelopeRecorder;
import rdt.Wraith.EscapeEnvelope.PendingEntry;
import rdt.Wraith.EscapeEnvelope.PendingQueue;
import rdt.Wraith.IRobot;
import rdt.Wraith.KDTree.KdTree;
import rdt.Wraith.MEA.IMEACalculator;
import rdt.Wraith.MEA.MEA;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.Target;

public final class EscapeEnvelope
implements IEscapeEnvelopeRecorder,
IMEACalculator {
    private static final int MAX_RETRIEVED_PAYLOADS = 100;
    private final IRobot _robot;
    private final PendingQueue _queue;
    private final Target _target;
    private final KdTree<EscapeEnvelopePayload> _kdTree;
    private final EscapeEnvelopePayload[] _retrievedPayloads = new EscapeEnvelopePayload[100];
    private final EscapeEnvelopeData _data = new EscapeEnvelopeData();

    public EscapeEnvelope(IRobot robot, Target target) {
        this._robot = robot;
        this._queue = new PendingQueue(robot);
        this._target = target;
        Configuration.EscapeEnvelopeDimensions.SetRobot(robot);
        this._kdTree = new KdTree(Configuration.EscapeEnvelopeDimensions.NumDimensions);
    }

    @Override
    public boolean CalculateMEA(double sourceX, double sourceY, RobotSnapshot target, long numTicks, double bulletVelocity, MEA outMEA) {
        if (!this.GetEscapeEnvelopeData(target, this._data)) {
            return false;
        }
        this._data.GetMEA(sourceX, sourceY, target.LocationX, target.LocationY, target.RotationDirectionToTarget, outMEA);
        return true;
    }

    public boolean CalculateMEAWithData(double sourceX, double sourceY, RobotSnapshot target, long numTicks, MEA outMEA, EscapeEnvelopeData outData) {
        if (!this.GetEscapeEnvelopeData(target, outData)) {
            return false;
        }
        outData.GetMEA(sourceX, sourceY, target.LocationX, target.LocationY, target.RotationDirectionToTarget, outMEA);
        return true;
    }

    @Override
    public EscapeEnvelopeData GetEscapeEnvelopeData(double sourceX, double sourceY, RobotSnapshot target, long numTicks, double bulletVelocity) {
        this.GetEscapeEnvelopeData(target, this._data);
        return this._data;
    }

    @Override
    public Color GetDebugColour() {
        return Color.magenta;
    }

    private boolean GetEscapeEnvelopeData(RobotSnapshot target, EscapeEnvelopeData outData) {
        return false;
    }

    public void Update(long numTicks) {
        if (!this._target.Valid || !this._target.Alive || this._target.Disabled || this._robot.IsDisabled()) {
            return;
        }
        long currentTick = this._robot.getTime();
        this._queue.CheckQueue(currentTick, this);
        this._queue.QueueEntry(currentTick, numTicks);
    }

    @Override
    public void RecordNewPayload(PendingEntry entry) {
    }
}

