/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns.GunImplementations.DC;

import rdt.Wraith.Guns.GunImplementations.Segmented.Segmentation;
import rdt.Wraith.IRobot;
import rdt.Wraith.MEA.MEA;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;

public class DimensionConfiguration {
    public final Segmentation[] Segmentations;
    public final int NumDimensions;

    public DimensionConfiguration(Segmentation[] segmentations) {
        this.Segmentations = segmentations;
        this.NumDimensions = this.Segmentations.length;
    }

    public void SetRobot(IRobot robot) {
        for (int index = 0; index < this.NumDimensions; ++index) {
            this.Segmentations[index].SetRobot(robot);
        }
    }

    public double[] ConvertFromSnapshot(RobotSnapshot snapshot, MEA mea) {
        double[] dimensionValues = new double[this.NumDimensions];
        for (int index = 0; index < this.NumDimensions; ++index) {
            dimensionValues[index] = Math.max(0.0, Math.min(1.0, this.Segmentations[index].GetSegment01WithMEA(snapshot, mea)));
        }
        return dimensionValues;
    }
}

