/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.Wraith.DangerPrediction.CachedVelocityData;
import rdt.Wraith.DangerPrediction.MovementCommand;
import rdt.Wraith.DangerPrediction.PredictedRobotState;
import rdt.Wraith.EnemyPrediction.PredictedPosition;
import rdt.Wraith.IRobot;

public class MoveToCalculator {
    private static ArrayList<ArrayList<PredictedPosition>> _debug = new ArrayList();

    public static ArrayList<PredictedPosition> PredictRouteToXY(double startX, double startY, double startAbsHeading, double startVelocityAlongHeading, double targetX, double targetY) {
        double distanceY;
        PredictedPosition position;
        double distanceX;
        double distanceSq;
        ArrayList<PredictedPosition> predictedPositions = new ArrayList<PredictedPosition>();
        CachedVelocityData currentVelocity = CachedVelocityData.Get(startVelocityAlongHeading);
        PredictedRobotState nextState = new PredictedRobotState();
        PredictedRobotState currentState = new PredictedRobotState();
        currentState.X = startX;
        currentState.Y = startY;
        currentState.Velocity = startVelocityAlongHeading;
        currentState.Heading = startAbsHeading;
        currentState.PredictionTick = 0L;
        double reachedTargetDistanceSq = 676.0;
        do {
            CachedVelocityData nextVelocity = MoveToCalculator.GetNextState(currentState, currentVelocity, nextState, targetX, targetY);
            position = new PredictedPosition();
            position.X = nextState.X;
            position.Y = nextState.Y;
            position.Tick = nextState.PredictionTick;
            predictedPositions.add(position);
            currentState.Copy(nextState);
            currentVelocity = nextVelocity;
        } while (!((distanceSq = (distanceX = position.X - targetX) * distanceX + (distanceY = position.Y - targetY) * distanceY) <= reachedTargetDistanceSq));
        return predictedPositions;
    }

    private static CachedVelocityData GetNextState(PredictedRobotState currentState, CachedVelocityData currentVelocity, PredictedRobotState nextState, double targetX, double targetY) {
        PredictedRobotState possibleNextState = new PredictedRobotState();
        double closestDistanceSq = Double.MAX_VALUE;
        CachedVelocityData bestVelocityData = null;
        for (int possibleNextCommand = 0; possibleNextCommand < 6; ++possibleNextCommand) {
            CachedVelocityData possibleNextVelocity = MovementCommand.PredictCommandFast(possibleNextCommand, currentState, possibleNextState, currentVelocity);
            double distanceX = possibleNextState.X - targetX;
            double distanceY = possibleNextState.Y - targetY;
            double distanceSq = distanceX * distanceX + distanceY * distanceY;
            if (!(distanceSq < closestDistanceSq)) continue;
            closestDistanceSq = distanceSq;
            bestVelocityData = possibleNextVelocity;
            nextState.Copy(possibleNextState);
        }
        return bestVelocityData;
    }

    public static void DebugDraw(Graphics2D gfx, IRobot robot) {
        if (_debug.size() < 2) {
            _debug.add(MoveToCalculator.PredictRouteToXY(robot.getBattleFieldWidth() * 0.5, robot.getBattleFieldHeight() * 0.5, 1.8 * (double)_debug.size(), 8.0, 0.0, 0.0));
        }
        gfx.setColor(Color.white);
        for (int index = 0; index < _debug.size(); ++index) {
            ArrayList<PredictedPosition> positions = _debug.get(index);
            for (int posIndex = 0; posIndex < positions.size(); ++posIndex) {
                PredictedPosition pos = positions.get(posIndex);
                gfx.drawRect((int)pos.X, (int)pos.Y, 1, 1);
            }
        }
    }
}

