/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.inversion;

import org.la4j.LinearAlgebra;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.inversion.MatrixInverter;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.vector.DenseVector;

public class GaussJordanInverter
implements MatrixInverter {
    private final Matrix matrix;

    public GaussJordanInverter(Matrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public Matrix inverse() {
        if (this.matrix.rows() != this.matrix.columns()) {
            throw new IllegalArgumentException("Wrong matrix size: rows != columns");
        }
        Matrix result = this.matrix.blankOfShape(this.matrix.rows(), this.matrix.columns());
        for (int i = 0; i < this.matrix.rows(); ++i) {
            DenseVector b = DenseVector.zero(this.matrix.rows());
            b.set(i, 1.0);
            try {
                LinearSystemSolver solver = this.matrix.withSolver(LinearAlgebra.GAUSSIAN);
                Vector x = solver.solve(b);
                result.setColumn(i, x);
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("This matrix is not invertible.");
            }
        }
        return result;
    }

    @Override
    public Matrix self() {
        return this.matrix;
    }
}

