/*
 * Decompiled with CFR 0.152.
 */
package rdm.state;

import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import robocode.Rules;
import robocode.util.Utils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J;\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J%\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020!\u00a2\u0006\u0002\u0010%J\t\u0010&\u001a\u00020!H\u00d6\u0001J\u0016\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\tJ\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lrdm/state/Wave;", "", "start", "Ljava/awt/geom/Point2D;", "bearingRadians", "", "power", "direction", "time", "", "(Ljava/awt/geom/Point2D;DDDJ)V", "getBearingRadians", "()D", "bulletSpeed", "getBulletSpeed", "getDirection", "maxEscapeAngle", "getMaxEscapeAngle", "getPower", "getStart", "()Ljava/awt/geom/Point2D;", "getTime", "()J", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "getHitSegmentIndex", "", "enemy", "currentTime", "segmentsCount", "(Ljava/awt/geom/Point2D;JI)Ljava/lang/Integer;", "hashCode", "isOutOfWorld", "worldMaxSize", "toString", "", "Commons"})
public final class Wave {
    @NotNull
    private final Point2D start;
    private final double bearingRadians;
    private final double power;
    private final double direction;
    private final long time;

    private final double getBulletSpeed() {
        return Rules.getBulletSpeed((double)this.power);
    }

    private final double getMaxEscapeAngle() {
        return Math.toRadians(60.0);
    }

    @Nullable
    public final Integer getHitSegmentIndex(@NotNull Point2D enemy, long currentTime, int segmentsCount) {
        Intrinsics.checkParameterIsNotNull(enemy, "enemy");
        long timeInFly = currentTime - this.time;
        if (Point2D.distance(this.start.getX(), this.start.getY(), enemy.getX(), enemy.getY()) <= (double)timeInFly * this.getBulletSpeed()) {
            double desiredDirection = Math.atan2(enemy.getX() - this.start.getX(), enemy.getY() - this.start.getY());
            double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.bearingRadians));
            double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / this.getMaxEscapeAngle())) * this.direction;
            return (int)Math.round(((double)segmentsCount - 1.0) / (double)2 * (guessFactor + 1.0));
        }
        return null;
    }

    public final boolean isOutOfWorld(double worldMaxSize, long currentTime) {
        long timeInFly = currentTime - this.time;
        return worldMaxSize < this.getBulletSpeed() * (double)timeInFly;
    }

    @NotNull
    public final Point2D getStart() {
        return this.start;
    }

    public final double getBearingRadians() {
        return this.bearingRadians;
    }

    public final double getPower() {
        return this.power;
    }

    public final double getDirection() {
        return this.direction;
    }

    public final long getTime() {
        return this.time;
    }

    public Wave(@NotNull Point2D start, double bearingRadians, double power, double direction, long time) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        this.start = start;
        this.bearingRadians = bearingRadians;
        this.power = power;
        this.direction = direction;
        this.time = time;
    }

    @NotNull
    public final Point2D component1() {
        return this.start;
    }

    public final double component2() {
        return this.bearingRadians;
    }

    public final double component3() {
        return this.power;
    }

    public final double component4() {
        return this.direction;
    }

    public final long component5() {
        return this.time;
    }

    @NotNull
    public final Wave copy(@NotNull Point2D start, double bearingRadians, double power, double direction, long time) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        return new Wave(start, bearingRadians, power, direction, time);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Wave copy$default(Wave wave, Point2D point2D, double d, double d2, double d3, long l, int n, Object object) {
        if ((n & 1) != 0) {
            point2D = wave.start;
        }
        if ((n & 2) != 0) {
            d = wave.bearingRadians;
        }
        if ((n & 4) != 0) {
            d2 = wave.power;
        }
        if ((n & 8) != 0) {
            d3 = wave.direction;
        }
        if ((n & 0x10) != 0) {
            l = wave.time;
        }
        return wave.copy(point2D, d, d2, d3, l);
    }

    public String toString() {
        return "Wave(start=" + this.start + ", bearingRadians=" + this.bearingRadians + ", power=" + this.power + ", direction=" + this.direction + ", time=" + this.time + ")";
    }

    public int hashCode() {
        Point2D point2D = this.start;
        return ((((point2D != null ? ((Object)point2D).hashCode() : 0) * 31 + Double.hashCode(this.bearingRadians)) * 31 + Double.hashCode(this.power)) * 31 + Double.hashCode(this.direction)) * 31 + Long.hashCode(this.time);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Wave)) break block3;
                Wave wave = (Wave)object;
                if (!Intrinsics.areEqual(this.start, wave.start) || Double.compare(this.bearingRadians, wave.bearingRadians) != 0 || Double.compare(this.power, wave.power) != 0 || Double.compare(this.direction, wave.direction) != 0 || !(this.time == wave.time)) break block3;
            }
            return true;
        }
        return false;
    }
}

