/*
 * Decompiled with CFR 0.152.
 */
package kenran;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kenran.defense.ShieldDash;
import kenran.offense.WarAxe;
import kenran.sight.HeroicGaze;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Bakko
extends AdvancedRobot {
    private static final double RADAR_LOCK_MULTIPLIER = 2.0;
    private static Rectangle2D.Double _fieldRect = null;
    private final Point2D.Double _enemyPosition = new Point2D.Double();
    private final Point2D.Double _position = new Point2D.Double();
    private HeroicGaze _heroicGaze;
    private ShieldDash _shieldDash;
    private WarAxe _warAxe;
    private boolean _hasWon = false;

    public void run() {
        this.setScanColor(new Color(0, 200, 0));
        this.setBodyColor(new Color(150, 50, 0));
        this.setRadarColor(new Color(30, 90, 30));
        this.setGunColor(Color.DARK_GRAY);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this._heroicGaze = new HeroicGaze(this, 2.0);
        this._shieldDash = new ShieldDash(this);
        this._warAxe = new WarAxe(this);
        if (_fieldRect == null) {
            _fieldRect = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        }
        while (true) {
            this._heroicGaze.lookForEscapedEnemy();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this._position.setLocation(this.getX(), this.getY());
        this._heroicGaze.onScannedRobot(e);
        this._warAxe.onScannedRobot(e);
        this._shieldDash.onScannedRobot(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this._shieldDash.onHitByBullet(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this._shieldDash.onBulletHitBullet(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this._shieldDash.onBulletHit(e);
    }

    public void onWin(WinEvent event) {
        this._hasWon = true;
    }

    public void onPaint(Graphics2D g) {
        this._shieldDash.onPaint(g);
    }

    public Point2D.Double getPosition() {
        return this._position;
    }

    public Point2D.Double getEnemyPosition() {
        return this._enemyPosition;
    }

    public void setEnemyPosition(Point2D.Double position) {
        this._enemyPosition.setLocation(position);
    }

    public Rectangle2D.Double getBattleField() {
        return _fieldRect;
    }

    public boolean hasWon() {
        return this._hasWon;
    }
}

