/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.WaveBullet;
import gre.svman4.useful.FieldPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class EnemyWaveBullet
extends WaveBullet {
    private Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = (range - value) / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    public double[] getEnemyCurrentStatus() {
        return this.enemy.getEnemyGunCurrentStatus(Math.abs(this.mineRobotVelocity), Math.abs(this.directAngle), this.distanceToEnemyPosition);
    }

    double getshootingAngle(int OffsetBin) {
        double factor = (2.0 * (double)OffsetBin - 47.0 - 1.0) / 46.0;
        double offsetAngle = factor * this.enemy.getMaxEscapeAngle(this.bulletVelocity * (double)this.lateralDirection);
        double shootingAngle = offsetAngle + this.directAngle;
        return shootingAngle;
    }

    private Stroke getStroke(double min, double d, double max) {
        double range = max - min;
        double val = d - min;
        return new BasicStroke((float)(val / range) * 5.0f);
    }

    public void logHit(FieldPoint hitPoint) {
        this.enemy.logHit(Math.abs(this.mineRobotVelocity), this.distanceToEnemyPosition, this.getFactorIndex(hitPoint));
    }

    public void onPaint(Graphics2D g) {
        double[] curStats = this.getEnemyCurrentStatus();
        g.setStroke(new BasicStroke());
        g.setColor(Color.DARK_GRAY);
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        for (int j = 0; j < 47; ++j) {
            if (curStats[j] < min) {
                min = curStats[j];
                continue;
            }
            if (!(curStats[j] > max)) continue;
            max = curStats[j];
        }
        FieldPoint temp1 = new FieldPoint();
        temp1.setLocation(this.fireLocation.project(this.distanceTraveled - 2.0 * this.bulletVelocity, this.getshootingAngle(0)));
        FieldPoint temp0 = this.fireLocation.project(this.distanceTraveled, this.directAngle);
        g.drawLine((int)this.fireLocation.x, (int)this.fireLocation.y, (int)temp0.x, (int)temp0.y);
        for (int j = 1; j < 47; ++j) {
            temp0.setLocation(temp1);
            temp1.setLocation(this.fireLocation.project(this.distanceTraveled - 2.0 * this.bulletVelocity, this.getshootingAngle(j)));
            g.setStroke(this.getStroke(min, curStats[j], max));
            g.setColor(this.getColor(min, curStats[j], max));
            g.drawLine((int)temp0.x, (int)temp0.y, (int)temp1.x, (int)temp1.y);
            g.fillOval((int)temp1.x - 1, (int)temp1.y - 1, 2, 2);
        }
    }
}

