/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.useful;

public class Buffer {
    private final double[] buffer;
    private int last;

    public Buffer(int size) {
        this.buffer = new double[size];
        this.last = 0;
    }

    public double getBeforeLastValue() {
        if (this.last == 0) {
            return this.buffer[this.buffer.length - 1];
        }
        return this.buffer[this.last];
    }

    public double getLastValue() {
        return this.buffer[this.last];
    }

    public double getValue(int pos) {
        if (pos >= 0 && pos < this.buffer.length) {
            return this.buffer[pos];
        }
        return 0.0;
    }

    public void insertValue(double value) {
        ++this.last;
        if (this.last >= this.buffer.length) {
            this.last = 0;
        }
        this.buffer[this.last] = value;
    }

    public String toString() {
        StringBuilder text = new StringBuilder(this.buffer.length * 4 + 150);
        text.append("BUFFER[").append(this.buffer.length).append("] ");
        text.append(this.last).append(" ");
        for (int i = 0; i < this.buffer.length; ++i) {
            text.append(this.buffer[i]).append(" ");
        }
        return text.toString();
    }
}

