/*
 * Decompiled with CFR 0.152.
 */
package josago;

import java.util.ArrayList;
import java.util.HashMap;
import josago.InfoBala;
import josago.InfoRobot;
import josago.Utilidades;
import robocode.Rules;

public class GestorMovimiento {
    public static final int MOVIMIENTO_PUNTOS_NUMERO = 50;
    public static final int MOVIMIENTO_PUNTOS_MAX_DISTANCIA = 100;
    public static final double MOVIMIENTO_UMBRAL_ENEMIGOS = 300.0;
    public static final double MOVIMIENTO_UMBRAL_CENTRO = 300.0;
    public static final double MOVIMIENTO_UMBRAL_PAREDES = 50.0;
    public static final double MOVIMIENTO_UMBRAL_BALAS = 300.0;
    public static final double MOVIMIENTO_FACTOR_MAS_CERCANO = 2.5;
    public static final double MOVIMIENTO_FACTOR_ENEMIGOS = 2.0;
    public static final double MOVIMIENTO_FACTOR_CENTRO = 2.0;
    public static final double MOVIMIENTO_FACTOR_PAREDES = 5.0;
    public static final double MOVIMIENTO_FACTOR_MOVIMIENTO = 1.0;
    public static final double MOVIMIENTO_FACTOR_BALAS = 2.0;

    public static double riesgoPunto(double[] punto, double mi_x, double mi_y, ArrayList<InfoBala> balas_enemigas, HashMap enemigos, long tiempo, double ancho_pantalla, double alto_pantalla) {
        double distancia_centro;
        Object[] vector_enemigos = enemigos.values().toArray();
        double puntuacion = 0.0;
        boolean soyElMasCercanoAAlguien = false;
        double distancia_minima_enemigo = Double.POSITIVE_INFINITY;
        for (int i = 0; i < vector_enemigos.length; ++i) {
            InfoRobot enemigo_i = (InfoRobot)vector_enemigos[i];
            double distancia_minima = Double.POSITIVE_INFINITY;
            for (int j = 0; j < vector_enemigos.length; ++j) {
                double distancia;
                InfoRobot enemigo_j = (InfoRobot)vector_enemigos[j];
                if (enemigo_i == enemigo_j || !((distancia = Utilidades.distancia(enemigo_i.datos[0].x, enemigo_i.datos[0].y, enemigo_j.datos[0].x, enemigo_j.datos[0].y)) < distancia_minima)) continue;
                distancia_minima = distancia;
            }
            double distancia_punto = Utilidades.distancia(enemigo_i.datos[0].x, enemigo_i.datos[0].y, punto[0], punto[1]);
            if (distancia_punto < distancia_minima) {
                soyElMasCercanoAAlguien = true;
                break;
            }
            if (!(distancia_punto < distancia_minima_enemigo)) continue;
            distancia_minima_enemigo = distancia_punto;
        }
        if (soyElMasCercanoAAlguien) {
            puntuacion += 2.5;
        }
        if (distancia_minima_enemigo < 300.0) {
            puntuacion += (1.0 - distancia_minima_enemigo / 300.0) * 2.0;
        }
        if ((distancia_centro = Utilidades.distancia(ancho_pantalla / 2.0, alto_pantalla / 2.0, punto[0], punto[1])) < 300.0 && vector_enemigos.length > 1) {
            puntuacion += 1.0 - distancia_centro * 2.0 / 300.0;
        }
        if (punto[0] < 50.0 || punto[1] < 50.0) {
            puntuacion += 5.0;
        } else if (punto[0] + 50.0 > ancho_pantalla || punto[1] + 50.0 > alto_pantalla) {
            puntuacion += 5.0;
        }
        double distancia_punto = Utilidades.distancia(mi_x, mi_y, punto[0], punto[1]);
        puntuacion += 1.0 - distancia_punto * 1.0 / 100.0;
        for (InfoBala bala : balas_enemigas) {
            for (int a = 0; a < bala.angulos_lanzamiento.length; ++a) {
                double y_bala;
                if (bala.angulos_lanzamiento[a] == null) continue;
                double tiempo_vuelo = (double)(tiempo - bala.t_lanzamiento + 1L) + Utilidades.distancia(mi_x, mi_y, punto[0], punto[1]) / 8.0;
                double x_bala = bala.x_lanzamiento + Math.sin(bala.angulos_lanzamiento[a]) * Rules.getBulletSpeed((double)bala.potencia) * tiempo_vuelo;
                double distancia_bala = Utilidades.distancia(x_bala, y_bala = bala.y_lanzamiento + Math.cos(bala.angulos_lanzamiento[a]) * Rules.getBulletSpeed((double)bala.potencia) * tiempo_vuelo, punto[0], punto[1]);
                if (!(distancia_bala < 300.0)) continue;
                puntuacion += 1.0 - distancia_bala * 2.0 / 300.0;
            }
        }
        return puntuacion;
    }

    public static double[] movimientoMenorRiesgo(double mi_x, double mi_y, ArrayList<InfoBala> balas_enemigas, HashMap enemigos, long tiempo, double ancho_pantalla, double alto_pantalla) {
        double[] mejorPunto = null;
        double mejorPuntuacion = Double.POSITIVE_INFINITY;
        boolean puntos_procesados = false;
        for (int p = 0; p < 50; ++p) {
            double angulo = Math.random() * 2.0 * Math.PI;
            double distancia = Math.random() * 100.0;
            double[] punto_posible = new double[]{mi_x + Math.sin(angulo) * distancia, mi_y + Math.cos(angulo) * distancia};
            double puntuacion = GestorMovimiento.riesgoPunto(punto_posible = Utilidades.normalizarCoordenadas(punto_posible, ancho_pantalla, alto_pantalla), mi_x, mi_y, balas_enemigas, enemigos, tiempo, ancho_pantalla, alto_pantalla);
            if (!(puntuacion < mejorPuntuacion)) continue;
            mejorPunto = punto_posible;
            mejorPuntuacion = puntuacion;
        }
        return mejorPunto;
    }
}

