/*
 * Decompiled with CFR 0.152.
 */
package eem.bullets;

import eem.EvBot;
import eem.bullets.firedBullet;
import eem.bullets.wave;
import eem.gun.baseGun;
import eem.gun.shadowGun;
import eem.misc.logger;
import eem.target.InfoBot;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.Bullet;

public class bulletsManager {
    public EvBot myBot;
    public LinkedList<wave> myWaves = new LinkedList();
    public LinkedList<wave> enemyWaves = new LinkedList();
    private int numBotsForWaveToIntersect = 2;

    public bulletsManager() {
    }

    public bulletsManager(EvBot evBot) {
        this.myBot = evBot;
    }

    public void initTic() {
        this.removeInactiveBulletsAndEmptyWaves();
        this.createShadowsFromOtherBots();
        for (wave wave2 : this.myWaves) {
            wave2.initTic();
        }
        for (wave wave2 : this.enemyWaves) {
            wave2.initTic();
        }
    }

    public void createShadowsFromOtherBots() {
        long l = this.myBot.ticTime;
        for (wave wave2 : this.enemyWaves) {
            Point2D.Double double_ = wave2.getFiringPosition();
            double d = wave2.getDistanceTraveledAtTime(l);
            for (InfoBot infoBot : this.myBot._botsmanager.listOfAliveBots()) {
                firedBullet firedBullet22;
                Point2D.Double double_2 = infoBot.getPosition();
                if (!(Math.abs(d - double_.distance(double_2)) <= (double)this.myBot.robotHalfSize)) continue;
                LinkedList<firedBullet> linkedList = new LinkedList<firedBullet>();
                for (firedBullet firedBullet22 : wave2.getBullets()) {
                    if (firedBullet22.getFiredGun().getName().equals("shadow")) continue;
                    Point2D.Double double_3 = firedBullet22.getPosition();
                    if (!(Math.abs(double_3.x - double_2.x) <= (double)this.myBot.robotHalfSize) || !(Math.abs(double_3.y - double_2.y) <= (double)this.myBot.robotHalfSize)) continue;
                    linkedList.add(firedBullet22);
                }
                for (firedBullet firedBullet22 : linkedList) {
                    wave2.removeBullet(firedBullet22);
                }
                if (!wave2.isPosWithMEAforBot(double_2, EvBot._tracker)) continue;
                shadowGun shadowGun2 = new shadowGun();
                firedBullet22 = new firedBullet(this.myBot, wave2, (baseGun)shadowGun2, double_2);
                wave2.addBullet(firedBullet22);
            }
        }
    }

    public void createShadowsFromMyBullets() {
        long l = this.myBot.ticTime;
        for (wave wave2 : this.myWaves) {
            firedBullet firedBullet2 = wave2.bullets.getFirst();
            Point2D.Double double_ = firedBullet2.getPositionAtTime(l - 1L);
            Point2D.Double double_2 = firedBullet2.getPositionAtTime(l);
            for (wave wave3 : this.enemyWaves) {
                double d = wave3.getDistanceTraveledAtTime(l);
                double d2 = wave3.getDistanceTraveledAtTime(l - 1L);
                Point2D.Double double_3 = wave3.getFiringPosition();
                if (!(double_3.distance(double_) > d2) || !(double_3.distance(double_2) <= d)) continue;
                Point2D.Double double_4 = new Point2D.Double(0.0, 0.0);
                double_4.x = (double_2.x + double_.x) / 2.0;
                double_4.y = (double_2.y + double_.y) / 2.0;
                shadowGun shadowGun2 = new shadowGun();
                firedBullet firedBullet3 = new firedBullet(this.myBot, wave3, (baseGun)shadowGun2, double_4);
                wave3.addBullet(firedBullet3);
            }
        }
    }

    public void removeInactiveBulletsAndEmptyWaves() {
        this.removeWavesBehindMe();
        this.removeMyWavesBehindEnemies();
        this.removeInactiveBullets();
    }

    public void add_enemy_wave(InfoBot infoBot) {
        baseGun baseGun2 = new baseGun(this.myBot);
        wave wave2 = new wave(this.myBot, infoBot, infoBot.energyDrop());
        this.enemyWaves.add(wave2);
    }

    public void add(firedBullet firedBullet2) {
        ++EvBot.bulletFiredCnt;
        wave wave2 = new wave(this.myBot, firedBullet2);
        this.myWaves.add(wave2);
    }

    public void removeEmptyWavesFromList(LinkedList<wave> linkedList) {
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            if (((wave)listIterator.next()).bullets.size() != 0) continue;
            listIterator.remove();
        }
    }

    public void removeEmptyWaves() {
        this.removeEmptyWavesFromList(this.enemyWaves);
        this.removeEmptyWavesFromList(this.myWaves);
    }

    public void removeInactiveBulletsFromWaveList(LinkedList<wave> linkedList) {
        for (wave wave2 : linkedList) {
            wave2.removeInactiveBullets();
        }
    }

    public void removeInactiveBullets() {
        this.removeInactiveBulletsFromWaveList(this.enemyWaves);
        this.removeInactiveBulletsFromWaveList(this.myWaves);
    }

    public void removeMyWavesBehindEnemies() {
        ListIterator listIterator = this.myWaves.listIterator();
        block0: while (listIterator.hasNext()) {
            wave wave2 = (wave)listIterator.next();
            double d = wave2.getDistanceTraveled();
            int n = 0;
            for (InfoBot infoBot : this.myBot._botsmanager.listOfAliveBots()) {
                double d2 = wave2.getFiringPosition().distance(infoBot.getPosition());
                if (d2 + (double)(2 * this.myBot.robotHalfSize) < d) {
                    ++n;
                }
                if (n != this.myBot.getOthers() && n < this.numBotsForWaveToIntersect) continue;
                listIterator.remove();
                continue block0;
            }
        }
    }

    public void removeWavesBehindMe() {
        ListIterator listIterator = this.enemyWaves.listIterator();
        while (listIterator.hasNext()) {
            wave wave2 = (wave)listIterator.next();
            double d = wave2.getDistanceTraveled();
            double d2 = wave2.getFiringPosition().distance(this.myBot.myCoord);
            if (!(d2 + (double)(2 * this.myBot.robotHalfSize) < d)) continue;
            listIterator.remove();
        }
    }

    public wave getClosestToMeWave() {
        wave wave2 = null;
        ListIterator listIterator = this.enemyWaves.listIterator();
        double d = 1000000.0;
        while (listIterator.hasNext()) {
            wave wave3 = (wave)listIterator.next();
            double d2 = wave3.distance(this.myBot.myCoord);
            if (!(d2 < d) || !(d2 + (double)this.myBot.robotHalfSize > 0.0)) continue;
            wave2 = wave3;
            d = d2;
        }
        return wave2;
    }

    public double getClosestToMeWaveDist() {
        wave wave2 = this.getClosestToMeWave();
        double d = 1000000.0;
        if (wave2 == null) {
            return d;
        }
        d = wave2.distance(this.myBot.myCoord);
        return d;
    }

    public double getClosestToMeWaveTimeArrival() {
        wave wave2 = this.getClosestToMeWave();
        double d = 1000000.0;
        if (wave2 == null) {
            return d;
        }
        d = wave2.distance(this.myBot.myCoord) / wave2.getSpeed();
        return d;
    }

    public LinkedList<firedBullet> getAllEnemyBullets() {
        LinkedList<firedBullet> linkedList = new LinkedList<firedBullet>();
        for (wave wave2 : this.enemyWaves) {
            linkedList.addAll(wave2.bullets);
        }
        return linkedList;
    }

    public LinkedList<firedBullet> getAllMyBullets() {
        LinkedList<firedBullet> linkedList = new LinkedList<firedBullet>();
        for (wave wave2 : this.myWaves) {
            linkedList.addAll(wave2.bullets);
        }
        return linkedList;
    }

    public LinkedList<wave> getAllEnemyWaves() {
        return this.enemyWaves;
    }

    public LinkedList<baseGun> whichOfMyGunsFiredBullet(Bullet bullet) {
        LinkedList<baseGun> linkedList = new LinkedList<baseGun>();
        LinkedList<firedBullet> linkedList2 = this.getAllMyBullets();
        ListIterator listIterator = linkedList2.listIterator();
        baseGun baseGun2 = null;
        double d = bullet.getX();
        double d2 = bullet.getY();
        while (listIterator.hasNext()) {
            firedBullet firedBullet2 = (firedBullet)listIterator.next();
            if (!firedBullet2.isItMine()) continue;
            Point2D.Double double_ = (Point2D.Double)firedBullet2.getPosition().clone();
            double d3 = Math.abs(d - double_.x);
            double d4 = Math.abs(d2 - double_.y);
            if (!(d3 <= (double)this.myBot.robotHalfSize) || !(d4 <= (double)this.myBot.robotHalfSize)) continue;
            baseGun2 = firedBullet2.firedGun;
            linkedList.add(baseGun2);
            logger.noise("This bullet was fired by gun = " + baseGun2.getName());
        }
        return linkedList;
    }

    public void onPaint(Graphics2D graphics2D) {
        for (wave wave2 : this.enemyWaves) {
            wave2.onPaint(graphics2D);
        }
        for (wave wave2 : this.myWaves) {
            wave2.onPaint(graphics2D);
        }
    }
}

