/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import pa3k.Aiming;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.CircleMoving;
import pa3k.Configuration;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.OpponentCreator;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.SelfTracking;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Tracking
extends RobotModule {
    protected Map<String, Opponent> opponents;
    protected SelfTracking selfTracking;
    protected Aiming selfAiming;
    protected Deque<BulletTracking> trackedBullets;
    protected Deque<BulletTracking> ownBullets;
    private Opponent scanningTarget;
    protected Opponent lastHitBy;
    private CircleMoving moving;
    protected OpponentCreator opponentCreator;
    private Configuration aimingConfiguration;
    private Configuration evasiveConfiguration;

    public Tracking(AdvancedRobot robot, SelfTracking selfTracking, OpponentCreator oc) {
        super(robot);
        this.selfTracking = selfTracking;
        this.opponents = new TreeMap<String, Opponent>();
        this.trackedBullets = new LinkedList<BulletTracking>();
        this.ownBullets = new LinkedList<BulletTracking>();
        this.opponentCreator = oc;
        this.lastHitBy = null;
        this.aimingConfiguration = null;
        this.evasiveConfiguration = null;
    }

    @Override
    public void init() {
    }

    protected void turnBulletTracking() {
        long eta;
        BulletTracking b = this.trackedBullets.peekFirst();
        if (b != null) {
            long currentTime = this.robot.getTime();
            eta = b.getETA(new Position((Robot)this.robot)) - 1L;
            if (eta <= currentTime) {
                b.setEvaded();
            }
            if (eta < currentTime - 3L) {
                Log.log(3, "Opponent " + b.getOwner() + " missed from " + b.getSource());
                this.trackedBullets.removeFirst();
                b.getOwner().bulletMissedMe(b);
                BulletTracking possibleHit = b.clone();
                try {
                    possibleHit.setFiringAngle(possibleHit.getSource().getDirectionTo(this.selfTracking.getLastPosition((int)(this.robot.getTime() - eta))));
                    possibleHit.getOwner().bulletPossibleHitMe(possibleHit);
                    Log.log(3, "  the correct aiming ration was: " + 100.0 * possibleHit.getAimingRatio() + "%");
                    Log.paintArc(3, b.getSource(), b.getNegativeAngle(), AngleUtils.difference(b.getPositiveAngle(), b.getNegativeAngle()), 200.0, new Color(255, 100, 100, 30), 0);
                    Log.paintLine(3, possibleHit.getSource(), possibleHit.getFiringAngle(), new Color(255, 0, 0), 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        long now = this.robot.getTime();
        b = this.ownBullets.peekFirst();
        if (b != null && (eta = b.getETA(b.getTargetOpponent().getLastPosition()) - 1L) < now - 3L) {
            Position p = null;
            try {
                p = b.getTargetOpponent().getLastPosition(now - (now - eta));
            }
            catch (Exception exception) {
                // empty catch block
            }
            BulletTracking possibleHit = b.clone();
            possibleHit.setFiringAngle(b.getSource().getDirectionTo(p));
            double correctAimingRation = possibleHit.getAimingRatio();
            try {
                Log.log(3, "We missed " + b.getTargetOpponent() + " at angle " + b.getAimingRatio() + ", target was at " + correctAimingRation);
                Log.paintArc(3, b.getSource(), b.getNegativeAngle(), AngleUtils.difference(b.getPositiveAngle(), b.getNegativeAngle()), 200.0, new Color(255, 255, 255, 30), 0);
                Log.paintLine(3, b.getSource(), b.getFiringAngle(), new Color(0, 0, 0), 0);
                Log.paintLine(3, possibleHit.getSource(), possibleHit.getFiringAngle(), new Color(255, 255, 255), 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.ownBullets.removeFirst();
            b.getTargetOpponent().bulletPossibleHit(possibleHit);
            b.getTargetOpponent().bulletMiss(b);
        }
        Iterator<BulletTracking> i = this.ownBullets.iterator();
        while (i.hasNext()) {
            i.next().paint(3, now + 1L);
        }
        i = this.trackedBullets.iterator();
        while (i.hasNext()) {
            i.next().paint(3, now + 1L);
        }
    }

    @Override
    public void turn() {
        if (this.scanningTarget != null) {
            if (this.scanningTarget.lastSeen(this.robot.getTime()) > 3L) {
                this.scanningTarget = null;
            } else {
                Position myPos = new Position((Robot)this.robot);
                double t = 0.0;
                t = myPos.getDirectionTo(this.scanningTarget.getLastPosition());
                double current = this.robot.getRadarHeadingRadians();
                if ((t = Utils.normalRelativeAngle((double)(t - current))) > 0.0) {
                    this.robot.setTurnRadarRightRadians(1.5707963267948966);
                } else {
                    this.robot.setTurnRadarLeftRadians(1.5707963267948966);
                }
            }
        }
        if (this.scanningTarget == null) {
            this.robot.setTurnRadarRightRadians(1.5707963267948966);
        }
        this.turnBulletTracking();
    }

    public void bulletFired(BulletTracking bt, Opponent target) {
        this.ownBullets.add(bt);
        if (this.aimingConfiguration != null) {
            this.aimingConfiguration.shot();
        }
    }

    public Opponent getByName(String name) {
        Log.log(4, "Looking up: '" + name + "'");
        Opponent o = this.opponents.get(name);
        if (o == null) {
            o = this.opponentCreator.createOpponent(name, this.robot);
            this.opponents.put(name, o);
        }
        return o;
    }

    public void opponentScanned(ScannedRobotEvent e) {
        BulletTracking bullet;
        Opponent o = this.getByName(e.getName());
        if (this.lastHitBy == null) {
            this.lastHitBy = o;
        }
        if ((bullet = o.updateInfo(e, e.getBearingRadians() + this.robot.getHeadingRadians(), new Position((Robot)this.robot))) != null) {
            Log.log(3, "Energy drop detected at " + o + ": " + bullet.getEnergy());
            if (this.evasiveConfiguration != null) {
                this.evasiveConfiguration.shot();
            }
            try {
                bullet.setValues(o.getLastPosition(this.robot.getTime() - 2L), this.selfTracking, o);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.trackedBullets.add(bullet);
        }
    }

    public void hitByBullet(HitByBulletEvent e) {
        Opponent o;
        this.lastHitBy = o = this.getByName(e.getName());
        long now = this.robot.getTime();
        for (BulletTracking b : this.trackedBullets) {
            long eta = b.getETA(new Position(e.getBullet()));
            Log.log(3, "Checking against bullet: " + b);
            Log.log(3, "Computed ETA: " + eta + ", actual time: " + e.getTime());
            if (b.getOwner() != o || (int)((b.getEnergy() + 0.005) * 100.0) != (int)((e.getPower() + 0.005) * 100.0) || eta < now - 3L || eta > now + 3L) continue;
            try {
                b.setFiringAngle(b.getSource().getDirectionTo(this.selfTracking.getLastPosition(1)));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            Log.log(2, "Hit by bullet from " + o + " fired at " + b.getTime() + " at " + b.getSource());
            Log.log(3, "Random hit probability " + (int)(b.getRandomHitProbability() * 100.0) + "%, aiming ratio " + (int)(b.getAimingRatio() * 100.0) + "%");
            Log.paintArc(3, b.getSource(), b.getNegativeAngle(), AngleUtils.difference(b.getPositiveAngle(), b.getNegativeAngle()), 200.0, new Color(255, 100, 100, 30), 0);
            Log.paintLine(3, b.getSource(), b.getFiringAngle(), new Color(255, 0, 0), 0);
            this.trackedBullets.remove(b);
            o.bulletHitMe(b);
            this.moving.bulletHitMe(b);
            return;
        }
        Log.log(2, "Hit by unidentified bullet");
    }

    public Object[] getTargets() {
        return this.opponents.values().toArray();
    }

    public void setOpponentOfInterest(Opponent target) {
        this.scanningTarget = target;
    }

    public void bulletHitBullet(BulletHitBulletEvent e) {
        Bullet other = e.getHitBullet();
        BulletTracking myBT = BulletTracking.remove(this.ownBullets, e.getBullet());
        try {
            if (myBT.getSource().distance(other.getX(), other.getY()) > myBT.getSource().distance(myBT.getTargetOpponent().getLastPosition(this.robot.getTime()))) {
                myBT.getTargetOpponent().bulletMiss(myBT);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Opponent o = this.getByName(other.getName());
        for (BulletTracking b : this.trackedBullets) {
            long eta = b.getETA(new Position(other.getX(), other.getY()));
            if (b.getOwner() != o || b.getEnergy() != other.getPower() || eta < e.getTime() - 2L || eta > e.getTime() + 2L) continue;
            Log.log(2, "Bullet shot down by " + o + " fired at " + b.getTime() + " at " + b.getSource());
            Log.log(3, "Random hit probability " + (int)(b.getRandomHitProbability() * 100.0) + "%");
            this.trackedBullets.remove(b);
            return;
        }
    }

    public void bulletMissed(BulletMissedEvent e) {
    }

    public void bulletHit(BulletHitEvent e) {
        Bullet b = e.getBullet();
        Opponent o = this.getByName(b.getVictim());
        BulletTracking bt = BulletTracking.remove(this.ownBullets, b);
        if (bt != null) {
            try {
                bt.setFiringAngle(bt.getSource().getDirectionTo(bt.getTargetOpponent().getLastPosition(this.robot.getTime() - 1L)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.paintArc(3, bt.getSource(), bt.getNegativeAngle(), AngleUtils.difference(bt.getPositiveAngle(), bt.getNegativeAngle()), 200.0, new Color(255, 255, 255, 30), 0);
            Log.paintLine(3, bt.getSource(), bt.getFiringAngle(), new Color(255, 255, 255), 0);
            o.bulletHit(bt);
            if (o != bt.getTargetOpponent()) {
                try {
                    if (bt.getTargetOpponent().getLastPosition(this.robot.getTime()).distance(bt.getSource()) < o.getLastPosition(this.robot.getTime()).distance(bt.getSource())) {
                        bt.getTargetOpponent().bulletMiss(bt);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            Log.log(2, "Bullet hit with no tracking");
        }
    }

    public void robotDeath(RobotDeathEvent e) {
        Opponent o = this.getByName(e.getName());
        if (this.scanningTarget == o) {
            this.scanningTarget = null;
        }
        o.death();
        this.opponents.remove(e.getName());
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    public Deque<BulletTracking> getTrackedBullets() {
        return this.trackedBullets;
    }

    public BulletTracking getClosestBullet() {
        Position myPos = new Position((Robot)this.robot);
        Iterator<BulletTracking> i = this.trackedBullets.iterator();
        BulletTracking nearestBullet = null;
        while (i.hasNext()) {
            BulletTracking bt = i.next();
            if (bt.getEvaded() || nearestBullet != null && nearestBullet.getOwner() == bt.getOwner()) continue;
            long eta = bt.getETA(myPos);
            if (nearestBullet != null && (nearestBullet.getETA(myPos) <= eta || eta >= this.robot.getTime())) continue;
            nearestBullet = bt;
        }
        return nearestBullet;
    }

    public BulletTracking getClosestBullet(Opponent fromOpponent) {
        Iterator<BulletTracking> i = this.trackedBullets.iterator();
        BulletTracking nearestBullet = null;
        while (i.hasNext()) {
            BulletTracking bt = i.next();
            if (bt.getOwner() != fromOpponent) continue;
            nearestBullet = bt;
            break;
        }
        return nearestBullet;
    }

    public Opponent getLastHitBy() {
        return this.lastHitBy;
    }

    public void setMoving(CircleMoving moving) {
        this.moving = moving;
    }

    public void setAimingConfiguration(Configuration a) {
        this.aimingConfiguration = a;
    }

    public void setEvasiveConfiguration(Configuration e) {
        this.evasiveConfiguration = e;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.getByName(e.getName()).giveSolicitedEnergyLost(e.getEnergy());
    }
}

