/*
 * Decompiled with CFR 0.152.
 */
package kawam;

import kawam.Coordinate;
import kawam.Intercept;

public class CircularIntercept
extends Intercept {
    protected Coordinate getEstimatedPosition(double time) {
        if (Math.abs(this.angularVelocity_rad_per_sec) <= Math.toRadians(0.1)) {
            return super.getEstimatedPosition(time);
        }
        double initialTargetHeading = Math.toRadians(this.targetHeading);
        double finalTargetHeading = initialTargetHeading + this.angularVelocity_rad_per_sec * time;
        double x = this.targetStartingPoint.x - this.targetVelocity / this.angularVelocity_rad_per_sec * (Math.cos(finalTargetHeading) - Math.cos(initialTargetHeading));
        double y = this.targetStartingPoint.y - this.targetVelocity / this.angularVelocity_rad_per_sec * (Math.sin(initialTargetHeading) - Math.sin(finalTargetHeading));
        return new Coordinate(x, y);
    }
}

