/*
 * Decompiled with CFR 0.152.
 */
package florent.pattern;

import florent.pattern.Frame;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class PatternUtils {
    private static final boolean DEBUG = true;
    private static final int NO_MATCH_INDEX = -1;

    public static int getEndIndex(StringBuffer buffer, int bufferLength, int maxLength, int residualLength) {
        int length;
        int upper = length = maxLength;
        int match = -2;
        int patternLength = bufferLength - residualLength;
        if (length > 0 && bufferLength > maxLength + residualLength + 1) {
            String search = buffer.substring(bufferLength - maxLength);
            String pattern = buffer.substring(0, patternLength);
            boolean found = false;
            int matchLength = 0;
            do {
                int i;
                boolean bl = found = (i = pattern.lastIndexOf(search.substring(maxLength - length))) != -1 && patternLength > i + residualLength + 1;
                if (found) {
                    match = i;
                    matchLength = length;
                    continue;
                }
                upper = length;
            } while ((length = found ? length + (upper - length) / 2 : length / 2) > 0 && length < upper - 1);
            return match < 0 ? -1 : match + matchLength;
        }
        return -1;
    }

    public static double normalRelativeAngle(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
    }

    public static double projectedBearing(long index, Point2D.Double enemyLocation, Point2D.Double robotLocation, ArrayList movie, int movieSize, double lastHeading, double bulletVelocity, Point2D.Double arrived) {
        double newX = enemyLocation.x;
        double newY = enemyLocation.y;
        double heading = lastHeading;
        long travelTime = 0L;
        long bulletTravelTime = 0L;
        if (index > 0L) {
            int i = (int)index;
            while (i < movieSize && travelTime <= bulletTravelTime) {
                Frame frame = (Frame)movie.get(i);
                heading = PatternUtils.normalRelativeAngle(heading + frame.getDeltaHeading());
                bulletTravelTime = (long)(robotLocation.distance(newX += frame.getVelocity() * Math.sin(heading), newY += frame.getVelocity() * Math.cos(heading)) / bulletVelocity);
                ++travelTime;
                ++i;
            }
        }
        arrived.setLocation(newY, newY);
        return PatternUtils.absoluteBearing(robotLocation, new Point2D.Double(newX, newY));
    }

    public static int record(Frame frame, int deltaTime, StringBuffer buffer, ArrayList movie, int bufferIndex, int maxMovie) {
        int n = bufferIndex;
        int i = 0;
        while (i < deltaTime) {
            n = PatternUtils.recordFrame(frame, buffer, movie, bufferIndex, maxMovie);
            ++i;
        }
        return n;
    }

    private static int recordFrame(Frame frame, StringBuffer buffer, ArrayList movie, int bufferIndex, int maxMovie) {
        int n = bufferIndex;
        buffer.append(frame.getKey());
        movie.add(frame);
        if (n == maxMovie) {
            buffer.deleteCharAt(0);
            movie.remove(0);
        } else {
            ++n;
        }
        return n;
    }

    private static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
}

