/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.DangerPrediction.Evaluators;

import rdt.AgentSmith.DangerPrediction.CachedVelocityData;
import rdt.AgentSmith.DangerPrediction.CommandSequence;
import rdt.AgentSmith.DangerPrediction.ICommandSequenceEvaluator;
import rdt.AgentSmith.DangerPrediction.MovementCommand;
import rdt.AgentSmith.DangerPrediction.PredictedRobotState;
import rdt.AgentSmith.EnemyPrediction.BulletPrediction;
import rdt.AgentSmith.EnemyPrediction.EnemyPrediction;
import rdt.AgentSmith.EnemyPrediction.IEnemyPredictionManager;
import rdt.AgentSmith.EnemyPrediction.PredictedPosition;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.Profiling.Profiler;

public class ClosestDistanceToEachBullet
implements ICommandSequenceEvaluator {
    private PredictedRobotState _currentRobotState = new PredictedRobotState();
    private PredictedRobotState[] _predictedRobotStatesFast;
    private int _activePredictionLength;
    private IRobot _robot;
    private IEnemyPredictionManager _enemyPredictionManager;
    private double _battlefieldPadding;
    private double _battlefieldWidthWithPadding;
    private double _battlefieldHeightWithPadding;
    private double MinDistanceToTargetSq;
    private long _lastCachedRobotStateTick;

    public ClosestDistanceToEachBullet(IRobot robot, IEnemyPredictionManager enemyPredictionManager, int maxCommandSequenceLength) {
        this._robot = robot;
        this._enemyPredictionManager = enemyPredictionManager;
        this._battlefieldPadding = this._robot.getBotSizeMax() * 0.6;
        this._battlefieldWidthWithPadding = this._robot.getBattleFieldWidth() - this._battlefieldPadding;
        this._battlefieldHeightWithPadding = this._robot.getBattleFieldHeight() - this._battlefieldPadding;
        this.MinDistanceToTargetSq = 40000.0;
        this._predictedRobotStatesFast = new PredictedRobotState[maxCommandSequenceLength];
        for (int index = 0; index < maxCommandSequenceLength; ++index) {
            this._predictedRobotStatesFast[index] = new PredictedRobotState();
        }
    }

    @Override
    public void Evaluate(CommandSequence sequence) {
        if (this._lastCachedRobotStateTick != this._robot.getTime()) {
            this._currentRobotState.X = this._robot.getX();
            this._currentRobotState.Y = this._robot.getY();
            this._currentRobotState.Heading = this._robot.getHeadingRadians();
            this._currentRobotState.Velocity = this._robot.getVelocity();
            this._lastCachedRobotStateTick = this._robot.getTime();
        }
        this.Evaluate(sequence, this._currentRobotState, this._lastCachedRobotStateTick);
    }

    @Override
    public void Evaluate(CommandSequence sequence, PredictedRobotState startingState, long startingTick) {
        Profiler.StartScope("Evaulate");
        double wallFitness = this.GeneratePredictedPositionsAndAssociatedData(sequence, startingState);
        double targetFitness = this.EvaluateTargets(startingTick);
        double fitness = this.EvaluateBulletDistances(startingTick) + wallFitness + targetFitness;
        sequence.Fitness = fitness * fitness;
        Profiler.EndScope();
    }

    private double GeneratePredictedPositionsAndAssociatedData(CommandSequence sequence, PredictedRobotState startingState) {
        Profiler.StartScope("GeneratePredictedPositionsAndAssociatedData");
        PredictedRobotState initialStateFast = startingState;
        PredictedRobotState predictedStateFast = startingState;
        CachedVelocityData cachedVelocityData = CachedVelocityData.Get(initialStateFast.Velocity);
        double energyLost = 0.0;
        this._activePredictionLength = sequence.ActiveLength;
        int[] sequenceCommands = sequence.Sequence;
        for (int index = 0; index < this._activePredictionLength; ++index) {
            predictedStateFast = this._predictedRobotStatesFast[index];
            cachedVelocityData = MovementCommand.PredictCommandFast(sequenceCommands[index], initialStateFast, predictedStateFast, cachedVelocityData);
            initialStateFast = predictedStateFast;
            double x = predictedStateFast.X;
            double y = predictedStateFast.Y;
            if (!(x <= this._battlefieldPadding || x >= this._battlefieldWidthWithPadding || y <= this._battlefieldPadding) && !(y >= this._battlefieldHeightWithPadding)) continue;
            energyLost += cachedVelocityData.WallHitDamage;
        }
        Profiler.EndScope();
        return energyLost;
    }

    private double EvaluateBulletDistances(long startingTick) {
        Profiler.StartScope("EvaluateBulletDistances");
        BulletPrediction[] bulletPredictions = this._enemyPredictionManager.GetBulletPredictions();
        int bulletPredictionCount = this._enemyPredictionManager.GetBulletPredictionCount();
        double fitness = 0.0;
        for (int bulletIndex = 0; bulletIndex < bulletPredictionCount; ++bulletIndex) {
            BulletPrediction bulletPrediction = bulletPredictions[bulletIndex];
            double closestDistanceSquared = Double.MAX_VALUE;
            long predictionTick = startingTick - bulletPrediction.TickPredictionWasGenerated;
            for (int predictedRobotStateIndex = 0; predictedRobotStateIndex < this._activePredictionLength && predictionTick < bulletPrediction.PredictionDeactivationTime; ++predictedRobotStateIndex) {
                PredictedRobotState robotState = this._predictedRobotStatesFast[predictedRobotStateIndex];
                PredictedPosition bulletPosition = bulletPrediction.PredicctedPositions[(int)(++predictionTick)];
                double deltaX = bulletPosition.X - robotState.X;
                double deltaY = bulletPosition.Y - robotState.Y;
                double distanceSquared = deltaX * deltaX + deltaY * deltaY;
                closestDistanceSquared = Math.min(distanceSquared, closestDistanceSquared);
            }
            fitness += bulletPrediction.DamageDealt / (closestDistanceSquared += 0.1);
        }
        Profiler.EndScope();
        return fitness;
    }

    private double EvaluateTargets(long startingTick) {
        Profiler.StartScope("Evaluate Targets");
        int enemyPredictionCount = this._enemyPredictionManager.GetEnemyPredictionCount();
        EnemyPrediction[] enemyPredictions = this._enemyPredictionManager.GetEnemyPredictions();
        double fitness = 0.0;
        for (int index = 0; index < enemyPredictionCount; ++index) {
            EnemyPrediction enemyPrediction = enemyPredictions[index];
            int predictionIndex = (int)(startingTick - enemyPrediction.TickPredictionWasGenerated);
            for (int predictedRobotStateIndex = 0; predictedRobotStateIndex < this._activePredictionLength && predictionIndex < enemyPrediction.PredictedEnemyMovement.length - 1; ++predictedRobotStateIndex) {
                PredictedRobotState robotState = this._predictedRobotStatesFast[predictedRobotStateIndex];
                PredictedPosition enemyPos = enemyPrediction.PredictedEnemyMovement[++predictionIndex];
                double dX = robotState.X - enemyPos.X;
                double dY = robotState.Y - enemyPos.Y;
                double distanceSq = dX * dX + dY * dY;
                if (!(distanceSq <= this.MinDistanceToTargetSq)) continue;
                fitness += 0.6 / distanceSq;
            }
        }
        Profiler.EndScope();
        return fitness;
    }
}

