/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Guns;

import java.util.ArrayList;
import rdt.AgentSmith.Guns.BulletClassifier;
import rdt.AgentSmith.Guns.Gun;
import rdt.AgentSmith.Guns.GunComparator;
import rdt.AgentSmith.Guns.GunImplementations.HeadOnTargetingGun;
import rdt.AgentSmith.Guns.GunImplementations.IterativeCircularWithWallStopping;
import rdt.AgentSmith.Guns.GunImplementations.IterativeLinearWithWallStopping;
import rdt.AgentSmith.Guns.GunImplementations.SimpleLinearGun;
import rdt.AgentSmith.Guns.GunStatsDebugDrawer;
import rdt.AgentSmith.Guns.IClassifiedBulletListener;
import rdt.AgentSmith.Guns.IGunManager;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.RobotHistory.RobotHistory;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.Stats.IStats;
import rdt.AgentSmith.Targeting.Target;
import rdt.AgentSmith.Waves.IWaveEventHandler;
import rdt.AgentSmith.Waves.IWaveManager;
import rdt.AgentSmith.Waves.WaveData;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;

public class FriendlyGunManager
implements IGunManager,
IWaveEventHandler,
IClassifiedBulletListener {
    private final Gun[] _guns;
    private final BulletClassifier _bulletClassifier;
    private final IRobot _robot;
    private final ArrayList<Gun> _sortedGuns;
    private final GunComparator _gunComparator = new GunComparator();

    public FriendlyGunManager(String ownerName, IRobot robot, RobotHistory robotHistory, IWaveManager friendlyWaveManager, IStats stats) {
        this._robot = robot;
        String ownerNameAppended = "At : " + ownerName;
        this._guns = new Gun[]{new HeadOnTargetingGun(ownerNameAppended, robot, robotHistory, stats, 0L), new SimpleLinearGun(ownerNameAppended, robot, robotHistory, stats, 0L), new IterativeLinearWithWallStopping(ownerNameAppended, robot, robotHistory, stats, 0L), new IterativeCircularWithWallStopping(ownerNameAppended, robot, robotHistory, stats, 0L)};
        this._sortedGuns = new ArrayList(this._guns.length);
        for (int gunIndex = 0; gunIndex < this._guns.length; ++gunIndex) {
            this._sortedGuns.add(this._guns[gunIndex]);
        }
        this._guns[0].RegisterHit(0.0);
        this._guns[2].RegisterHit(0.0);
        this._bulletClassifier = new BulletClassifier(this._guns);
        friendlyWaveManager.RegisterWaveEventHandler(this);
        this._robot.RegisterDebugDrawer(new GunStatsDebugDrawer(this._sortedGuns, 10, 20 * this._guns.length));
    }

    @Override
    public int PredictAngles(double originX, double originY, long tickFired, double bulletVelocity, double[] anglesOut) {
        this.SortGunsByRecentHitRate();
        anglesOut[0] = this._sortedGuns.get(0).GetFiringAngle(originX, originY, tickFired, bulletVelocity);
        return 1;
    }

    @Override
    public void OnWaveGeneratedEvent() {
    }

    @Override
    public void OnHitByBulletWithWaveEvent(HitByBulletEvent eventData, WaveData wave) {
    }

    @Override
    public void OnBulletHitBulletWithWaveEvent(BulletHitBulletEvent eventData, WaveData wave) {
    }

    @Override
    public void OnWavePassed(WaveData wave, Target target) {
        RobotSnapshot targetSnapshot = target.RobotHistory.GetSnapshotForTick(this._robot.getTime());
        double botHalfWidthRadians = Math.atan(this._robot.getBotSizeMax() / targetSnapshot.DistanceToItsTarget) * 0.5;
        this._bulletClassifier.Classify(targetSnapshot.LocationX, targetSnapshot.LocationY, wave, this, botHalfWidthRadians);
    }

    @Override
    public void OnBulletClassified(Gun gun, int gunIndex, boolean hit, double deltaAngle) {
        if (hit) {
            gun.RegisterHit(deltaAngle);
        } else {
            gun.RegisterMiss(deltaAngle);
        }
    }

    @Override
    public void NoClassificationAvailable() {
    }

    private void SortGunsByRecentHitRate() {
        this._sortedGuns.sort(this._gunComparator);
    }
}

