/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Stats;

import rdt.AgentSmith.Stats.Stat;
import rdt.AgentSmith.Utils.MathUtils;

public class RollingAverage
extends Stat {
    private final int _historyLength;
    private final double _weighting;
    private double _rollingAverage;
    private int _count;

    public RollingAverage(String name, int historyLength, double weighting) {
        super(name);
        this._historyLength = historyLength;
        this._weighting = weighting;
        this._rollingAverage = 0.0;
        this._count = 0;
    }

    public void Record(double val) {
        ++this._count;
        this._rollingAverage = MathUtils.CalcRollingAverage(this._rollingAverage, val, Math.min(this._historyLength, this._count), this._weighting);
    }

    public double GetAverage() {
        return this._rollingAverage;
    }

    public String toString() {
        return this.Name + ": " + this.GetAverage();
    }
}

