/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.Gun;
import pa3k.Log;
import pa3k.MonteCarlo;
import pa3k.MonteCarloAiming;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;

public class MonteCarloGun
extends Gun {
    protected int waiting;
    protected double lastHitProbability;
    protected long targetReevaluate;
    protected MonteCarlo mc;

    public MonteCarloGun(AdvancedRobot robot, Tracking tracking, MonteCarlo mc) {
        super(robot, tracking);
        this.mc = mc;
    }

    @Override
    public void init() {
        this.waiting = 0;
        this.lastHitProbability = 0.0;
    }

    @Override
    public void turn() {
        int scanPrio;
        Position futurePos = new Position((Robot)this.robot);
        futurePos.modify(1L, this.robot.getVelocity(), this.robot.getHeadingRadians());
        if (this.targetReevaluate <= 0L || this.target == null || this.target.lastSeen(this.robot.getTime()) > 3L) {
            this.targetReevaluate = 30L;
            Object[] ops = this.tracking.getTargets();
            if (ops.length > 0) {
                this.target = (Opponent)ops[0];
            }
            if (this.target != null) {
                this.tracking.setOpponentOfInterest(this.target);
                Log.log(2, "Targeting " + this.target + " random hit probability " + this.lastHitProbability);
            }
        }
        if (this.target != null && this.newBullet == null && (scanPrio = this.target.getScanPriority(this.robot.getTime())) != -1 && scanPrio < 2) {
            double hitP = MonteCarloAiming.getRandomHitProbability(this.mc, 1.8, futurePos);
            assert (hitP != Double.NaN);
            if (this.robot.getGunHeat() == 0.0 && (this.waiting == 0 || hitP > 0.11)) {
                double energy = 1.8;
                if (hitP > 0.15) {
                    energy = 2.4;
                }
                if (hitP > 0.2) {
                    energy = 3.0;
                }
                if (hitP < 0.1) {
                    energy = 0.6;
                }
                if (energy > this.robot.getEnergy() - 0.1) {
                    energy = this.robot.getEnergy() - 0.1;
                }
                if (energy >= 0.1) {
                    double energyNeeded = this.target.getLastEnergy() / 4.0;
                    if (energyNeeded < energy && (energy = energyNeeded) < 0.1) {
                        energy = 0.1;
                    }
                    this.newBullet = this.target.getSelfAiming().getBestAimingAngle(futurePos, this.target, energy, this.robot.getTime());
                    Log.log(2, "Firing at " + this.target + " monte carlo hit probability " + hitP);
                    this.waiting = 15;
                }
            } else if (this.waiting > 0) {
                --this.waiting;
            }
            this.lastHitProbability = hitP;
        }
        --this.targetReevaluate;
        super.turn();
    }
}

