/*
 * Decompiled with CFR 0.152.
 */
package jekl.gunnery.util;

import java.awt.geom.Point2D;
import java.text.NumberFormat;
import jekl.intelligence.Enemy;
import robocode.util.Utils;

public class WaveBullet {
    private Enemy target;
    private Point2D.Double shotOrigin;
    private Point2D.Double initialTargetLocation;
    private double shotPower;
    private double shotVelocity;
    private double startingAbsTargetBearing;
    private double maxAnglePossible;
    private long eventTime;
    private long lastScanTime;
    private int distanceIndex;
    private int latVelIndex;
    private int accelIndex;
    private int wallIndex;
    private int radialIndex;
    private int direction;
    private static final double GUESS_FACTORS = 31.0;

    public WaveBullet(Enemy e, Point2D.Double origin, double _shotPower, long _eventTime, int _distIndex, int _latVelIndex, int _accelIndex, double _maxAnglePossible, int _direction, double baseAngle, int _wallIndex, int _radialIndex) {
        this.target = e;
        this.shotOrigin = origin;
        this.initialTargetLocation = e.getCurrentLoc();
        this.shotPower = _shotPower;
        this.shotVelocity = 20.0 - 3.0 * _shotPower;
        this.startingAbsTargetBearing = baseAngle;
        this.maxAnglePossible = _maxAnglePossible;
        this.eventTime = _eventTime;
        this.lastScanTime = _eventTime;
        this.distanceIndex = _distIndex;
        this.latVelIndex = _latVelIndex;
        this.accelIndex = _accelIndex;
        this.wallIndex = _wallIndex;
        this.radialIndex = _radialIndex;
        this.direction = _direction;
    }

    public boolean hasReached(long timeNow) {
        long flightTime = timeNow - this.eventTime;
        return (double)flightTime * this.shotVelocity >= this.shotOrigin.distance(this.target.getCurrentLoc());
    }

    public int getGuessIndex() {
        double currentAbsBearingFromShotOrigin = this.absoluteBearing(this.shotOrigin, this.target.getCurrentLoc());
        int retVal = (int)Math.max(0.0, Math.min(30.0, (double)((int)Math.round(Utils.normalRelativeAngle((double)(currentAbsBearingFromShotOrigin - this.startingAbsTargetBearing)) * (double)this.direction / this.maxAnglePossible * 15.0 + 15.0))));
        return retVal;
    }

    private double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public double getDistanceTraveled(long timeNow) {
        long flighTime = timeNow - this.eventTime;
        return this.shotVelocity * (double)flighTime;
    }

    public int getAccelIndex() {
        return this.accelIndex;
    }

    public int getDistanceIndex() {
        return this.distanceIndex;
    }

    public int getLatVelIndex() {
        return this.latVelIndex;
    }

    public int getRadialIndex() {
        return this.radialIndex;
    }

    public int getWallIndex() {
        return this.wallIndex;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public double getShotVelocity() {
        return this.shotVelocity;
    }

    public Point2D.Double getShotOrigin() {
        return this.shotOrigin;
    }

    public void debug() {
        double currentAbsBearingFromShotOrigin = this.absoluteBearing(this.shotOrigin, this.target.getCurrentLoc());
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        System.out.println("------------ Deubg info -------------");
        System.out.println("Target\t\t: \t" + this.target.getName());
        System.out.println("Origin\t\t: \t(" + nf.format(this.shotOrigin.getX()) + "," + nf.format(this.shotOrigin.getY()) + ")");
        System.out.println("Init Loc\t: \t(" + nf.format(this.initialTargetLocation.getX()) + "," + nf.format(this.initialTargetLocation.getY()) + ")");
        System.out.println("ShotPower\t: \t" + this.shotPower);
        System.out.println("ShotVelocity: \t" + this.shotVelocity);
        System.out.println("Time\t\t: \t" + this.eventTime);
        System.out.println("DI\t\t\t: \t" + this.distanceIndex);
        System.out.println("LI\t\t\t: \t" + this.latVelIndex);
        System.out.println("AI\t\t\t: \t" + this.accelIndex);
        System.out.println("GI\t\t\t:\t" + (int)Math.max(0.0, Math.min(30.0, (double)((int)Math.round(Utils.normalRelativeAngle((double)(currentAbsBearingFromShotOrigin - this.startingAbsTargetBearing)) * (double)this.direction / this.maxAnglePossible * 15.0 + 15.0)))));
        System.out.println("------------ Deubg info -------------");
    }
}

