/*
 * Decompiled with CFR 0.152.
 */
package jekl.navigation.movement;

import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Iterator;
import jekl.Jekyl;
import jekl.intelligence.Enemy;
import jekl.navigation.movement.AbstractMovement;
import jekl.navigation.movement.Movement;
import jekl.navigation.util.BattleMap;
import jekl.navigation.util.GravPoint;
import jekl.util.BotHelp;

public class AntiGravityMovement
extends AbstractMovement
implements Movement {
    Hashtable targets;
    BattleMap map;
    Jekyl ar;
    GravPoint cp;

    public AntiGravityMovement(Jekyl _ar) {
        super(_ar);
        this.map = new BattleMap(_ar);
        this.ar = _ar;
        this.targets = _ar.getTargets();
    }

    public void doMovement() {
        if (Math.abs(this.ar.getDistanceRemaining()) < this.ar.getVelocity() + 1.0) {
            double xforce = 0.0;
            double yforce = 0.0;
            double totalForce = 1000.0;
            Point2D.Double destination = this.getNextPoint();
            Iterator targetsIterator = this.targets.keySet().iterator();
            int j = 0;
            while (j < 40) {
                double tempForce;
                double ang;
                double force;
                GravPoint p;
                Point2D.Double propMov = this.getNextPoint();
                while (targetsIterator.hasNext()) {
                    Enemy en = (Enemy)this.targets.get((String)targetsIterator.next());
                    if (!en.isLive()) continue;
                    p = new GravPoint(en.getX(), en.getY(), -1000.0);
                    force = p.getPower() / Math.pow(BotHelp.getRange(propMov.getX(), propMov.getY(), p.getX(), p.getY()), 2.0);
                    ang = Math.max(BotHelp.normaliseBearing(Math.atan2(propMov.getY() - p.getY(), propMov.getX() - p.getX())), 0.001);
                    xforce += Math.min(Math.sin(ang) * force, 1000.0);
                    yforce += Math.min(Math.cos(ang) * force, 1000.0);
                }
                GravPoint cp = new GravPoint(this.map.getMidPoint(), -3000.0);
                force = cp.getPower() / Math.pow(BotHelp.getRange(propMov.getX(), propMov.getY(), cp.getX(), cp.getY()), 1.0);
                ang = Math.max(BotHelp.normaliseBearing(Math.atan2(propMov.getY() - cp.getY(), propMov.getX() - cp.getX())), 0.1);
                xforce += Math.min(Math.sin(ang) * force, 1000.0);
                yforce += Math.min(Math.cos(ang) * force, 1000.0);
                if (this.ar.getOthers() > 1) {
                    Point2D.Double nearestCorner = this.map.findNearestCorner();
                    p = new GravPoint(nearestCorner.getX(), nearestCorner.getY(), 2000.0);
                    if (Math.abs(BotHelp.getRange(this.ar.getX(), this.ar.getY(), nearestCorner.getX(), nearestCorner.getY())) > 250.0) {
                        force = p.getPower() / Math.pow(BotHelp.getRange(propMov.getX(), propMov.getY(), p.getX(), p.getY()), 1.0);
                        ang = BotHelp.normaliseBearing(Math.atan2(propMov.getY() - p.getY(), propMov.getX() - p.getX()));
                        xforce += Math.sin(ang) * force;
                        yforce += Math.cos(ang) * force;
                    }
                }
                if ((tempForce = Math.sqrt(xforce * xforce + yforce * yforce)) != Double.POSITIVE_INFINITY && tempForce != Double.NEGATIVE_INFINITY && tempForce < totalForce && this.map.isSafe(propMov)) {
                    totalForce = tempForce;
                    destination.setLocation(propMov);
                }
                ++j;
            }
            this.goTo(destination);
        }
    }

    public void notifyOfHit() {
    }

    private Point2D.Double getNextPoint() {
        double nextX = Math.random() * 300.0 - 150.0 + this.ar.getX();
        double nextY = Math.random() * 300.0 - 150.0 + this.ar.getY();
        if (nextX < this.map.getMinX()) {
            nextX = this.map.getMinX();
        }
        if (nextY < this.map.getMinY()) {
            nextY = this.map.getMinY();
        }
        if (nextX > this.map.getMaxX()) {
            nextX = this.map.getMaxX();
        }
        if (nextY > this.map.getMaxY()) {
            nextY = this.map.getMaxY();
        }
        return new Point2D.Double(nextX, nextY);
    }
}

