/*
 * Decompiled with CFR 0.152.
 */
package jekl.navigation.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jekl.Jekyl;
import jekl.util.Constants;

public class BattleMap
implements Constants {
    private Jekyl ar;
    private double robotSize;
    private double width;
    private double height;
    private double maxX;
    private double maxY;
    private double minX;
    private double minY;
    private Rectangle2D.Double battleField;
    private Rectangle2D.Double safeZone;
    private Point2D.Double bottomLeftCorner;
    private Point2D.Double topLeftCorner;
    private Point2D.Double topRightCorner;
    private Point2D.Double bottomRightCorner;
    private Point2D.Double midPoint;

    public BattleMap(Jekyl _ar) {
        this.ar = _ar;
        this.robotSize = Math.max(_ar.getHeight() / 2.0, _ar.getWidth() / 2.0);
        this.maxX = _ar.getBattleFieldWidth() - 18.0;
        this.maxY = _ar.getBattleFieldHeight() - 18.0;
        this.minX = 18.0;
        this.minY = 18.0;
        this.battleField = new Rectangle2D.Double(0.0, 0.0, _ar.getBattleFieldWidth(), _ar.getBattleFieldHeight());
        this.safeZone = new Rectangle2D.Double(18.0, 18.0, this.ar.getWidth() - 36.0, this.ar.getHeight() - 36.0);
        this.bottomLeftCorner = new Point2D.Double(0.0, 0.0);
        this.topLeftCorner = new Point2D.Double(0.0, _ar.getBattleFieldHeight());
        this.topRightCorner = new Point2D.Double(_ar.getBattleFieldWidth(), _ar.getBattleFieldHeight());
        this.bottomRightCorner = new Point2D.Double(_ar.getBattleFieldWidth(), 0.0);
        this.midPoint = new Point2D.Double(_ar.getBattleFieldWidth() / 2.0, _ar.getBattleFieldHeight() / 2.0);
    }

    public Point2D.Double findNearestCorner() {
        Point2D.Double currentPos = new Point2D.Double(this.ar.getX(), this.ar.getY());
        double range = 100000.0;
        Point2D.Double nearestCorner = null;
        if (this.bottomLeftCorner.distance(currentPos.getX(), currentPos.getY()) < range) {
            nearestCorner = this.bottomLeftCorner;
            range = this.bottomLeftCorner.distance(currentPos.getX(), currentPos.getY());
        }
        if (this.topLeftCorner.distance(currentPos.getX(), currentPos.getY()) < range) {
            nearestCorner = this.topLeftCorner;
            range = this.topLeftCorner.distance(currentPos.getX(), currentPos.getY());
        }
        if (this.topRightCorner.distance(currentPos.getX(), currentPos.getY()) < range) {
            nearestCorner = this.topRightCorner;
            range = this.topRightCorner.distance(currentPos.getX(), currentPos.getY());
        }
        if (this.bottomRightCorner.distance(currentPos.getX(), currentPos.getY()) < range) {
            nearestCorner = this.bottomRightCorner;
        }
        return nearestCorner;
    }

    public double getDistanceToNearestCorner() {
        Point2D.Double nearestCorner = this.findNearestCorner();
        return Math.abs(nearestCorner.distance(this.ar.getX(), this.ar.getY()));
    }

    public double getDistanceToNearestCorner(Point2D.Double p) {
        return Math.abs(p.distance(this.findNearestCorner()));
    }

    public double bearingToNearestCorner() {
        Point2D.Double nearestCorner = this.findNearestCorner();
        Point2D.Double currentLoc = this.ar.getCurrentLoc();
        return Math.atan2(currentLoc.getX() - nearestCorner.getX(), currentLoc.getY() - nearestCorner.getY());
    }

    public boolean isSafe(double x, double y) {
        return this.safeZone.contains(x, y);
    }

    public boolean isSafe(Point2D.Double p) {
        return this.safeZone.contains(p);
    }

    public double getDistanceFromCenterPoint(Point2D.Double p) {
        return Math.abs(this.midPoint.distance(p));
    }

    public Rectangle2D.Double getBattleField() {
        return this.battleField;
    }

    public Point2D.Double getMidPoint() {
        return this.midPoint;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }
}

