/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.Enemy;
import bing2.Gun;
import bing2.MathUtils;
import bing2.MyRobot;
import bing2.WaveTracker;
import java.util.ArrayList;
import java.util.HashMap;
import robocode.ScannedRobotEvent;

public class EnemyTracker {
    private long maxRecords;
    private ArrayList<Enemy> history;
    private HashMap<Long, Enemy> hashIndex;
    public String enemyName;
    public Enemy latest;
    ArrayList<Double> myBearings = new ArrayList();
    ArrayList<Integer> myDirections = new ArrayList();
    public WaveTracker waves = new WaveTracker();

    public EnemyTracker(long l, String string) {
        this.maxRecords = l;
        this.enemyName = string;
        this.history = new ArrayList();
        this.hashIndex = new HashMap();
    }

    public void onRoundStart() {
        this.history.clear();
        this.hashIndex.clear();
        this.myBearings.clear();
        this.myDirections.clear();
        this.waves.onRoundStart();
    }

    public Enemy getLatestRecord() {
        return this.latest;
    }

    public Enemy getRecordByTime(long l) {
        return this.hashIndex.get(l);
    }

    public void setMaxRecords(long l) {
        this.maxRecords = l;
    }

    public long getMaxRecords() {
        return this.maxRecords;
    }

    public Enemy addObservation(long l, ScannedRobotEvent scannedRobotEvent, MyRobot myRobot) {
        double d = MathUtils.normalizeRadians(scannedRobotEvent.getBearingRadians() + myRobot.getHeadingRadians());
        double d2 = scannedRobotEvent.getHeadingRadians();
        double d3 = scannedRobotEvent.getEnergy();
        double d4 = scannedRobotEvent.getDistance();
        double d5 = scannedRobotEvent.getVelocity();
        Enemy enemy = null;
        for (long i = l - 1L; i >= l - 3L && (enemy = this.hashIndex.get(i)) == null; --i) {
        }
        myRobot.assertMsg(enemy != null, ">>> last record not found");
        if (enemy != null) {
            myRobot.assertMsg(enemy.time == l - 1L, ">>> adjacent record not found: last.time = " + enemy.time);
        }
        Enemy enemy2 = new Enemy(l, this.enemyName, d, d2, d4, d5, d3, myRobot, enemy);
        this.history.add(enemy2);
        this.hashIndex.put(l, enemy2);
        this.latest = enemy2;
        this.myBearings.add(0, MathUtils.normalizeRadians(d + Math.PI));
        this.myDirections.add(0, MathUtils.sign(myRobot.getVelocity() * Math.sin(scannedRobotEvent.getBearingRadians())));
        if (this.waves != null && enemy != null && enemy2.deltaEnergy <= -0.09 && enemy2.deltaEnergy >= -3.01 && this.myBearings.size() >= 3) {
            this.waves.addWave(enemy.pos.x, enemy.pos.y, Gun.getBulletVelocity(-enemy2.deltaEnergy), l - 1L, this.myBearings.get(2), this.myDirections.get(2));
        }
        return enemy2;
    }
}

