/*
 * Decompiled with CFR 0.152.
 */
package jab.movement;

import jab.module.BotInfo;
import jab.module.BulletInfoEnemy;
import jab.module.Module;
import jab.module.Movement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class DiamondMovement
extends Movement {
    public static int[][][] brain;
    static final double BOT_WIDTH = 36.0;
    double xforce = 0.0;
    double yforce = 0.0;
    static final double BOT_FORCE = -5000.0;
    static final double MAX_LINE_FORCE = -1000.0;
    static final double WALL_FORCE = -10000.0;
    static final double LINE_POINTS_DISTANCE = 1.0;
    static final double ENEMY_DISTANCE = 250.0;
    private static final double MAX_DISTANCE_VAR_SEGM = 800.0;
    private static final double MAX_DISTANCE_LINES = 200.0;
    private static final int VARIABLE_BINS = 6;
    private static final int TARGETING_BINS = 101;
    static final double MAX_ESCAPE_ANGLE = 1.0;
    Vector<Line2D.Double> laserBeams = new Vector();
    Vector<GravPoint> gravPoints = new Vector();
    Vector<EnemyWave> enemyWaves = new Vector();
    Vector<String> hitBy = new Vector();
    Vector<BulletInfoEnemy> bulletHitsBullet = new Vector();
    Rectangle2D.Double myRect = new Rectangle2D.Double(0.0, 0.0, 36.0, 36.0);

    public DiamondMovement(Module bot) {
        super(bot);
    }

    public void move() {
        if (brain == null) {
            brain = new int[Module.totalNumOfEnemies][6][101];
        }
        this.gravPoints.removeAllElements();
        this.updateEnemyWaves();
        this.updateFriendFire();
        this.updateBulletHitsBullet();
        this.checkBulletHitsBullet();
        this.calculateForceAndMove();
    }

    private void updateFriendFire() {
        Enumeration<BulletInfoEnemy> friendFire = this.bot.enemyBullets.elements();
        while (friendFire.hasMoreElements()) {
            BulletInfoEnemy bul = friendFire.nextElement();
            if (!bul.isFriendFire) continue;
            GravPoint gravPoint = new GravPoint();
            gravPoint.x = bul.x;
            gravPoint.y = bul.y;
            gravPoint.power = -5000.0 * Math.max(0.0, 1.0 - bul.distance(new Point2D.Double(this.bot.getX(), this.bot.getY())) / 500.0);
            this.gravPoints.add(gravPoint);
        }
    }

    private void checkBulletHitsBullet() {
        int i = 0;
        while (i < this.bulletHitsBullet.size()) {
            BulletInfoEnemy bullet = this.bulletHitsBullet.get(i);
            if (this.myRect.contains(new Point2D.Double(bullet.x, bullet.y))) {
                System.out.println("###### Virtual Hit #####");
                EnemyWave hitWave = this.getHitWave(bullet.velocity);
                if (hitWave != null) {
                    this.logHit(hitWave, new Point2D.Double(bullet.x, bullet.y));
                    this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
                }
                this.bulletHitsBullet.remove(bullet);
            }
            ++i;
        }
    }

    private EnemyWave getHitWave(double velocity) {
        EnemyWave hitWave = null;
        int x = 0;
        while (x < this.enemyWaves.size()) {
            EnemyWave ew = this.enemyWaves.get(x);
            Point2D.Double double_ = new Point2D.Double(this.bot.getX(), this.bot.getY());
            if (Math.abs(ew.travelledDistance - double_.distance(ew.origin)) < 50.0 && Math.round(velocity * 10.0) == Math.round(ew.velocity * 10.0)) {
                hitWave = ew;
                break;
            }
            ++x;
        }
        return hitWave;
    }

    private void updateBulletHitsBullet() {
        int i = 0;
        while (i < this.bulletHitsBullet.size()) {
            BulletInfoEnemy bullet = this.bulletHitsBullet.get(i);
            bullet.x = Math.sin(bullet.headingRadians) * bullet.velocity + bullet.x;
            bullet.y = Math.cos(bullet.headingRadians) * bullet.velocity + bullet.y;
            if (!Module.battleField.contains(new Point2D.Double(bullet.x, bullet.y))) {
                this.bulletHitsBullet.remove(bullet);
            }
            this.myRect.x = this.bot.getX() - 18.0;
            this.myRect.y = this.bot.getY() - 18.0;
            ++i;
        }
    }

    private void updateEnemyWaves() {
        int i = 0;
        while (i < this.enemyWaves.size()) {
            EnemyWave ew = this.enemyWaves.get(i);
            ew.updateWave();
            if (this.hitBy.contains(ew.name) || this.bot.getOthers() == 1) {
                this.createGravLine(ew);
            }
            Point2D.Double double_ = new Point2D.Double(this.bot.getX(), this.bot.getY());
            if (ew.travelledDistance > ew.origin.distance(double_) + 36.0) {
                this.enemyWaves.remove(ew);
            }
            ++i;
        }
    }

    private void createGravLine(EnemyWave ew) {
        Point2D closestGP = null;
        Point2D.Double point = (Point2D.Double)ew.origin.clone();
        while (Module.battleField.contains(point)) {
            Point2D.Double double_ = new Point2D.Double(this.bot.getX(), this.bot.getY());
            if (ew.travelledDistance < ew.origin.distance(double_)) {
                Point2D.Double me;
                if (closestGP == null) {
                    closestGP = new GravPoint();
                    closestGP.setLocation((Point2D.Double)point.clone());
                }
                if (closestGP.distance(me = new Point2D.Double(this.bot.getX(), this.bot.getY())) >= point.distance(me)) {
                    closestGP.setLocation((Point2D.Double)point.clone());
                }
            }
            point.setLocation(point.x + Math.sin(ew.lineAngle) * 1.0, point.y + Math.cos(ew.lineAngle) * 1.0);
        }
        if (closestGP != null) {
            double distancePointToMe = closestGP.distance(new Point2D.Double(this.bot.getX(), this.bot.getY()));
            double forcePerOne = 1.0 - Math.min(1.0, distancePointToMe / 200.0);
            double distanceWaveToMe = ew.origin.distance(new Point2D.Double(this.bot.getX(), this.bot.getY())) - ew.travelledDistance;
            double modificator = 1.0 - Math.min(1.0, distanceWaveToMe / 800.0);
            ((GravPoint)closestGP).power = -1000.0 * modificator * forcePerOne;
            this.gravPoints.add((GravPoint)closestGP);
        }
    }

    public void listen(Event e) {
        if (e instanceof ScannedRobotEvent) {
            double energyDrop;
            String name = ((ScannedRobotEvent)e).getName();
            BotInfo enemy = this.bot.botsInfo.get(name);
            if (!this.bot.isTeammate(name) && (energyDrop = enemy.previousEnergy - enemy.energy) > 0.0 && energyDrop <= 3.0) {
                int var1_Distance = (int)(Math.min(800.0, this.bot.enemy.distance) / 160.0);
                var1_Distance = DiamondMovement.betweenMinMax(var1_Distance, 0, 5);
                int[] vars = new int[]{var1_Distance};
                int maxVisits = 0;
                int maxOffset = 50;
                int i = 0;
                while (i < 101) {
                    int current = brain[this.bot.getEnemyAssignedNum(name)][var1_Distance][i];
                    if (current > maxVisits) {
                        maxVisits = current;
                        maxOffset = i;
                    }
                    ++i;
                }
                double relativeAngle = (double)maxOffset * 1.0 * 2.0 / 100.0 - 1.0;
                double lineAngle = relativeAngle + this.absBearing(enemy.x, enemy.y, this.bot.getX(), this.bot.getY());
                this.enemyWaves.add(new EnemyWave(enemy.name, new Point2D.Double(enemy.x, enemy.y), Rules.getBulletSpeed((double)energyDrop), new Point2D.Double(this.bot.getX(), this.bot.getY()), vars, lineAngle));
            }
        } else if (e instanceof HitByBulletEvent) {
            EnemyWave ew = this.getHitWave((HitByBulletEvent)e);
            if (ew.name != null) {
                ew.hit = true;
                this.logHit(ew, new Point2D.Double(this.bot.getX(), this.bot.getY()));
                this.enemyWaves.remove(ew);
            }
        } else if (e instanceof BulletHitBulletEvent) {
            System.out.println("###### BULLET HIT BULLET #####");
            Bullet hitBullet = ((BulletHitBulletEvent)e).getHitBullet();
            BulletInfoEnemy enemyBullet = new BulletInfoEnemy();
            enemyBullet.headingRadians = hitBullet.getHeadingRadians();
            enemyBullet.velocity = hitBullet.getVelocity();
            enemyBullet.x = hitBullet.getX();
            enemyBullet.y = hitBullet.getY();
            this.bulletHitsBullet.add(enemyBullet);
        }
    }

    private void logHit(EnemyWave wave, Point2D.Double myPosition) {
        System.out.println("LogHit: " + wave.name);
        if (!this.hitBy.contains(wave.name)) {
            this.hitBy.add(wave.name);
            System.out.println("Take into account: " + wave.name);
        }
        double thetaFireTime = Utils.normalAbsoluteAngle((double)Math.atan2(wave.me.x - wave.origin.x, wave.me.y - wave.origin.y));
        double thetaBreak = Utils.normalAbsoluteAngle((double)Math.atan2(this.bot.getX() - wave.origin.x, this.bot.getY() - wave.origin.y));
        double offset = Utils.normalRelativeAngle((double)(thetaFireTime - thetaBreak));
        int targeting_offset = (int)((offset + 1.0) / 0.02);
        targeting_offset = DiamondMovement.betweenMinMax(targeting_offset, 0, 100);
        int[] nArray = brain[this.bot.getEnemyAssignedNum(wave.name)][wave.vars[0]];
        int n = targeting_offset;
        nArray[n] = nArray[n] + 1;
    }

    private EnemyWave getHitWave(HitByBulletEvent event) {
        EnemyWave hitWave = new EnemyWave();
        double maxDistanceTraveled = 0.0;
        int i = 0;
        while (i < this.enemyWaves.size()) {
            EnemyWave ew = this.enemyWaves.get(i);
            if (ew.name.equals(event.getName()) && ew.travelledDistance > maxDistanceTraveled) {
                maxDistanceTraveled = ew.time * ew.velocity;
                hitWave = ew;
            }
            ++i;
        }
        return hitWave;
    }

    private void calculateForceAndMove() {
        this.xforce = 0.0;
        this.yforce = 0.0;
        Enumeration<BotInfo> others = this.bot.botsInfo.elements();
        while (others.hasMoreElements()) {
            BotInfo botInfo = others.nextElement();
            if (botInfo.name.equals(this.bot.getName())) continue;
            GravPoint botGravPoint = new GravPoint();
            botGravPoint.x = botInfo.x;
            botGravPoint.y = botInfo.y;
            botGravPoint.power = this.bot.enemy != null && this.bot.enemy.name.equals(botInfo.name) ? -25000.0 * (1.0 - this.bot.enemy.distance / 250.0) : -5000.0;
            this.gravPoints.add(botGravPoint);
        }
        for (GravPoint gravPoint : this.gravPoints) {
            double force = gravPoint.power / Math.pow(this.getRange(this.bot.getX(), this.bot.getY(), gravPoint.x, gravPoint.y), 2.0);
            double ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(this.bot.getY() - gravPoint.y, this.bot.getX() - gravPoint.x));
            this.xforce += Math.sin(ang) * force;
            this.yforce += Math.cos(ang) * force;
        }
        this.xforce += 10000.0 / Math.pow(this.getRange(this.bot.getX(), this.bot.getY(), this.bot.getBattleFieldWidth(), this.bot.getY()), 2.0);
        this.xforce -= 10000.0 / Math.pow(this.getRange(this.bot.getX(), this.bot.getY(), 0.0, this.bot.getY()), 2.0);
        this.yforce += 10000.0 / Math.pow(this.getRange(this.bot.getX(), this.bot.getY(), this.bot.getX(), this.bot.getBattleFieldHeight()), 2.0);
        this.yforce -= 10000.0 / Math.pow(this.getRange(this.bot.getX(), this.bot.getY(), this.bot.getX(), 0.0), 2.0);
        this.xforce *= 2.0;
        this.yforce *= 2.0;
        this.goTo(this.bot.getX() - this.xforce, this.bot.getY() - this.yforce);
    }

    private void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(this.absBearing(this.bot.getX(), this.bot.getY(), x, y));
        double r = this.turnTo(angle);
        this.bot.setAhead(dist * r);
    }

    private int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.bot.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.bot.setTurnLeft(ang);
        return dir;
    }

    private double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    private double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    private double absBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.red);
        int i = 0;
        while (i < this.enemyWaves.size()) {
            EnemyWave ew = this.enemyWaves.get(i);
            if (this.hitBy.contains(ew.name)) {
                g.drawLine((int)ew.origin.x, (int)ew.origin.y, (int)(ew.origin.x + Math.sin(ew.lineAngle) * 1000.0), (int)(ew.origin.y + Math.cos(ew.lineAngle) * 1000.0));
            }
            ++i;
        }
        g.setColor(new Color(255, 0, 0, 100));
        i = 0;
        while (i < this.gravPoints.size()) {
            GravPoint point = this.gravPoints.get(i);
            double size = point.power / -1000.0;
            if (size <= 1.0) {
                g.fillOval((int)(point.getX() - 16.0 * size), (int)(point.getY() - 16.0 * size), (int)(32.0 * size), (int)(32.0 * size));
            } else {
                g.drawOval((int)(point.getX() - 16.0 * size), (int)(point.getY() - 16.0 * size), (int)(32.0 * size), (int)(32.0 * size));
            }
            ++i;
        }
        g.setColor(Color.red);
        i = 0;
        while (i < this.laserBeams.size()) {
            g.draw(this.laserBeams.get(i));
            ++i;
        }
        g.setColor(Color.white);
        g.drawLine((int)this.bot.getX(), (int)this.bot.getY(), (int)(10.0 * -this.xforce + this.bot.getX()), (int)(10.0 * -this.yforce + this.bot.getY()));
        g.setColor(Color.white);
        i = 0;
        while (i < this.bulletHitsBullet.size()) {
            g.draw(this.myRect);
            g.drawOval((int)this.bulletHitsBullet.get((int)i).x - 2, (int)this.bulletHitsBullet.get((int)i).y - 2, 4, 4);
            ++i;
        }
    }

    private static int betweenMinMax(int number, int min, int max) {
        int aux = number;
        aux = Math.min(max, Math.max(min, number));
        if (aux != number) {
            System.out.println("ERROR: " + number + " was out of bounds! Min: " + min + " Max: " + max);
        }
        return aux;
    }

    public class EnemyWave
    extends Ellipse2D.Double {
        private static final long serialVersionUID = 1L;
        public double lineAngle;
        public String name;
        public double time;
        public Point2D.Double origin;
        public double velocity;
        public Point2D.Double me;
        public double travelledDistance;
        public int[] vars;
        public boolean hit = false;

        public EnemyWave() {
        }

        public EnemyWave(String name, Point2D.Double origin, double velocity, Point2D.Double me, int[] vars, double lineAngle) {
            this.name = name;
            this.origin = origin;
            this.velocity = velocity;
            this.time = 0.0;
            this.me = me;
            this.vars = vars;
            this.x = origin.x - 18.0;
            this.y = origin.y - 18.0;
            this.lineAngle = lineAngle;
        }

        public void updateWave() {
            this.time += 1.0;
            this.travelledDistance = this.time * this.velocity;
            this.x = this.origin.x - this.travelledDistance;
            this.y = this.origin.y - this.travelledDistance;
            this.width = this.height = this.travelledDistance * 2.0;
        }
    }

    class GravPoint
    extends Point2D.Double {
        private static final long serialVersionUID = 1L;
        public double power;

        GravPoint() {
        }
    }
}

