/*
 * Decompiled with CFR 0.152.
 */
package jab.radar;

import jab.module.BotInfo;
import jab.module.Module;
import jab.module.Radar;
import java.util.Enumeration;
import robocode.Event;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class SmartSpinningRadar
extends Radar {
    int clockwise = 0;

    public SmartSpinningRadar(Module bot) {
        super(bot);
    }

    public void scan() {
        if (this.clockwise == 0) {
            this.clockwise = SmartSpinningRadar.sign(this.calculateRelativeAngleToCenter(this.bot.getRadarHeadingRadians()));
        }
        this.bot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY * (double)this.clockwise);
    }

    public void listen(Event e) {
        if (e instanceof ScannedRobotEvent) {
            Enumeration<BotInfo> enemies = this.bot.botsInfo.elements();
            boolean nextFound = false;
            while (enemies.hasMoreElements()) {
                BotInfo botInfo = enemies.nextElement();
                if (botInfo.name.equals(((ScannedRobotEvent)e).getName()) || this.bot.isTeammate(botInfo.name)) continue;
                double absoluteBearing = this.bot.getHeadingRadians() + botInfo.bearingRadians;
                double angle = Utils.normalRelativeAngle((double)(absoluteBearing - this.bot.getRadarHeadingRadians()));
                if (this.clockwise == 1 && angle >= 0.0) {
                    nextFound = true;
                    break;
                }
                if (this.clockwise != -1 || !(angle <= 0.0)) continue;
                nextFound = true;
                break;
            }
            if (!nextFound) {
                this.clockwise = this.clockwise == 1 ? -1 : 1;
            }
        }
    }

    private static int sign(double v) {
        return v > 0.0 ? 1 : -1;
    }

    private double calculateRelativeAngleToCenter(double heading) {
        return Utils.normalRelativeAngle((double)(Math.atan2(this.bot.getBattleFieldWidth() / 2.0 - this.bot.getX(), this.bot.getBattleFieldHeight() / 2.0 - this.bot.getY()) - heading));
    }
}

