/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.gun.pif;

import catcat20.atom.gun.AtomGun;
import catcat20.atom.gun.Gun;
import catcat20.atom.gun.pif.PIFData;
import catcat20.atom.rader.AtomRader;
import catcat20.atom.robot.Bot;
import catcat20.atom.robot.BotState;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.Wave;
import catcat20.atom.utils.knn.KNNData;
import catcat20.jewel.iolite.utils.MovementPredictor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class PatternMatcher
extends Gun {
    public static final double MELEE_MAX_PREDICT = 5.0;
    public static final int PATTERN_LENGTH = 20;
    public boolean addPath = true;
    public ArrayList<Point2D.Double> poss = new ArrayList();
    public ArrayList<Point2D.Double> possPass = new ArrayList();
    public ArrayList<Double> possDistance = new ArrayList();
    public ArrayList<Double> possPassDistance = new ArrayList();
    public ArrayList<PredictPath> paths = new ArrayList();
    Point2D.Double _myPos = new Point2D.Double();
    double averageDistance = 0.0;
    double bestDistAngle = 0.0;
    boolean _isMelee = false;
    int dataSize = 15;
    BasicStroke bs = new BasicStroke(3.0f);

    public PatternMatcher(TeamRobot _robot) {
        super(_robot);
    }

    @Override
    public void init() {
        this.paths.clear();
    }

    @Override
    public void execute() {
        this._isMelee = this._robot.getOthers() > 1;
        this._myPos.setLocation(this._robot.getX(), this._robot.getY());
        int others = this._robot.getOthers();
        for (Bot bot : AtomRader.enemies.values()) {
            this.dataSize = bot.patternModel.weights.length / 20;
            BotState state = bot.currentState;
            if (!bot.alive || state == null) continue;
            Point2D.Double enPos = state.getPosition();
            double distLast30 = enPos.distance(bot.botStateLogs.get(Math.min(32, bot.botStateLogs.size() - 1)).getPosition());
            double distLast60 = enPos.distance(bot.botStateLogs.get(Math.min(62, bot.botStateLogs.size() - 1)).getPosition());
            double distLast120 = enPos.distance(bot.botStateLogs.get(Math.min(122, bot.botStateLogs.size() - 1)).getPosition());
            PIFData data = new PIFData();
            data.oldEnState = bot.botStateLogs.get(0);
            data.enState = state;
            data.myState = AtomRader.currentMyState;
            data.distLast30 = distLast30;
            data.distLast60 = distLast60;
            data.distLast120 = distLast120;
            data.dirChangeTime = bot.dirChangeTime;
            data.velChangeTime = bot.velChangeTime;
            data.timeSinceDecelTime = bot.timeSinceDecelTime;
            data.bulletPower = AtomRader.calculatePower();
            data.shotFired = others <= 1 ? (double)AtomGun.duelShotFired : (double)AtomGun.meleeShotFired;
            if (bot.lastPatternMatcherData != null) {
                data.back = bot.lastPatternMatcherData;
                bot.lastPatternMatcherData.next = data;
            }
            bot.lastPatternMatcherData = data;
            boolean notNull = true;
            PIFData currentData = data;
            for (int i = 0; i < 22; ++i) {
                if (currentData.back == null || currentData.oldEnState == null) {
                    notNull = false;
                    break;
                }
                currentData = currentData.back;
            }
            if (!notNull) continue;
            double[] dataPoint = this.patternDataPoint(data, 20);
            if (this._isMelee) {
                bot.lastMeleePatternDataPoint = dataPoint;
                bot.meleePatternModel.addPoint(dataPoint, data);
                continue;
            }
            bot.lastPatternDataPoint = dataPoint;
            bot.patternModel.addPoint(dataPoint, data);
        }
    }

    public void updatePath() {
        int pathCount = 0;
        int posCount = 0;
        long time = this._robot.getTime();
        Graphics2D g = this._robot.getGraphics();
        double sumSquares = 0.0;
        Stroke cache = g.getStroke();
        for (int k = 0; k < this.paths.size(); ++k) {
            ++pathCount;
            PredictPath path = this.paths.get(k);
            Point2D oldPos = null;
            path.distanceTraveled = (double)(time - path.fireTime) * path.bulletVelocity;
            ++path.counter;
            double dist = path.path.get(Math.max(0, path.path.size() - 1)).distance(path.firePos);
            for (int i = 0; i < path.path.size(); ++i) {
                ++posCount;
                Point2D.Double pos = path.path.get(i);
                int colorVal = (int)(255.0 * ((double)(time - path.fireTime) * path.bulletVelocity) / dist);
                colorVal = HUtils.limit(0, colorVal, 255);
                Color color = new Color(colorVal, 255 - colorVal, 0);
                g.setColor(color);
                if (oldPos != null && oldPos.distance(pos) <= 10.0) {
                    g.drawLine((int)((Point2D.Double)oldPos).x, (int)((Point2D.Double)oldPos).y, (int)pos.x, (int)pos.y);
                } else {
                    oldPos = new Point2D.Double();
                }
                if (i == path.path.size() - 1) {
                    g.drawRect((int)pos.x - 18, (int)pos.y - 18, 36, 36);
                }
                ((Point2D.Double)oldPos).setLocation(pos.x, pos.y);
            }
            if (!(dist - path.distanceTraveled < 0.0)) continue;
            this.paths.remove(k);
            --k;
        }
        g.setStroke(cache);
    }

    public Point2D.Double simPos(PIFData data, BotState currentTr, double bulletVelocity, double dataDistance, boolean isNearest) {
        if (data == null) {
            return null;
        }
        long time = this._robot.getTime();
        PredictPath path = new PredictPath();
        Point2D.Double firePos = new Point2D.Double(this._myPos.x, this._myPos.y);
        boolean canPutPath = this.addPath;
        Point2D.Double pos = (Point2D.Double)currentTr.getPosition().clone();
        double distance = pos.distance(currentTr.getPosition());
        int count = (int)(distance / bulletVelocity);
        PIFData calcData = data;
        double velocity = currentTr.getVelocity();
        double heading = currentTr.getHeading();
        ArrayList<Point2D.Double> tempPoss = new ArrayList<Point2D.Double>();
        boolean isArrived = false;
        int counter = 0;
        double distanceTraveled = 0.0;
        while (!isArrived && counter < count + 50) {
            ++counter;
            double addHeading = 0.0;
            double addVelocity = 0.0;
            double newVelocity = velocity;
            if (calcData.next != null) {
                addHeading += Utils.normalRelativeAngle((double)(calcData.next.enState.getHeading() - calcData.enState.getHeading()));
                addVelocity += calcData.next.enState.getVelocity() - calcData.enState.getVelocity();
                newVelocity = calcData.next.enState.getVelocity();
            } else if (calcData.back != null) {
                addHeading += Utils.normalRelativeAngle((double)(calcData.enState.getHeading() - calcData.back.enState.getHeading()));
                addVelocity += calcData.enState.getVelocity() - calcData.back.enState.getVelocity();
            }
            heading += addHeading;
            velocity += addVelocity;
            velocity = newVelocity;
            heading = Utils.normalAbsoluteAngle((double)heading);
            velocity = HUtils.limit(-8.0, velocity, 8.0);
            pos = HUtils.project(pos, heading, velocity);
            if (calcData.next == null) {
                return null;
            }
            tempPoss.add(pos);
            this.possPassDistance.add(dataDistance);
            path.path.add(pos);
            path.eval = dataDistance;
            path.bulletVelocity = bulletVelocity;
            path.fireTime = time;
            path.firePos = firePos;
            calcData = calcData.next;
            distanceTraveled += bulletVelocity;
            if (!(this._myPos.distance(pos) < distanceTraveled)) continue;
            isArrived = true;
        }
        this.paths.add(path);
        this.possPass.addAll(tempPoss);
        this.poss.add(pos);
        this.possDistance.add(dataDistance);
        return pos;
    }

    public double effectiveHeading(double targetHeading, double targetVelocitySign) {
        return Utils.normalAbsoluteAngle((double)(targetHeading + (targetVelocitySign == 1.0 ? 0.0 : Math.PI)));
    }

    public double[] patternDataPoint(PIFData data, int count) {
        double[] patternDataPoint = new double[this.dataSize * count];
        PIFData currentData = data;
        for (int i = 0; i < count; ++i) {
            double[] point = this.dataPoint(currentData);
            for (int j = 0; j < point.length; ++j) {
                patternDataPoint[i * this.dataSize + j] = point[j];
            }
            currentData = currentData.back;
        }
        return patternDataPoint;
    }

    public double[] dataPoint(PIFData data) {
        BotState enState = data.enState;
        BotState myState = data.myState;
        BotState oldEnState = data.oldEnState;
        double distance = enState.getPosition().distance(data.myState.getPosition());
        double mea = HUtils.maxEscapeAngle(data.bulletVelocity());
        double wallDistanceForward = this.orbitalWallDistance(HConstants.field, myState, enState, 1, mea, true) / 1.5;
        double wallDistanceReverse = this.orbitalWallDistance(HConstants.field, myState, enState, -1, mea, true) / 1.5;
        double[] meas = this.getMea(data.bulletPower, enState, myState, data.enState.getThisTime());
        double maeWallAhead = meas[1];
        double maeWallReverse = meas[0];
        return new double[]{(enState.latVel + 8.0) / 16.0, (enState.advVel + 8.0) / 16.0, (enState.getVelocity() + 8.0) / 16.0, distance / 1300.0, distance / data.bulletVelocity() / 130.0, 1.0 / (1.0 + data.dirChangeTime), data.distLast30 / 240.0, data.distLast60 / 480.0, data.distLast120 / 960.0, (HUtils.accel(enState.getVelocity(), enState.lastVel) + 2.0) / 3.0, wallDistanceForward, wallDistanceReverse, maeWallAhead, maeWallReverse, (Utils.normalRelativeAngle((double)(enState.getHeading() - oldEnState.getHeading())) + Rules.MAX_TURN_RATE_RADIANS) / (Rules.MAX_TURN_RATE_RADIANS * 2.0), data.shotFired / 1000.0, 1.0 / (1.0 + data.velChangeTime), 1.0 / (1.0 + data.timeSinceDecelTime)};
    }

    public double[] getMea(double power, BotState en, BotState myState, long time) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.getPosition().x, en.getPosition().y, en.getHeading(), en.getVelocity(), time);
        double absBearing = HUtils.absoluteBearing(myState.getPosition(), en.getPosition());
        double distance = myState.getPosition().distance(en.getPosition());
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = myState.getPosition().distance(dir1);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = HUtils.absoluteBearing(dir1, myState.getPosition()) + 1.5707963267948966;
            angle = this.wallSmoothing(dir1, angle, -1);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = myState.getPosition().distance(dir2);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = HUtils.absoluteBearing(dir2, myState.getPosition()) - 1.5707963267948966;
            angle = this.wallSmoothing(dir2, angle, 1);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
        }
        double mea1 = Utils.normalRelativeAngle((double)(HUtils.absoluteBearing(myState.getPosition(), dir1) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(HUtils.absoluteBearing(myState.getPosition(), dir2) - absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!HConstants.field.contains(HUtils.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05 * 2.0;
        }
        return angle;
    }

    public double orbitalWallDistance(Rectangle2D.Double rect, BotState myState, BotState enemyState, int orbitDirection, double maxEscapeAngle, boolean isForward) {
        Point2D.Double enProjectedLocation;
        double wallDistance;
        if (!isForward) {
            orbitDirection *= -1;
        }
        double absoluteBearing = HUtils.absoluteBearing(myState.getPosition(), enemyState.getPosition());
        double distance = myState.getPosition().distance(enemyState.getPosition());
        for (wallDistance = 0.0; wallDistance < 1.5 * maxEscapeAngle + 0.01 && rect.contains(enProjectedLocation = HUtils.project(myState.getPosition(), absoluteBearing + (double)orbitDirection * wallDistance, distance)); wallDistance += 0.01) {
        }
        wallDistance /= maxEscapeAngle;
        wallDistance = Math.min(wallDistance, 1.5);
        return wallDistance;
    }

    @Override
    public double getAngle() {
        int kCount = 0;
        int others = this._robot.getOthers();
        this.poss.clear();
        this.possPass.clear();
        this.possDistance.clear();
        this.possPassDistance.clear();
        if (this._robot.getGunHeat() < 0.1 && this._robot.getEnergy() > 1.0) {
            if (this._isMelee) {
                this.paths.clear();
            }
            this.addPath = true;
        } else {
            this.addPath = false;
        }
        Double bestAngle = null;
        double bestDensity = Double.NEGATIVE_INFINITY;
        ArrayList<Angle> angles = new ArrayList<Angle>();
        for (Bot bot : AtomRader.enemies.values()) {
            if (!bot.alive || this._robot.isTeammate(bot.name) || bot.currentState == null) continue;
            BotState en = bot.currentState;
            boolean notNull = false;
            if (bot.lastMeleePatternDataPoint != null && others > 1) {
                notNull = true;
            }
            if (bot.lastPatternDataPoint != null && others <= 1) {
                notNull = true;
            }
            PIFData currentData = bot.lastPatternMatcherData;
            for (int i = 0; i < 22; ++i) {
                if (currentData.back == null) {
                    notNull = false;
                    break;
                }
                currentData = currentData.back;
            }
            if (!notNull) continue;
            double bandwidth = 36.0 / this._myPos.distance(en.getPosition());
            ArrayList<KNNData<PIFData>> list = null;
            if (this._isMelee) {
                int currentBotCount = this.getMeleePredictCount(en.getPosition(), others);
                list = bot.meleePatternModel.getNearestNeighborsList(bot.lastMeleePatternDataPoint, currentBotCount);
                kCount += currentBotCount;
            } else {
                list = bot.patternModel.getNearestNeighborsList(bot.lastPatternDataPoint, 4);
            }
            Point2D.Double nextMyPos = AtomRader.currentMyState.interpolateNextPos();
            double angleCount = 0.0;
            int count = 0;
            for (KNNData kNNData : list) {
                Point2D.Double pos = this.simPos((PIFData)kNNData.data, en, Rules.getBulletSpeed((double)AtomRader.calculatePower()), kNNData.distance, ++count <= 2);
                if (pos != null && HConstants.field.contains(pos)) {
                    double distance = AtomRader.nearestBot.currentState.getPosition().distance(this._myPos);
                    Angle angle = new Angle();
                    angle.angle = HUtils.absoluteBearing(nextMyPos, pos);
                    angle.weight = 1.0 / Math.sqrt(kNNData.distance) * (this._isMelee ? 1.0 / (distance * distance) : 1.0) * (this._isMelee ? 1.0 / (en.getEnergy() * en.getEnergy() + 0.01) : 1.0);
                    if (this._isMelee && bot.name.equals(AtomRader.nearestBot.name)) {
                        angle.weight *= 1440000.0 / (distance * distance);
                    }
                    angle.bandwidth = bandwidth;
                    angles.add(angle);
                }
                this.averageDistance += kNNData.distance;
                angleCount += 1.0;
            }
            this.averageDistance /= angleCount;
        }
        for (Angle a : angles) {
            double density = 0.0;
            for (Angle b : angles) {
                if (a == b) continue;
                double ux = Utils.normalRelativeAngle((double)(a.angle - b.angle)) / a.bandwidth;
                density += Math.exp(-0.5 * ux * ux) * b.weight;
            }
            if (!(density > bestDensity)) continue;
            bestAngle = a.angle;
            this.bestDistAngle = bestAngle;
            bestDensity = density;
        }
        if (bestAngle == null) {
            if (AtomRader.nearestBot != null) {
                return HUtils.absoluteBearing(this._myPos, AtomRader.nearestBot.currentState.getPosition());
            }
            return 0.0;
        }
        return bestAngle;
    }

    public int getMeleePredictCount(Point2D.Double enPos, double others) {
        int count = 2;
        double distance = this._myPos.distance(enPos);
        count = distance <= 200.0 ? (count += 6) : (count += (int)Math.max(1000.0 / distance - 1.0, 0.0));
        if (others <= 3.0) {
            count += 7;
        } else if (others <= 5.0) {
            count += 4;
        }
        return (int)HUtils.limit(1.0, (double)count, 5.0);
    }

    @Override
    public void onBulletHit(BulletHitEvent e, Wave w) {
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e, Wave w) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    @Override
    public Color getColor() {
        return Color.orange;
    }

    @Override
    public String getLabel() {
        return "PatternMatcher";
    }

    @Override
    public void onPaint(Graphics2D g) {
        this.updatePath();
        Point2D.Double target = HUtils.project(this._myPos, this.bestDistAngle, 1500.0);
        g.setColor(Color.red);
        g.drawLine((int)this._myPos.x, (int)this._myPos.y, (int)target.x, (int)target.y);
    }

    public static double standardDeviation(double[] values) {
        double avg = PatternMatcher.average(values);
        double sumSquares = 0.0;
        for (double value : values) {
            sumSquares += HUtils.square(avg - value);
        }
        return Math.sqrt(sumSquares / (double)values.length);
    }

    public static double average(double[] values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum / (double)values.length;
    }

    public static Color riskColor(double risk, double avg, double stDev, boolean safestYellow, double maxStDev) {
        if (risk < 1.0E-7 && safestYellow) {
            return Color.yellow;
        }
        return new Color((int)HUtils.limit(0.0, 255.0 * (risk - (avg - maxStDev * stDev)) / (2.0 * maxStDev * stDev), 255.0), 0, (int)HUtils.limit(0.0, 255.0 * (avg + maxStDev * stDev - risk) / (2.0 * maxStDev * stDev), 255.0), 180);
    }

    public static class PredictPath {
        public ArrayList<Point2D.Double> path = new ArrayList();
        public double eval;
        public double maxEval;
        public long counter;
        public Point2D.Double firePos;
        public long fireTime;
        public double bulletVelocity;
        public double distanceTraveled;
    }

    public class Angle {
        public double angle;
        public double weight;
        public double bandwidth;
    }
}

