/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.roboneural.net;

import dsekercioglu.roboneural.net.ActivationFunction;

public class MultiLayerPerceptron {
    double learningRate;
    int[] layerNum;
    Layer[] layers;
    int batchSize;
    int counter = 0;

    public MultiLayerPerceptron(int[] layerNum, ActivationFunction[] functions, double learningRate, int batchSize) {
        this.layerNum = layerNum;
        this.learningRate = learningRate;
        this.layers = new Layer[layerNum.length - 1];
        this.batchSize = batchSize;
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new Layer(layerNum[i], layerNum[i + 1], learningRate, functions[i]);
        }
    }

    public double[] getOutput(double[] input) {
        return this.getLeveledOutput(input, this.layers.length);
    }

    private double[] getLeveledOutput(double[] input, int stopLayer) {
        double[] output = input;
        for (int i = 0; i < stopLayer; ++i) {
            output = this.layers[i].getOutput(output);
        }
        return output;
    }

    private double[] setInputs(double[] input) {
        double[] output = input;
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i].inputs = output;
            output = this.layers[i].getOutput(output);
        }
        return output;
    }

    public void backPropogate(double[] input, double[] output) {
        int i;
        double[] predictedOutput = this.setInputs(input);
        double[] error = new double[predictedOutput.length];
        for (i = 0; i < error.length; ++i) {
            error[i] = output[i] - predictedOutput[i];
        }
        this.layers[this.layers.length - 1].error = error;
        for (i = this.layers.length - 2; i >= 0; --i) {
            double[] currentError = new double[this.layers[i].outputNum];
            for (int j = 0; j < currentError.length; ++j) {
                for (int k = 0; k < this.layers[i + 1].outputNum; ++k) {
                    int n = j;
                    currentError[n] = currentError[n] + this.layers[i + 1].error[k] * this.layers[i + 1].connections[j][k];
                }
            }
            this.layers[i].error = currentError;
        }
        for (i = 0; i < this.layers.length; ++i) {
            this.layers[i].setChange();
        }
        ++this.counter;
        if (this.counter >= this.batchSize) {
            this.counter = 0;
            for (i = 0; i < this.layers.length; ++i) {
                this.layers[i].train();
            }
        }
    }

    public void setLearningRate(double learningRate) {
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i].learningRate = this.learningRate = learningRate;
        }
    }

    public class Layer {
        int inputNum;
        int outputNum;
        double learningRate;
        double[][] connections;
        double[][] change;
        double[] error;
        double[] inputs;
        ActivationFunction af;

        public Layer(int inputNum, int outputNum, double learningRate, ActivationFunction af) {
            this.inputNum = inputNum;
            this.outputNum = outputNum;
            this.learningRate = learningRate;
            this.connections = new double[inputNum + 1][outputNum];
            this.change = new double[inputNum + 1][outputNum];
            this.af = af;
            for (int i = 0; i < inputNum + 1; ++i) {
                for (int j = 0; j < outputNum; ++j) {
                    this.connections[i][j] = Math.random() * 2.0 - 1.0;
                }
            }
        }

        public double[] getOutput(double[] input) {
            double[] output = new double[this.outputNum];
            for (int i = 0; i < this.outputNum; ++i) {
                for (int j = 0; j < this.inputNum; ++j) {
                    int n = i;
                    output[n] = output[n] + input[j] * this.connections[j][i];
                }
                int n = i;
                output[n] = output[n] + this.connections[this.inputNum][i];
                output[i] = this.af.getValue(output[i]);
            }
            return output;
        }

        public void setChange() {
            for (int i = 0; i < this.outputNum; ++i) {
                int j;
                double h = 0.0;
                for (j = 0; j < this.inputNum; ++j) {
                    h += this.inputs[j] * this.connections[j][i];
                }
                h += this.connections[this.inputNum][i];
                h = this.af.getDerivative(this.af.getValue(h));
                for (j = 0; j < this.inputNum; ++j) {
                    double[] dArray = this.change[j];
                    int n = i;
                    dArray[n] = dArray[n] + this.learningRate * this.error[i] * this.inputs[j] * h;
                }
                double[] dArray = this.change[this.inputNum];
                int n = i;
                dArray[n] = dArray[n] + this.learningRate * this.error[i] * h;
            }
        }

        public void train() {
            for (int i = 0; i < this.outputNum; ++i) {
                for (int j = 0; j < this.inputNum; ++j) {
                    double[] dArray = this.connections[j];
                    int n = i;
                    dArray[n] = dArray[n] + this.change[j][i];
                }
                double[] dArray = this.connections[this.inputNum];
                int n = i;
                dArray[n] = dArray[n] + this.change[this.inputNum][i];
            }
            this.change = new double[this.inputNum + 1][this.outputNum];
        }
    }
}

