/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.BotConstants;
import amarok.BulletLine;
import amarok.Enemy;
import amarok.FireSolution;
import amarok.Statistics;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Arena
implements Statistics,
BotConstants {
    private AdvancedRobot me;
    private Hashtable livingBots;
    private Hashtable deadBots;
    private Vector bullets;
    private Rectangle2D.Double rectNoAlert;
    private int direction;
    private Enemy enemy;
    private boolean fired;
    private boolean blocked;
    private double width;
    private double height;
    private FireSolution fireSolution;

    public AdvancedRobot getMe() {
        return this.me;
    }

    public Hashtable getLivingBots() {
        return this.livingBots;
    }

    public Hashtable getDeadBots() {
        return this.deadBots;
    }

    public void addBullet(BulletLine bullet) {
        this.bullets.add(bullet);
    }

    public Vector getAllBullets() {
        return this.bullets;
    }

    public Vector getNearestBullets(long now, double X, double Y, int sum) {
        Object[] bulletArray = new BulletLine[this.bullets.size()];
        int i = 0;
        while (i < this.bullets.size()) {
            BulletLine bullet = (BulletLine)this.bullets.elementAt(i);
            bullet.setX(X);
            bullet.setY(Y);
            bulletArray[i] = bullet;
            ++i;
        }
        System.out.println(this.bullets.size());
        Arrays.sort(bulletArray);
        System.out.println("sorted");
        Vector<Object> v = new Vector<Object>();
        int i2 = 0;
        while (i2 < sum && i2 < this.bullets.size()) {
            v.add(bulletArray[i2]);
            ++i2;
        }
        return v;
    }

    public boolean isAlert(double x, double y) {
        return !this.rectNoAlert.contains(x, y);
    }

    public int reverseDirection() {
        this.direction *= -1;
        return this.direction;
    }

    public int setDirection(int i) {
        this.direction = i;
        return this.direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public Enemy getEnemy() {
        return this.enemy;
    }

    public void setEnemy(Enemy nme) {
        this.enemy = nme;
    }

    public void setFired(boolean f) {
        this.fired = f;
    }

    public boolean isFired() {
        return this.fired;
    }

    public void setBlocked(boolean b) {
        this.blocked = b;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public FireSolution getFireSolution() {
        return this.fireSolution;
    }

    public void setFireSolution(FireSolution f) {
        this.fireSolution = f;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        String name = e.getName();
        Enemy nme = null;
        if (this.livingBots.containsKey(name)) {
            nme = (Enemy)this.livingBots.get(name);
        } else {
            nme = new Enemy(name, this);
            this.livingBots.put(name, nme);
        }
        nme.onScannedRobot(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Enemy nme = (Enemy)this.livingBots.get(e.getName());
        if (nme != null) {
            nme.onHitByBullet(e);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        Enemy nme = (Enemy)this.livingBots.get(e.getName());
        if (nme != null) {
            nme.onBulletHit(e);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        System.out.println(e.getName() + " has died");
        Enemy nme = (Enemy)this.livingBots.remove(e.getName());
        this.deadBots.put(e.getName(), nme);
    }

    public void onDeath(DeathEvent e) {
        this.fireSolution.setGo(false);
    }

    public void onWin(WinEvent e) {
        this.fireSolution.setGo(false);
    }

    public void dump() {
        Enemy nme;
        System.out.println("--- statistics for " + this.toString());
        Enumeration e = this.livingBots.elements();
        while (e.hasMoreElements()) {
            nme = (Enemy)e.nextElement();
            nme.dump();
        }
        e = this.deadBots.elements();
        while (e.hasMoreElements()) {
            nme = (Enemy)e.nextElement();
            nme.dump();
        }
    }

    public Arena(AdvancedRobot bot, double w, double h) {
        this.me = bot;
        this.width = w;
        this.height = h;
        this.enemy = null;
        this.direction = 1;
        this.livingBots = new Hashtable();
        this.deadBots = new Hashtable();
        this.bullets = new Vector();
        double dx = this.width * 0.2;
        double dy = this.height * 0.2;
        this.rectNoAlert = new Rectangle2D.Double(dx, dy, this.width - 2.0 * dx, this.height - 2.0 * dy);
        this.fireSolution = new FireSolution(this);
        this.setFired(false);
        this.setBlocked(false);
    }
}

