/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.BotConstants;
import java.awt.geom.Point2D;

public class BulletLine
implements BotConstants {
    private String name;
    private long scanningTime;
    private long expiringTime;
    private double x;
    private double y;
    private double heading;
    private double velocity;
    private double X;
    private double Y;

    public Point2D.Double getPointAtTime(long now) {
        double dTime = now - this.scanningTime;
        double distance = dTime * this.velocity;
        double dx = Math.sin(this.heading) * distance;
        double dy = Math.cos(this.heading) * distance;
        return new Point2D.Double(this.x + dx, this.y + dy);
    }

    public Point2D.Double getPointAtStart() {
        return new Point2D.Double(this.x, this.y);
    }

    public boolean isActive(long now) {
        return now < this.expiringTime;
    }

    public String toString() {
        return this.name + ": started at " + this.scanningTime + " (" + this.expiringTime + ") ";
    }

    public void setX(double d) {
        this.X = d;
    }

    public void setY(double d) {
        this.Y = d;
    }

    public double getHeading() {
        return this.heading;
    }

    public String getName() {
        return this.name;
    }

    public BulletLine(String name, double x, double y, double heading, double velocity, long scanningTime, long expiringTime) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.heading = heading;
        this.velocity = velocity;
        this.scanningTime = scanningTime;
        this.expiringTime = expiringTime;
        this.X = 0.0;
        this.Y = 0.0;
    }
}

