/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import robocode.ScannedRobotEvent;
import wcsv.mega.DamageTracker;
import wcsv.mega.Location;
import wcsv.mega.MyInfo;
import wcsv.mega.Utils;

public class BaseScanInfo {
    private double heading;
    private double bearing;
    private double velocity;
    private double energy;
    private double distance;
    private double orbit;
    private double energyGain;
    private long time;
    private Location loc;
    private String name;

    public BaseScanInfo(MyInfo me, ScannedRobotEvent scan) {
        this.heading = scan.getHeadingRadians();
        this.bearing = Utils.absAngle(scan.getBearingRadians() + me.getHeadingRadians());
        this.velocity = scan.getVelocity();
        this.energy = scan.getEnergy();
        this.distance = scan.getDistance();
        this.time = scan.getTime();
        this.loc = me.getLoc().project(this.bearing, this.distance);
        this.name = scan.getName();
        this.energyGain = 0.0;
        double lv = this.getLatVel();
        this.orbit = lv < 0.0 ? -1.0 : (lv > 0.0 ? 1.0 : 0.0);
    }

    public BaseScanInfo(BaseScanInfo other, MyInfo me) {
        this.heading = me.getHeadingRadians();
        this.bearing = Utils.absAngle(other.bearing - Math.PI);
        this.velocity = me.getVelocity();
        this.energy = me.getEnergy();
        this.distance = other.getDistance();
        this.time = me.getTime();
        this.loc = me.getLoc().copy();
        this.name = null;
        double lv = this.getLatVel();
        this.orbit = lv < 0.0 ? -1.0 : (lv > 0.0 ? 1.0 : 0.0);
        this.energyGain = 0.0;
    }

    public BaseScanInfo(BaseScanInfo cp) {
        this.heading = cp.heading;
        this.bearing = cp.bearing;
        this.velocity = cp.velocity;
        this.energy = cp.energy;
        this.distance = cp.distance;
        this.time = cp.time;
        this.loc = cp.loc.copy();
        this.name = new String(cp.name);
        this.orbit = cp.orbit;
        this.energyGain = cp.energyGain;
    }

    public void hitByBullet(double power) {
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        this.energyGain -= damage;
        DamageTracker.giveDamage(damage, this.getDistance());
    }

    public void madeBulletHit(double power) {
        double damage = 3.0 * power;
        this.energyGain += damage;
        DamageTracker.takeDamage(damage, this.getDistance());
    }

    public double getOrbit() {
        return this.orbit;
    }

    public void setOrbit(double orbit) {
        this.orbit = orbit;
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getHeading() {
        return this.heading;
    }

    public Location getLoc() {
        return this.loc;
    }

    public long getTime() {
        return this.time;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public String getName() {
        return this.name;
    }

    public double getLatVel() {
        return Math.sin(this.heading - this.bearing) * this.velocity;
    }

    public double getAdvVel() {
        return -Math.cos(this.heading - this.bearing) * this.velocity;
    }

    public double getEnergyGain() {
        return this.energyGain;
    }
}

