/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import java.awt.Graphics;
import robocode.BulletHitEvent;
import wcsv.mega.MyInfo;
import wcsv.mega.ScanInfo;
import wcsv.mega.ScanManager;
import wcsv.mega.Utils;

public abstract class Gun {
    protected MyInfo me;
    protected ScanManager scans;
    protected boolean firedThisTick;
    protected boolean aim;
    protected double bulletPower;
    protected static final double MIN_GUN_TURN = 0.001;

    public Gun(MyInfo me, ScanManager scans) {
        this.me = me;
        this.scans = scans;
        this.firedThisTick = false;
        this.aim = false;
        this.bulletPower = 3.0;
    }

    public abstract void onScan(ScanInfo var1);

    public abstract void doGun(ScanInfo var1);

    public abstract void onBulletHit(BulletHitEvent var1);

    protected abstract double getAngle(ScanInfo var1);

    protected abstract double getBulletPower(ScanInfo var1);

    protected void aimAndFire(ScanInfo target) {
        if (target != null) {
            this.bulletPower = this.getBulletPower(target);
            this.firedThisTick = false;
            if (this.me.getGunHeat() > this.me.getGunCoolingRate()) {
                this.me.setTurnGunRightRadians(Utils.relAngle(target.last().getBearing() - this.me.getGunHeadingRadians()));
                this.aim = false;
            } else if (this.aim && Math.abs(this.me.getGunTurnRemainingRadians()) < 0.001 && this.me.setFireBullet(this.bulletPower) != null) {
                this.aim = false;
                this.firedThisTick = true;
            } else {
                this.me.setTurnGunRightRadians(Utils.relAngle(this.getAngle(target) - this.me.getGunHeadingRadians()));
                this.aim = true;
            }
        }
    }

    protected void reset(MyInfo newMe, ScanManager newScans) {
        this.me = newMe;
        this.scans = newScans;
    }

    public abstract void draw(Graphics var1);
}

