/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Constraints;
import pedersen.core.Snapshot;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringAngle;
import pedersen.divination.WaveInboundImpl;
import pedersen.misc.Metrics;
import pedersen.misc.VaultBase;
import pedersen.physics.StaticPosition;

public class WaveInboundBank
extends VaultBase {
    public static final WaveInboundBank singleton = new WaveInboundBank();

    private WaveInboundBank() {
    }

    public void process(long time) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CombatWave wave = (CombatWave)iterator.next();
            wave.isActive(time);
        }
    }

    public void removeInactiveWaves() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (((CombatWave)iterator.next()).isActive()) continue;
            this.remove(iterator);
        }
    }

    public void cancelAll() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CombatWave wave = (CombatWave)iterator.next();
            Iterator firingAngleIterator = wave.getFiringAngleIterator();
            while (firingAngleIterator.hasNext()) {
                FiringAngle firingAngle = (FiringAngle)firingAngleIterator.next();
                firingAngle.getTargetingStatistics().incrementCancelled();
                firingAngleIterator.remove();
            }
        }
    }

    public void roundTeardown() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CombatWave wave = (CombatWave)iterator.next();
            wave.setInactive();
        }
        this.purge();
    }

    public void onPaint(Graphics2D console) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((CombatWave)iterator.next()).onPaint(console);
        }
    }

    public void add(WaveInboundImpl wave) {
        super.add(wave);
        Metrics.addInboundWave();
    }

    public WaveInboundImpl findAssociatedWave(Snapshot bullet) {
        WaveInboundImpl associatedWave = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && associatedWave == null) {
            WaveInboundImpl wave = (WaveInboundImpl)iterator.next();
            if (!Constraints.areEqual(wave.getVelocity(), bullet.getVelocity()) || !wave.threatensRobot(wave.getVictim().getHistoricalSnapshot(1), bullet.getTime() - 1L)) continue;
            associatedWave = wave;
        }
        return associatedWave;
    }

    public WaveInboundImpl getFirstWaveToImpact(StaticPosition position, long time) {
        WaveInboundImpl firstWaveToImpact = null;
        double firstWaveTimeToImpact = Double.POSITIVE_INFINITY;
        Iterator iterator = singleton.iterator();
        while (iterator.hasNext()) {
            WaveInboundImpl wave = (WaveInboundImpl)iterator.next();
            double timeToImpact = (wave.getDistance(position) - wave.getRadius(time)) / wave.getVelocity();
            if (!(timeToImpact < firstWaveTimeToImpact)) continue;
            firstWaveToImpact = wave;
            firstWaveTimeToImpact = timeToImpact;
        }
        return firstWaveToImpact;
    }

    public List getCopyOfWaveList() {
        return new ArrayList(this.vault);
    }
}

