/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import java.util.Iterator;
import java.util.List;
import pedersen.core.Combatant;
import pedersen.core.Constraints;
import pedersen.core.Snapshot;
import pedersen.divination.CombatWave;
import pedersen.divination.WaveInboundImpl;
import pedersen.misc.Arena;
import pedersen.misc.ShortestRoute;
import pedersen.physics.Projection;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.physics.StaticVelocity;
import pedersen.systems.DrivingMethod;
import pedersen.tactics.movement.MovementMethod;
import pedersen.tactics.movement.MovementMethodSet;

public class DrivingMethodStandardImpl
implements DrivingMethod {
    private List ambientMovementMethods;
    private MovementMethod dynamicMovementMethod;
    private boolean performanceStatisticsTracking = false;

    public DrivingMethodStandardImpl(MovementMethodSet movementMethods) {
        this.ambientMovementMethods = movementMethods.getAmbientMovementMethods();
        this.dynamicMovementMethod = movementMethods.getOptimalMovementMethod(0);
        if (this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.activate(Combatant.getCombatant());
        }
    }

    public DrivingMethodStandardImpl(MovementMethodSet movementMethods, int gracePeriod) {
        this.ambientMovementMethods = movementMethods.getAmbientMovementMethods();
        this.dynamicMovementMethod = movementMethods.getOptimalMovementMethod(gracePeriod);
        if (this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.activate(Combatant.getCombatant());
        }
    }

    public StaticVector operate(Snapshot combatant, Snapshot target, long time) {
        StaticVelocity movementVector = null;
        boolean isExclusive = false;
        if (this.dynamicMovementMethod != null) {
            movementVector = this.dynamicMovementMethod.getVector(combatant, target, time);
            isExclusive = this.dynamicMovementMethod.isExclusive();
        }
        if (!isExclusive) {
            Iterator iterator = this.ambientMovementMethods.iterator();
            while (iterator.hasNext()) {
                MovementMethod movementMethod = (MovementMethod)iterator.next();
                movementVector = StaticVectorImpl.getCompositeVector((StaticVector)movementVector, movementMethod.getVector(combatant, target, time));
            }
        }
        if (movementVector == null) {
            movementVector = new StaticVectorImpl(0.0, 0.0);
        } else if (movementVector.getVelocity() != 0.0) {
            StaticPositionImpl targetPosition = new StaticPositionImpl((StaticPosition)combatant, (StaticVector)movementVector);
            movementVector = DrivingMethodStandardImpl.operate(combatant, (StaticPosition)targetPosition);
        } else {
            double relativeHeading = combatant.getRelativeAngle(movementVector.getHeading());
            movementVector = new StaticVectorImpl(relativeHeading, movementVector.getVelocity());
        }
        return movementVector;
    }

    public static StaticVector operate(Snapshot a, StaticPosition b) {
        return DrivingMethodStandardImpl.operate(a, a.getHeading(), a.getVelocity(), b);
    }

    public static StaticVector operate(Projection a, StaticPosition b) {
        return DrivingMethodStandardImpl.operate(a.getStaticPosition(), a.getHeading(), a.getVelocity(), b);
    }

    private static StaticVector operate(StaticPosition chassisPosition, double chassisHeading, double chassisVelocity, StaticPosition targetPosition) {
        double velocity = 0.0;
        double deltaHeading = 0.0;
        if (targetPosition != null) {
            targetPosition = Arena.adjustOutOfBoundsTarget(chassisPosition, targetPosition);
            velocity = ShortestRoute.getVelocity(chassisPosition, chassisHeading, chassisVelocity, targetPosition);
            deltaHeading = StaticHeadingImpl.getRelativeAngle(chassisHeading, chassisPosition.getBearing(targetPosition));
            if (!Constraints.isInRange(-1.5707963267948966, deltaHeading, 1.5707963267948966)) {
                deltaHeading = StaticHeadingImpl.getOpposedAngle(deltaHeading);
                velocity = -velocity;
            }
        }
        return new StaticVectorImpl(deltaHeading, velocity);
    }

    public void setPerformanceStatisticsTracking(boolean on) {
        this.performanceStatisticsTracking = on;
    }

    public void recordTime() {
        if (this.performanceStatisticsTracking && this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.recordTime();
        }
    }

    public void onHitByBullet(WaveInboundImpl wave) {
        if (this.performanceStatisticsTracking && this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.onHitByBullet(wave);
        }
    }

    public void onEnemyFire(CombatWave wave) {
        if (this.performanceStatisticsTracking && this.dynamicMovementMethod != null) {
            this.dynamicMovementMethod.onEnemyFire(wave);
        }
    }
}

